/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceagreement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplaceagreement.model.ScheduleItem;
import com.amazonaws.services.marketplaceagreement.model.transform.PaymentScheduleTermMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PaymentScheduleTerm
implements Serializable,
Cloneable,
StructuredPojo {
    private String currencyCode;
    private List<ScheduleItem> schedule;
    private String type;

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public PaymentScheduleTerm withCurrencyCode(String currencyCode) {
        this.setCurrencyCode(currencyCode);
        return this;
    }

    public List<ScheduleItem> getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Collection<ScheduleItem> schedule) {
        if (schedule == null) {
            this.schedule = null;
            return;
        }
        this.schedule = new ArrayList<ScheduleItem>(schedule);
    }

    public PaymentScheduleTerm withSchedule(ScheduleItem ... schedule) {
        if (this.schedule == null) {
            this.setSchedule(new ArrayList<ScheduleItem>(schedule.length));
        }
        for (ScheduleItem ele : schedule) {
            this.schedule.add(ele);
        }
        return this;
    }

    public PaymentScheduleTerm withSchedule(Collection<ScheduleItem> schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public PaymentScheduleTerm withType(String type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.getCurrencyCode()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentScheduleTerm)) {
            return false;
        }
        PaymentScheduleTerm other = (PaymentScheduleTerm)obj;
        if (other.getCurrencyCode() == null ^ this.getCurrencyCode() == null) {
            return false;
        }
        if (other.getCurrencyCode() != null && !other.getCurrencyCode().equals(this.getCurrencyCode())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrencyCode() == null ? 0 : this.getCurrencyCode().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public PaymentScheduleTerm clone() {
        try {
            return (PaymentScheduleTerm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PaymentScheduleTermMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

