/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceagreement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.marketplaceagreement.model.Filter;
import com.amazonaws.services.marketplaceagreement.model.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchAgreementsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalog;
    private List<Filter> filters;
    private Integer maxResults;
    private String nextToken;
    private Sort sort;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SearchAgreementsRequest withCatalog(String catalog) {
        this.setCatalog(catalog);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public SearchAgreementsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchAgreementsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchAgreementsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchAgreementsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Sort getSort() {
        return this.sort;
    }

    public SearchAgreementsRequest withSort(Sort sort) {
        this.setSort(sort);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalog() != null) {
            sb.append("Catalog: ").append(this.getCatalog()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSort() != null) {
            sb.append("Sort: ").append(this.getSort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAgreementsRequest)) {
            return false;
        }
        SearchAgreementsRequest other = (SearchAgreementsRequest)obj;
        if (other.getCatalog() == null ^ this.getCatalog() == null) {
            return false;
        }
        if (other.getCatalog() != null && !other.getCatalog().equals(this.getCatalog())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSort() == null ^ this.getSort() == null) {
            return false;
        }
        return other.getSort() == null || other.getSort().equals(this.getSort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalog() == null ? 0 : this.getCatalog().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSort() == null ? 0 : this.getSort().hashCode());
        return hashCode;
    }

    public SearchAgreementsRequest clone() {
        return (SearchAgreementsRequest)super.clone();
    }
}

