/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AccelerationSettings;
import com.amazonaws.services.mediaconvert.model.BillingTagsSource;
import com.amazonaws.services.mediaconvert.model.JobPhase;
import com.amazonaws.services.mediaconvert.model.JobSettings;
import com.amazonaws.services.mediaconvert.model.JobStatus;
import com.amazonaws.services.mediaconvert.model.OutputGroupDetail;
import com.amazonaws.services.mediaconvert.model.SimulateReservedQueue;
import com.amazonaws.services.mediaconvert.model.StatusUpdateInterval;
import com.amazonaws.services.mediaconvert.model.Timing;
import com.amazonaws.services.mediaconvert.model.transform.JobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Job
implements Serializable,
Cloneable,
StructuredPojo {
    private AccelerationSettings accelerationSettings;
    private String arn;
    private String billingTagsSource;
    private Date createdAt;
    private String currentPhase;
    private Integer errorCode;
    private String errorMessage;
    private String id;
    private Integer jobPercentComplete;
    private String jobTemplate;
    private List<OutputGroupDetail> outputGroupDetails;
    private Integer priority;
    private String queue;
    private Integer retryCount;
    private String role;
    private JobSettings settings;
    private String simulateReservedQueue;
    private String status;
    private String statusUpdateInterval;
    private Timing timing;
    private Map<String, String> userMetadata;

    public void setAccelerationSettings(AccelerationSettings accelerationSettings) {
        this.accelerationSettings = accelerationSettings;
    }

    public AccelerationSettings getAccelerationSettings() {
        return this.accelerationSettings;
    }

    public Job withAccelerationSettings(AccelerationSettings accelerationSettings) {
        this.setAccelerationSettings(accelerationSettings);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Job withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setBillingTagsSource(String billingTagsSource) {
        this.billingTagsSource = billingTagsSource;
    }

    public String getBillingTagsSource() {
        return this.billingTagsSource;
    }

    public Job withBillingTagsSource(String billingTagsSource) {
        this.setBillingTagsSource(billingTagsSource);
        return this;
    }

    public Job withBillingTagsSource(BillingTagsSource billingTagsSource) {
        this.billingTagsSource = billingTagsSource.toString();
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Job withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public Job withCurrentPhase(String currentPhase) {
        this.setCurrentPhase(currentPhase);
        return this;
    }

    public Job withCurrentPhase(JobPhase currentPhase) {
        this.currentPhase = currentPhase.toString();
        return this;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public Job withErrorCode(Integer errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Job withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Job withId(String id) {
        this.setId(id);
        return this;
    }

    public void setJobPercentComplete(Integer jobPercentComplete) {
        this.jobPercentComplete = jobPercentComplete;
    }

    public Integer getJobPercentComplete() {
        return this.jobPercentComplete;
    }

    public Job withJobPercentComplete(Integer jobPercentComplete) {
        this.setJobPercentComplete(jobPercentComplete);
        return this;
    }

    public void setJobTemplate(String jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    public String getJobTemplate() {
        return this.jobTemplate;
    }

    public Job withJobTemplate(String jobTemplate) {
        this.setJobTemplate(jobTemplate);
        return this;
    }

    public List<OutputGroupDetail> getOutputGroupDetails() {
        return this.outputGroupDetails;
    }

    public void setOutputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails) {
        if (outputGroupDetails == null) {
            this.outputGroupDetails = null;
            return;
        }
        this.outputGroupDetails = new ArrayList<OutputGroupDetail>(outputGroupDetails);
    }

    public Job withOutputGroupDetails(OutputGroupDetail ... outputGroupDetails) {
        if (this.outputGroupDetails == null) {
            this.setOutputGroupDetails(new ArrayList<OutputGroupDetail>(outputGroupDetails.length));
        }
        for (OutputGroupDetail ele : outputGroupDetails) {
            this.outputGroupDetails.add(ele);
        }
        return this;
    }

    public Job withOutputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails) {
        this.setOutputGroupDetails(outputGroupDetails);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Job withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getQueue() {
        return this.queue;
    }

    public Job withQueue(String queue) {
        this.setQueue(queue);
        return this;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Job withRetryCount(Integer retryCount) {
        this.setRetryCount(retryCount);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Job withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setSettings(JobSettings settings) {
        this.settings = settings;
    }

    public JobSettings getSettings() {
        return this.settings;
    }

    public Job withSettings(JobSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public void setSimulateReservedQueue(String simulateReservedQueue) {
        this.simulateReservedQueue = simulateReservedQueue;
    }

    public String getSimulateReservedQueue() {
        return this.simulateReservedQueue;
    }

    public Job withSimulateReservedQueue(String simulateReservedQueue) {
        this.setSimulateReservedQueue(simulateReservedQueue);
        return this;
    }

    public Job withSimulateReservedQueue(SimulateReservedQueue simulateReservedQueue) {
        this.simulateReservedQueue = simulateReservedQueue.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Job withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Job withStatus(JobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusUpdateInterval(String statusUpdateInterval) {
        this.statusUpdateInterval = statusUpdateInterval;
    }

    public String getStatusUpdateInterval() {
        return this.statusUpdateInterval;
    }

    public Job withStatusUpdateInterval(String statusUpdateInterval) {
        this.setStatusUpdateInterval(statusUpdateInterval);
        return this;
    }

    public Job withStatusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
        this.statusUpdateInterval = statusUpdateInterval.toString();
        return this;
    }

    public void setTiming(Timing timing) {
        this.timing = timing;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public Job withTiming(Timing timing) {
        this.setTiming(timing);
        return this;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public Job withUserMetadata(Map<String, String> userMetadata) {
        this.setUserMetadata(userMetadata);
        return this;
    }

    public Job addUserMetadataEntry(String key, String value) {
        if (null == this.userMetadata) {
            this.userMetadata = new HashMap<String, String>();
        }
        if (this.userMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userMetadata.put(key, value);
        return this;
    }

    public Job clearUserMetadataEntries() {
        this.userMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccelerationSettings() != null) {
            sb.append("AccelerationSettings: ").append(this.getAccelerationSettings()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getBillingTagsSource() != null) {
            sb.append("BillingTagsSource: ").append(this.getBillingTagsSource()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getCurrentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.getCurrentPhase()).append(",");
        }
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getJobPercentComplete() != null) {
            sb.append("JobPercentComplete: ").append(this.getJobPercentComplete()).append(",");
        }
        if (this.getJobTemplate() != null) {
            sb.append("JobTemplate: ").append(this.getJobTemplate()).append(",");
        }
        if (this.getOutputGroupDetails() != null) {
            sb.append("OutputGroupDetails: ").append(this.getOutputGroupDetails()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getQueue() != null) {
            sb.append("Queue: ").append(this.getQueue()).append(",");
        }
        if (this.getRetryCount() != null) {
            sb.append("RetryCount: ").append(this.getRetryCount()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getSimulateReservedQueue() != null) {
            sb.append("SimulateReservedQueue: ").append(this.getSimulateReservedQueue()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusUpdateInterval() != null) {
            sb.append("StatusUpdateInterval: ").append(this.getStatusUpdateInterval()).append(",");
        }
        if (this.getTiming() != null) {
            sb.append("Timing: ").append(this.getTiming()).append(",");
        }
        if (this.getUserMetadata() != null) {
            sb.append("UserMetadata: ").append(this.getUserMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getAccelerationSettings() == null ^ this.getAccelerationSettings() == null) {
            return false;
        }
        if (other.getAccelerationSettings() != null && !other.getAccelerationSettings().equals(this.getAccelerationSettings())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getBillingTagsSource() == null ^ this.getBillingTagsSource() == null) {
            return false;
        }
        if (other.getBillingTagsSource() != null && !other.getBillingTagsSource().equals(this.getBillingTagsSource())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getCurrentPhase() == null ^ this.getCurrentPhase() == null) {
            return false;
        }
        if (other.getCurrentPhase() != null && !other.getCurrentPhase().equals(this.getCurrentPhase())) {
            return false;
        }
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getJobPercentComplete() == null ^ this.getJobPercentComplete() == null) {
            return false;
        }
        if (other.getJobPercentComplete() != null && !other.getJobPercentComplete().equals(this.getJobPercentComplete())) {
            return false;
        }
        if (other.getJobTemplate() == null ^ this.getJobTemplate() == null) {
            return false;
        }
        if (other.getJobTemplate() != null && !other.getJobTemplate().equals(this.getJobTemplate())) {
            return false;
        }
        if (other.getOutputGroupDetails() == null ^ this.getOutputGroupDetails() == null) {
            return false;
        }
        if (other.getOutputGroupDetails() != null && !other.getOutputGroupDetails().equals(this.getOutputGroupDetails())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getQueue() == null ^ this.getQueue() == null) {
            return false;
        }
        if (other.getQueue() != null && !other.getQueue().equals(this.getQueue())) {
            return false;
        }
        if (other.getRetryCount() == null ^ this.getRetryCount() == null) {
            return false;
        }
        if (other.getRetryCount() != null && !other.getRetryCount().equals(this.getRetryCount())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getSimulateReservedQueue() == null ^ this.getSimulateReservedQueue() == null) {
            return false;
        }
        if (other.getSimulateReservedQueue() != null && !other.getSimulateReservedQueue().equals(this.getSimulateReservedQueue())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusUpdateInterval() == null ^ this.getStatusUpdateInterval() == null) {
            return false;
        }
        if (other.getStatusUpdateInterval() != null && !other.getStatusUpdateInterval().equals(this.getStatusUpdateInterval())) {
            return false;
        }
        if (other.getTiming() == null ^ this.getTiming() == null) {
            return false;
        }
        if (other.getTiming() != null && !other.getTiming().equals(this.getTiming())) {
            return false;
        }
        if (other.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        return other.getUserMetadata() == null || other.getUserMetadata().equals(this.getUserMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccelerationSettings() == null ? 0 : this.getAccelerationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getBillingTagsSource() == null ? 0 : this.getBillingTagsSource().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPhase() == null ? 0 : this.getCurrentPhase().hashCode());
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getJobPercentComplete() == null ? 0 : this.getJobPercentComplete().hashCode());
        hashCode = 31 * hashCode + (this.getJobTemplate() == null ? 0 : this.getJobTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getOutputGroupDetails() == null ? 0 : this.getOutputGroupDetails().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getQueue() == null ? 0 : this.getQueue().hashCode());
        hashCode = 31 * hashCode + (this.getRetryCount() == null ? 0 : this.getRetryCount().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSimulateReservedQueue() == null ? 0 : this.getSimulateReservedQueue().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusUpdateInterval() == null ? 0 : this.getStatusUpdateInterval().hashCode());
        hashCode = 31 * hashCode + (this.getTiming() == null ? 0 : this.getTiming().hashCode());
        hashCode = 31 * hashCode + (this.getUserMetadata() == null ? 0 : this.getUserMetadata().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

