/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.JobMessages;
import java.util.List;

@SdkInternalApi
public class JobMessagesMarshaller {
    private static final MarshallingInfo<List> INFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("info").build();
    private static final MarshallingInfo<List> WARNING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warning").build();
    private static final JobMessagesMarshaller instance = new JobMessagesMarshaller();

    public static JobMessagesMarshaller getInstance() {
        return instance;
    }

    public void marshall(JobMessages jobMessages, ProtocolMarshaller protocolMarshaller) {
        if (jobMessages == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(jobMessages.getInfo(), INFO_BINDING);
            protocolMarshaller.marshall(jobMessages.getWarning(), WARNING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

