/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AudioDefaultSelection;
import com.amazonaws.services.mediaconvert.model.AudioSelectorType;
import com.amazonaws.services.mediaconvert.model.HlsRenditionGroupSettings;
import com.amazonaws.services.mediaconvert.model.LanguageCode;
import com.amazonaws.services.mediaconvert.model.RemixSettings;
import com.amazonaws.services.mediaconvert.model.transform.AudioSelectorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AudioSelector
implements Serializable,
Cloneable,
StructuredPojo {
    private String customLanguageCode;
    private String defaultSelection;
    private String externalAudioFileInput;
    private HlsRenditionGroupSettings hlsRenditionGroupSettings;
    private String languageCode;
    private Integer offset;
    private List<Integer> pids;
    private Integer programSelection;
    private RemixSettings remixSettings;
    private String selectorType;
    private List<Integer> tracks;

    public void setCustomLanguageCode(String customLanguageCode) {
        this.customLanguageCode = customLanguageCode;
    }

    public String getCustomLanguageCode() {
        return this.customLanguageCode;
    }

    public AudioSelector withCustomLanguageCode(String customLanguageCode) {
        this.setCustomLanguageCode(customLanguageCode);
        return this;
    }

    public void setDefaultSelection(String defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public String getDefaultSelection() {
        return this.defaultSelection;
    }

    public AudioSelector withDefaultSelection(String defaultSelection) {
        this.setDefaultSelection(defaultSelection);
        return this;
    }

    public AudioSelector withDefaultSelection(AudioDefaultSelection defaultSelection) {
        this.defaultSelection = defaultSelection.toString();
        return this;
    }

    public void setExternalAudioFileInput(String externalAudioFileInput) {
        this.externalAudioFileInput = externalAudioFileInput;
    }

    public String getExternalAudioFileInput() {
        return this.externalAudioFileInput;
    }

    public AudioSelector withExternalAudioFileInput(String externalAudioFileInput) {
        this.setExternalAudioFileInput(externalAudioFileInput);
        return this;
    }

    public void setHlsRenditionGroupSettings(HlsRenditionGroupSettings hlsRenditionGroupSettings) {
        this.hlsRenditionGroupSettings = hlsRenditionGroupSettings;
    }

    public HlsRenditionGroupSettings getHlsRenditionGroupSettings() {
        return this.hlsRenditionGroupSettings;
    }

    public AudioSelector withHlsRenditionGroupSettings(HlsRenditionGroupSettings hlsRenditionGroupSettings) {
        this.setHlsRenditionGroupSettings(hlsRenditionGroupSettings);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public AudioSelector withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public AudioSelector withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public AudioSelector withOffset(Integer offset) {
        this.setOffset(offset);
        return this;
    }

    public List<Integer> getPids() {
        return this.pids;
    }

    public void setPids(Collection<Integer> pids) {
        if (pids == null) {
            this.pids = null;
            return;
        }
        this.pids = new ArrayList<Integer>(pids);
    }

    public AudioSelector withPids(Integer ... pids) {
        if (this.pids == null) {
            this.setPids(new ArrayList<Integer>(pids.length));
        }
        for (Integer ele : pids) {
            this.pids.add(ele);
        }
        return this;
    }

    public AudioSelector withPids(Collection<Integer> pids) {
        this.setPids(pids);
        return this;
    }

    public void setProgramSelection(Integer programSelection) {
        this.programSelection = programSelection;
    }

    public Integer getProgramSelection() {
        return this.programSelection;
    }

    public AudioSelector withProgramSelection(Integer programSelection) {
        this.setProgramSelection(programSelection);
        return this;
    }

    public void setRemixSettings(RemixSettings remixSettings) {
        this.remixSettings = remixSettings;
    }

    public RemixSettings getRemixSettings() {
        return this.remixSettings;
    }

    public AudioSelector withRemixSettings(RemixSettings remixSettings) {
        this.setRemixSettings(remixSettings);
        return this;
    }

    public void setSelectorType(String selectorType) {
        this.selectorType = selectorType;
    }

    public String getSelectorType() {
        return this.selectorType;
    }

    public AudioSelector withSelectorType(String selectorType) {
        this.setSelectorType(selectorType);
        return this;
    }

    public AudioSelector withSelectorType(AudioSelectorType selectorType) {
        this.selectorType = selectorType.toString();
        return this;
    }

    public List<Integer> getTracks() {
        return this.tracks;
    }

    public void setTracks(Collection<Integer> tracks) {
        if (tracks == null) {
            this.tracks = null;
            return;
        }
        this.tracks = new ArrayList<Integer>(tracks);
    }

    public AudioSelector withTracks(Integer ... tracks) {
        if (this.tracks == null) {
            this.setTracks(new ArrayList<Integer>(tracks.length));
        }
        for (Integer ele : tracks) {
            this.tracks.add(ele);
        }
        return this;
    }

    public AudioSelector withTracks(Collection<Integer> tracks) {
        this.setTracks(tracks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomLanguageCode() != null) {
            sb.append("CustomLanguageCode: ").append(this.getCustomLanguageCode()).append(",");
        }
        if (this.getDefaultSelection() != null) {
            sb.append("DefaultSelection: ").append(this.getDefaultSelection()).append(",");
        }
        if (this.getExternalAudioFileInput() != null) {
            sb.append("ExternalAudioFileInput: ").append(this.getExternalAudioFileInput()).append(",");
        }
        if (this.getHlsRenditionGroupSettings() != null) {
            sb.append("HlsRenditionGroupSettings: ").append(this.getHlsRenditionGroupSettings()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getOffset() != null) {
            sb.append("Offset: ").append(this.getOffset()).append(",");
        }
        if (this.getPids() != null) {
            sb.append("Pids: ").append(this.getPids()).append(",");
        }
        if (this.getProgramSelection() != null) {
            sb.append("ProgramSelection: ").append(this.getProgramSelection()).append(",");
        }
        if (this.getRemixSettings() != null) {
            sb.append("RemixSettings: ").append(this.getRemixSettings()).append(",");
        }
        if (this.getSelectorType() != null) {
            sb.append("SelectorType: ").append(this.getSelectorType()).append(",");
        }
        if (this.getTracks() != null) {
            sb.append("Tracks: ").append(this.getTracks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector)obj;
        if (other.getCustomLanguageCode() == null ^ this.getCustomLanguageCode() == null) {
            return false;
        }
        if (other.getCustomLanguageCode() != null && !other.getCustomLanguageCode().equals(this.getCustomLanguageCode())) {
            return false;
        }
        if (other.getDefaultSelection() == null ^ this.getDefaultSelection() == null) {
            return false;
        }
        if (other.getDefaultSelection() != null && !other.getDefaultSelection().equals(this.getDefaultSelection())) {
            return false;
        }
        if (other.getExternalAudioFileInput() == null ^ this.getExternalAudioFileInput() == null) {
            return false;
        }
        if (other.getExternalAudioFileInput() != null && !other.getExternalAudioFileInput().equals(this.getExternalAudioFileInput())) {
            return false;
        }
        if (other.getHlsRenditionGroupSettings() == null ^ this.getHlsRenditionGroupSettings() == null) {
            return false;
        }
        if (other.getHlsRenditionGroupSettings() != null && !other.getHlsRenditionGroupSettings().equals(this.getHlsRenditionGroupSettings())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getOffset() == null ^ this.getOffset() == null) {
            return false;
        }
        if (other.getOffset() != null && !other.getOffset().equals(this.getOffset())) {
            return false;
        }
        if (other.getPids() == null ^ this.getPids() == null) {
            return false;
        }
        if (other.getPids() != null && !other.getPids().equals(this.getPids())) {
            return false;
        }
        if (other.getProgramSelection() == null ^ this.getProgramSelection() == null) {
            return false;
        }
        if (other.getProgramSelection() != null && !other.getProgramSelection().equals(this.getProgramSelection())) {
            return false;
        }
        if (other.getRemixSettings() == null ^ this.getRemixSettings() == null) {
            return false;
        }
        if (other.getRemixSettings() != null && !other.getRemixSettings().equals(this.getRemixSettings())) {
            return false;
        }
        if (other.getSelectorType() == null ^ this.getSelectorType() == null) {
            return false;
        }
        if (other.getSelectorType() != null && !other.getSelectorType().equals(this.getSelectorType())) {
            return false;
        }
        if (other.getTracks() == null ^ this.getTracks() == null) {
            return false;
        }
        return other.getTracks() == null || other.getTracks().equals(this.getTracks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomLanguageCode() == null ? 0 : this.getCustomLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSelection() == null ? 0 : this.getDefaultSelection().hashCode());
        hashCode = 31 * hashCode + (this.getExternalAudioFileInput() == null ? 0 : this.getExternalAudioFileInput().hashCode());
        hashCode = 31 * hashCode + (this.getHlsRenditionGroupSettings() == null ? 0 : this.getHlsRenditionGroupSettings().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getOffset() == null ? 0 : this.getOffset().hashCode());
        hashCode = 31 * hashCode + (this.getPids() == null ? 0 : this.getPids().hashCode());
        hashCode = 31 * hashCode + (this.getProgramSelection() == null ? 0 : this.getProgramSelection().hashCode());
        hashCode = 31 * hashCode + (this.getRemixSettings() == null ? 0 : this.getRemixSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSelectorType() == null ? 0 : this.getSelectorType().hashCode());
        hashCode = 31 * hashCode + (this.getTracks() == null ? 0 : this.getTracks().hashCode());
        return hashCode;
    }

    public AudioSelector clone() {
        try {
            return (AudioSelector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

