/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.S3ServerSideEncryptionType;
import com.amazonaws.services.mediaconvert.model.transform.S3EncryptionSettingsMarshaller;
import java.io.Serializable;

public class S3EncryptionSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionType;
    private String kmsEncryptionContext;
    private String kmsKeyArn;

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public S3EncryptionSettings withEncryptionType(String encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public S3EncryptionSettings withEncryptionType(S3ServerSideEncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
        return this;
    }

    public void setKmsEncryptionContext(String kmsEncryptionContext) {
        this.kmsEncryptionContext = kmsEncryptionContext;
    }

    public String getKmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public S3EncryptionSettings withKmsEncryptionContext(String kmsEncryptionContext) {
        this.setKmsEncryptionContext(kmsEncryptionContext);
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public S3EncryptionSettings withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: ").append(this.getEncryptionType()).append(",");
        }
        if (this.getKmsEncryptionContext() != null) {
            sb.append("KmsEncryptionContext: ").append(this.getKmsEncryptionContext()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3EncryptionSettings)) {
            return false;
        }
        S3EncryptionSettings other = (S3EncryptionSettings)obj;
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        if (other.getEncryptionType() != null && !other.getEncryptionType().equals(this.getEncryptionType())) {
            return false;
        }
        if (other.getKmsEncryptionContext() == null ^ this.getKmsEncryptionContext() == null) {
            return false;
        }
        if (other.getKmsEncryptionContext() != null && !other.getKmsEncryptionContext().equals(this.getKmsEncryptionContext())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        return other.getKmsKeyArn() == null || other.getKmsKeyArn().equals(this.getKmsKeyArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getKmsEncryptionContext() == null ? 0 : this.getKmsEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        return hashCode;
    }

    public S3EncryptionSettings clone() {
        try {
            return (S3EncryptionSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3EncryptionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

