/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AutomatedAbrRule;
import java.util.List;

@SdkInternalApi
public class AutomatedAbrRuleMarshaller {
    private static final MarshallingInfo<List> ALLOWEDRENDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedRenditions").build();
    private static final MarshallingInfo<List> FORCEINCLUDERENDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forceIncludeRenditions").build();
    private static final MarshallingInfo<StructuredPojo> MINBOTTOMRENDITIONSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minBottomRenditionSize").build();
    private static final MarshallingInfo<StructuredPojo> MINTOPRENDITIONSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minTopRenditionSize").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final AutomatedAbrRuleMarshaller instance = new AutomatedAbrRuleMarshaller();

    public static AutomatedAbrRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutomatedAbrRule automatedAbrRule, ProtocolMarshaller protocolMarshaller) {
        if (automatedAbrRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(automatedAbrRule.getAllowedRenditions(), ALLOWEDRENDITIONS_BINDING);
            protocolMarshaller.marshall(automatedAbrRule.getForceIncludeRenditions(), FORCEINCLUDERENDITIONS_BINDING);
            protocolMarshaller.marshall((Object)automatedAbrRule.getMinBottomRenditionSize(), MINBOTTOMRENDITIONSIZE_BINDING);
            protocolMarshaller.marshall((Object)automatedAbrRule.getMinTopRenditionSize(), MINTOPRENDITIONSIZE_BINDING);
            protocolMarshaller.marshall((Object)automatedAbrRule.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

