/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.DestinationSettings;
import com.amazonaws.services.mediaconvert.model.HlsAdMarkers;
import com.amazonaws.services.mediaconvert.model.HlsAdditionalManifest;
import com.amazonaws.services.mediaconvert.model.HlsAudioOnlyHeader;
import com.amazonaws.services.mediaconvert.model.HlsCaptionLanguageMapping;
import com.amazonaws.services.mediaconvert.model.HlsCaptionLanguageSetting;
import com.amazonaws.services.mediaconvert.model.HlsClientCache;
import com.amazonaws.services.mediaconvert.model.HlsCodecSpecification;
import com.amazonaws.services.mediaconvert.model.HlsDirectoryStructure;
import com.amazonaws.services.mediaconvert.model.HlsEncryptionSettings;
import com.amazonaws.services.mediaconvert.model.HlsImageBasedTrickPlay;
import com.amazonaws.services.mediaconvert.model.HlsManifestCompression;
import com.amazonaws.services.mediaconvert.model.HlsManifestDurationFormat;
import com.amazonaws.services.mediaconvert.model.HlsOutputSelection;
import com.amazonaws.services.mediaconvert.model.HlsProgramDateTime;
import com.amazonaws.services.mediaconvert.model.HlsSegmentControl;
import com.amazonaws.services.mediaconvert.model.HlsSegmentLengthControl;
import com.amazonaws.services.mediaconvert.model.HlsStreamInfResolution;
import com.amazonaws.services.mediaconvert.model.HlsTargetDurationCompatibilityMode;
import com.amazonaws.services.mediaconvert.model.HlsTimedMetadataId3Frame;
import com.amazonaws.services.mediaconvert.model.transform.HlsGroupSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HlsGroupSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> adMarkers;
    private List<HlsAdditionalManifest> additionalManifests;
    private String audioOnlyHeader;
    private String baseUrl;
    private List<HlsCaptionLanguageMapping> captionLanguageMappings;
    private String captionLanguageSetting;
    private String clientCache;
    private String codecSpecification;
    private String destination;
    private DestinationSettings destinationSettings;
    private String directoryStructure;
    private HlsEncryptionSettings encryption;
    private String imageBasedTrickPlay;
    private String manifestCompression;
    private String manifestDurationFormat;
    private Double minFinalSegmentLength;
    private Integer minSegmentLength;
    private String outputSelection;
    private String programDateTime;
    private Integer programDateTimePeriod;
    private String segmentControl;
    private Integer segmentLength;
    private String segmentLengthControl;
    private Integer segmentsPerSubdirectory;
    private String streamInfResolution;
    private String targetDurationCompatibilityMode;
    private String timedMetadataId3Frame;
    private Integer timedMetadataId3Period;
    private Integer timestampDeltaMilliseconds;

    public List<String> getAdMarkers() {
        return this.adMarkers;
    }

    public void setAdMarkers(Collection<String> adMarkers) {
        if (adMarkers == null) {
            this.adMarkers = null;
            return;
        }
        this.adMarkers = new ArrayList<String>(adMarkers);
    }

    public HlsGroupSettings withAdMarkers(String ... adMarkers) {
        if (this.adMarkers == null) {
            this.setAdMarkers(new ArrayList<String>(adMarkers.length));
        }
        for (String ele : adMarkers) {
            this.adMarkers.add(ele);
        }
        return this;
    }

    public HlsGroupSettings withAdMarkers(Collection<String> adMarkers) {
        this.setAdMarkers(adMarkers);
        return this;
    }

    public HlsGroupSettings withAdMarkers(HlsAdMarkers ... adMarkers) {
        ArrayList<String> adMarkersCopy = new ArrayList<String>(adMarkers.length);
        for (HlsAdMarkers value : adMarkers) {
            adMarkersCopy.add(value.toString());
        }
        if (this.getAdMarkers() == null) {
            this.setAdMarkers(adMarkersCopy);
        } else {
            this.getAdMarkers().addAll(adMarkersCopy);
        }
        return this;
    }

    public List<HlsAdditionalManifest> getAdditionalManifests() {
        return this.additionalManifests;
    }

    public void setAdditionalManifests(Collection<HlsAdditionalManifest> additionalManifests) {
        if (additionalManifests == null) {
            this.additionalManifests = null;
            return;
        }
        this.additionalManifests = new ArrayList<HlsAdditionalManifest>(additionalManifests);
    }

    public HlsGroupSettings withAdditionalManifests(HlsAdditionalManifest ... additionalManifests) {
        if (this.additionalManifests == null) {
            this.setAdditionalManifests(new ArrayList<HlsAdditionalManifest>(additionalManifests.length));
        }
        for (HlsAdditionalManifest ele : additionalManifests) {
            this.additionalManifests.add(ele);
        }
        return this;
    }

    public HlsGroupSettings withAdditionalManifests(Collection<HlsAdditionalManifest> additionalManifests) {
        this.setAdditionalManifests(additionalManifests);
        return this;
    }

    public void setAudioOnlyHeader(String audioOnlyHeader) {
        this.audioOnlyHeader = audioOnlyHeader;
    }

    public String getAudioOnlyHeader() {
        return this.audioOnlyHeader;
    }

    public HlsGroupSettings withAudioOnlyHeader(String audioOnlyHeader) {
        this.setAudioOnlyHeader(audioOnlyHeader);
        return this;
    }

    public HlsGroupSettings withAudioOnlyHeader(HlsAudioOnlyHeader audioOnlyHeader) {
        this.audioOnlyHeader = audioOnlyHeader.toString();
        return this;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public HlsGroupSettings withBaseUrl(String baseUrl) {
        this.setBaseUrl(baseUrl);
        return this;
    }

    public List<HlsCaptionLanguageMapping> getCaptionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
        if (captionLanguageMappings == null) {
            this.captionLanguageMappings = null;
            return;
        }
        this.captionLanguageMappings = new ArrayList<HlsCaptionLanguageMapping>(captionLanguageMappings);
    }

    public HlsGroupSettings withCaptionLanguageMappings(HlsCaptionLanguageMapping ... captionLanguageMappings) {
        if (this.captionLanguageMappings == null) {
            this.setCaptionLanguageMappings(new ArrayList<HlsCaptionLanguageMapping>(captionLanguageMappings.length));
        }
        for (HlsCaptionLanguageMapping ele : captionLanguageMappings) {
            this.captionLanguageMappings.add(ele);
        }
        return this;
    }

    public HlsGroupSettings withCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
        this.setCaptionLanguageMappings(captionLanguageMappings);
        return this;
    }

    public void setCaptionLanguageSetting(String captionLanguageSetting) {
        this.captionLanguageSetting = captionLanguageSetting;
    }

    public String getCaptionLanguageSetting() {
        return this.captionLanguageSetting;
    }

    public HlsGroupSettings withCaptionLanguageSetting(String captionLanguageSetting) {
        this.setCaptionLanguageSetting(captionLanguageSetting);
        return this;
    }

    public HlsGroupSettings withCaptionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
        this.captionLanguageSetting = captionLanguageSetting.toString();
        return this;
    }

    public void setClientCache(String clientCache) {
        this.clientCache = clientCache;
    }

    public String getClientCache() {
        return this.clientCache;
    }

    public HlsGroupSettings withClientCache(String clientCache) {
        this.setClientCache(clientCache);
        return this;
    }

    public HlsGroupSettings withClientCache(HlsClientCache clientCache) {
        this.clientCache = clientCache.toString();
        return this;
    }

    public void setCodecSpecification(String codecSpecification) {
        this.codecSpecification = codecSpecification;
    }

    public String getCodecSpecification() {
        return this.codecSpecification;
    }

    public HlsGroupSettings withCodecSpecification(String codecSpecification) {
        this.setCodecSpecification(codecSpecification);
        return this;
    }

    public HlsGroupSettings withCodecSpecification(HlsCodecSpecification codecSpecification) {
        this.codecSpecification = codecSpecification.toString();
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public HlsGroupSettings withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setDestinationSettings(DestinationSettings destinationSettings) {
        this.destinationSettings = destinationSettings;
    }

    public DestinationSettings getDestinationSettings() {
        return this.destinationSettings;
    }

    public HlsGroupSettings withDestinationSettings(DestinationSettings destinationSettings) {
        this.setDestinationSettings(destinationSettings);
        return this;
    }

    public void setDirectoryStructure(String directoryStructure) {
        this.directoryStructure = directoryStructure;
    }

    public String getDirectoryStructure() {
        return this.directoryStructure;
    }

    public HlsGroupSettings withDirectoryStructure(String directoryStructure) {
        this.setDirectoryStructure(directoryStructure);
        return this;
    }

    public HlsGroupSettings withDirectoryStructure(HlsDirectoryStructure directoryStructure) {
        this.directoryStructure = directoryStructure.toString();
        return this;
    }

    public void setEncryption(HlsEncryptionSettings encryption) {
        this.encryption = encryption;
    }

    public HlsEncryptionSettings getEncryption() {
        return this.encryption;
    }

    public HlsGroupSettings withEncryption(HlsEncryptionSettings encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setImageBasedTrickPlay(String imageBasedTrickPlay) {
        this.imageBasedTrickPlay = imageBasedTrickPlay;
    }

    public String getImageBasedTrickPlay() {
        return this.imageBasedTrickPlay;
    }

    public HlsGroupSettings withImageBasedTrickPlay(String imageBasedTrickPlay) {
        this.setImageBasedTrickPlay(imageBasedTrickPlay);
        return this;
    }

    public HlsGroupSettings withImageBasedTrickPlay(HlsImageBasedTrickPlay imageBasedTrickPlay) {
        this.imageBasedTrickPlay = imageBasedTrickPlay.toString();
        return this;
    }

    public void setManifestCompression(String manifestCompression) {
        this.manifestCompression = manifestCompression;
    }

    public String getManifestCompression() {
        return this.manifestCompression;
    }

    public HlsGroupSettings withManifestCompression(String manifestCompression) {
        this.setManifestCompression(manifestCompression);
        return this;
    }

    public HlsGroupSettings withManifestCompression(HlsManifestCompression manifestCompression) {
        this.manifestCompression = manifestCompression.toString();
        return this;
    }

    public void setManifestDurationFormat(String manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat;
    }

    public String getManifestDurationFormat() {
        return this.manifestDurationFormat;
    }

    public HlsGroupSettings withManifestDurationFormat(String manifestDurationFormat) {
        this.setManifestDurationFormat(manifestDurationFormat);
        return this;
    }

    public HlsGroupSettings withManifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat.toString();
        return this;
    }

    public void setMinFinalSegmentLength(Double minFinalSegmentLength) {
        this.minFinalSegmentLength = minFinalSegmentLength;
    }

    public Double getMinFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public HlsGroupSettings withMinFinalSegmentLength(Double minFinalSegmentLength) {
        this.setMinFinalSegmentLength(minFinalSegmentLength);
        return this;
    }

    public void setMinSegmentLength(Integer minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public Integer getMinSegmentLength() {
        return this.minSegmentLength;
    }

    public HlsGroupSettings withMinSegmentLength(Integer minSegmentLength) {
        this.setMinSegmentLength(minSegmentLength);
        return this;
    }

    public void setOutputSelection(String outputSelection) {
        this.outputSelection = outputSelection;
    }

    public String getOutputSelection() {
        return this.outputSelection;
    }

    public HlsGroupSettings withOutputSelection(String outputSelection) {
        this.setOutputSelection(outputSelection);
        return this;
    }

    public HlsGroupSettings withOutputSelection(HlsOutputSelection outputSelection) {
        this.outputSelection = outputSelection.toString();
        return this;
    }

    public void setProgramDateTime(String programDateTime) {
        this.programDateTime = programDateTime;
    }

    public String getProgramDateTime() {
        return this.programDateTime;
    }

    public HlsGroupSettings withProgramDateTime(String programDateTime) {
        this.setProgramDateTime(programDateTime);
        return this;
    }

    public HlsGroupSettings withProgramDateTime(HlsProgramDateTime programDateTime) {
        this.programDateTime = programDateTime.toString();
        return this;
    }

    public void setProgramDateTimePeriod(Integer programDateTimePeriod) {
        this.programDateTimePeriod = programDateTimePeriod;
    }

    public Integer getProgramDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public HlsGroupSettings withProgramDateTimePeriod(Integer programDateTimePeriod) {
        this.setProgramDateTimePeriod(programDateTimePeriod);
        return this;
    }

    public void setSegmentControl(String segmentControl) {
        this.segmentControl = segmentControl;
    }

    public String getSegmentControl() {
        return this.segmentControl;
    }

    public HlsGroupSettings withSegmentControl(String segmentControl) {
        this.setSegmentControl(segmentControl);
        return this;
    }

    public HlsGroupSettings withSegmentControl(HlsSegmentControl segmentControl) {
        this.segmentControl = segmentControl.toString();
        return this;
    }

    public void setSegmentLength(Integer segmentLength) {
        this.segmentLength = segmentLength;
    }

    public Integer getSegmentLength() {
        return this.segmentLength;
    }

    public HlsGroupSettings withSegmentLength(Integer segmentLength) {
        this.setSegmentLength(segmentLength);
        return this;
    }

    public void setSegmentLengthControl(String segmentLengthControl) {
        this.segmentLengthControl = segmentLengthControl;
    }

    public String getSegmentLengthControl() {
        return this.segmentLengthControl;
    }

    public HlsGroupSettings withSegmentLengthControl(String segmentLengthControl) {
        this.setSegmentLengthControl(segmentLengthControl);
        return this;
    }

    public HlsGroupSettings withSegmentLengthControl(HlsSegmentLengthControl segmentLengthControl) {
        this.segmentLengthControl = segmentLengthControl.toString();
        return this;
    }

    public void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
        this.segmentsPerSubdirectory = segmentsPerSubdirectory;
    }

    public Integer getSegmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public HlsGroupSettings withSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
        this.setSegmentsPerSubdirectory(segmentsPerSubdirectory);
        return this;
    }

    public void setStreamInfResolution(String streamInfResolution) {
        this.streamInfResolution = streamInfResolution;
    }

    public String getStreamInfResolution() {
        return this.streamInfResolution;
    }

    public HlsGroupSettings withStreamInfResolution(String streamInfResolution) {
        this.setStreamInfResolution(streamInfResolution);
        return this;
    }

    public HlsGroupSettings withStreamInfResolution(HlsStreamInfResolution streamInfResolution) {
        this.streamInfResolution = streamInfResolution.toString();
        return this;
    }

    public void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
        this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
    }

    public String getTargetDurationCompatibilityMode() {
        return this.targetDurationCompatibilityMode;
    }

    public HlsGroupSettings withTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
        this.setTargetDurationCompatibilityMode(targetDurationCompatibilityMode);
        return this;
    }

    public HlsGroupSettings withTargetDurationCompatibilityMode(HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
        this.targetDurationCompatibilityMode = targetDurationCompatibilityMode.toString();
        return this;
    }

    public void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
        this.timedMetadataId3Frame = timedMetadataId3Frame;
    }

    public String getTimedMetadataId3Frame() {
        return this.timedMetadataId3Frame;
    }

    public HlsGroupSettings withTimedMetadataId3Frame(String timedMetadataId3Frame) {
        this.setTimedMetadataId3Frame(timedMetadataId3Frame);
        return this;
    }

    public HlsGroupSettings withTimedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
        this.timedMetadataId3Frame = timedMetadataId3Frame.toString();
        return this;
    }

    public void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
        this.timedMetadataId3Period = timedMetadataId3Period;
    }

    public Integer getTimedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public HlsGroupSettings withTimedMetadataId3Period(Integer timedMetadataId3Period) {
        this.setTimedMetadataId3Period(timedMetadataId3Period);
        return this;
    }

    public void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
        this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
    }

    public Integer getTimestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public HlsGroupSettings withTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
        this.setTimestampDeltaMilliseconds(timestampDeltaMilliseconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdMarkers() != null) {
            sb.append("AdMarkers: ").append(this.getAdMarkers()).append(",");
        }
        if (this.getAdditionalManifests() != null) {
            sb.append("AdditionalManifests: ").append(this.getAdditionalManifests()).append(",");
        }
        if (this.getAudioOnlyHeader() != null) {
            sb.append("AudioOnlyHeader: ").append(this.getAudioOnlyHeader()).append(",");
        }
        if (this.getBaseUrl() != null) {
            sb.append("BaseUrl: ").append(this.getBaseUrl()).append(",");
        }
        if (this.getCaptionLanguageMappings() != null) {
            sb.append("CaptionLanguageMappings: ").append(this.getCaptionLanguageMappings()).append(",");
        }
        if (this.getCaptionLanguageSetting() != null) {
            sb.append("CaptionLanguageSetting: ").append(this.getCaptionLanguageSetting()).append(",");
        }
        if (this.getClientCache() != null) {
            sb.append("ClientCache: ").append(this.getClientCache()).append(",");
        }
        if (this.getCodecSpecification() != null) {
            sb.append("CodecSpecification: ").append(this.getCodecSpecification()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getDestinationSettings() != null) {
            sb.append("DestinationSettings: ").append(this.getDestinationSettings()).append(",");
        }
        if (this.getDirectoryStructure() != null) {
            sb.append("DirectoryStructure: ").append(this.getDirectoryStructure()).append(",");
        }
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getImageBasedTrickPlay() != null) {
            sb.append("ImageBasedTrickPlay: ").append(this.getImageBasedTrickPlay()).append(",");
        }
        if (this.getManifestCompression() != null) {
            sb.append("ManifestCompression: ").append(this.getManifestCompression()).append(",");
        }
        if (this.getManifestDurationFormat() != null) {
            sb.append("ManifestDurationFormat: ").append(this.getManifestDurationFormat()).append(",");
        }
        if (this.getMinFinalSegmentLength() != null) {
            sb.append("MinFinalSegmentLength: ").append(this.getMinFinalSegmentLength()).append(",");
        }
        if (this.getMinSegmentLength() != null) {
            sb.append("MinSegmentLength: ").append(this.getMinSegmentLength()).append(",");
        }
        if (this.getOutputSelection() != null) {
            sb.append("OutputSelection: ").append(this.getOutputSelection()).append(",");
        }
        if (this.getProgramDateTime() != null) {
            sb.append("ProgramDateTime: ").append(this.getProgramDateTime()).append(",");
        }
        if (this.getProgramDateTimePeriod() != null) {
            sb.append("ProgramDateTimePeriod: ").append(this.getProgramDateTimePeriod()).append(",");
        }
        if (this.getSegmentControl() != null) {
            sb.append("SegmentControl: ").append(this.getSegmentControl()).append(",");
        }
        if (this.getSegmentLength() != null) {
            sb.append("SegmentLength: ").append(this.getSegmentLength()).append(",");
        }
        if (this.getSegmentLengthControl() != null) {
            sb.append("SegmentLengthControl: ").append(this.getSegmentLengthControl()).append(",");
        }
        if (this.getSegmentsPerSubdirectory() != null) {
            sb.append("SegmentsPerSubdirectory: ").append(this.getSegmentsPerSubdirectory()).append(",");
        }
        if (this.getStreamInfResolution() != null) {
            sb.append("StreamInfResolution: ").append(this.getStreamInfResolution()).append(",");
        }
        if (this.getTargetDurationCompatibilityMode() != null) {
            sb.append("TargetDurationCompatibilityMode: ").append(this.getTargetDurationCompatibilityMode()).append(",");
        }
        if (this.getTimedMetadataId3Frame() != null) {
            sb.append("TimedMetadataId3Frame: ").append(this.getTimedMetadataId3Frame()).append(",");
        }
        if (this.getTimedMetadataId3Period() != null) {
            sb.append("TimedMetadataId3Period: ").append(this.getTimedMetadataId3Period()).append(",");
        }
        if (this.getTimestampDeltaMilliseconds() != null) {
            sb.append("TimestampDeltaMilliseconds: ").append(this.getTimestampDeltaMilliseconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        if (other.getAdMarkers() == null ^ this.getAdMarkers() == null) {
            return false;
        }
        if (other.getAdMarkers() != null && !other.getAdMarkers().equals(this.getAdMarkers())) {
            return false;
        }
        if (other.getAdditionalManifests() == null ^ this.getAdditionalManifests() == null) {
            return false;
        }
        if (other.getAdditionalManifests() != null && !other.getAdditionalManifests().equals(this.getAdditionalManifests())) {
            return false;
        }
        if (other.getAudioOnlyHeader() == null ^ this.getAudioOnlyHeader() == null) {
            return false;
        }
        if (other.getAudioOnlyHeader() != null && !other.getAudioOnlyHeader().equals(this.getAudioOnlyHeader())) {
            return false;
        }
        if (other.getBaseUrl() == null ^ this.getBaseUrl() == null) {
            return false;
        }
        if (other.getBaseUrl() != null && !other.getBaseUrl().equals(this.getBaseUrl())) {
            return false;
        }
        if (other.getCaptionLanguageMappings() == null ^ this.getCaptionLanguageMappings() == null) {
            return false;
        }
        if (other.getCaptionLanguageMappings() != null && !other.getCaptionLanguageMappings().equals(this.getCaptionLanguageMappings())) {
            return false;
        }
        if (other.getCaptionLanguageSetting() == null ^ this.getCaptionLanguageSetting() == null) {
            return false;
        }
        if (other.getCaptionLanguageSetting() != null && !other.getCaptionLanguageSetting().equals(this.getCaptionLanguageSetting())) {
            return false;
        }
        if (other.getClientCache() == null ^ this.getClientCache() == null) {
            return false;
        }
        if (other.getClientCache() != null && !other.getClientCache().equals(this.getClientCache())) {
            return false;
        }
        if (other.getCodecSpecification() == null ^ this.getCodecSpecification() == null) {
            return false;
        }
        if (other.getCodecSpecification() != null && !other.getCodecSpecification().equals(this.getCodecSpecification())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getDestinationSettings() == null ^ this.getDestinationSettings() == null) {
            return false;
        }
        if (other.getDestinationSettings() != null && !other.getDestinationSettings().equals(this.getDestinationSettings())) {
            return false;
        }
        if (other.getDirectoryStructure() == null ^ this.getDirectoryStructure() == null) {
            return false;
        }
        if (other.getDirectoryStructure() != null && !other.getDirectoryStructure().equals(this.getDirectoryStructure())) {
            return false;
        }
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getImageBasedTrickPlay() == null ^ this.getImageBasedTrickPlay() == null) {
            return false;
        }
        if (other.getImageBasedTrickPlay() != null && !other.getImageBasedTrickPlay().equals(this.getImageBasedTrickPlay())) {
            return false;
        }
        if (other.getManifestCompression() == null ^ this.getManifestCompression() == null) {
            return false;
        }
        if (other.getManifestCompression() != null && !other.getManifestCompression().equals(this.getManifestCompression())) {
            return false;
        }
        if (other.getManifestDurationFormat() == null ^ this.getManifestDurationFormat() == null) {
            return false;
        }
        if (other.getManifestDurationFormat() != null && !other.getManifestDurationFormat().equals(this.getManifestDurationFormat())) {
            return false;
        }
        if (other.getMinFinalSegmentLength() == null ^ this.getMinFinalSegmentLength() == null) {
            return false;
        }
        if (other.getMinFinalSegmentLength() != null && !other.getMinFinalSegmentLength().equals(this.getMinFinalSegmentLength())) {
            return false;
        }
        if (other.getMinSegmentLength() == null ^ this.getMinSegmentLength() == null) {
            return false;
        }
        if (other.getMinSegmentLength() != null && !other.getMinSegmentLength().equals(this.getMinSegmentLength())) {
            return false;
        }
        if (other.getOutputSelection() == null ^ this.getOutputSelection() == null) {
            return false;
        }
        if (other.getOutputSelection() != null && !other.getOutputSelection().equals(this.getOutputSelection())) {
            return false;
        }
        if (other.getProgramDateTime() == null ^ this.getProgramDateTime() == null) {
            return false;
        }
        if (other.getProgramDateTime() != null && !other.getProgramDateTime().equals(this.getProgramDateTime())) {
            return false;
        }
        if (other.getProgramDateTimePeriod() == null ^ this.getProgramDateTimePeriod() == null) {
            return false;
        }
        if (other.getProgramDateTimePeriod() != null && !other.getProgramDateTimePeriod().equals(this.getProgramDateTimePeriod())) {
            return false;
        }
        if (other.getSegmentControl() == null ^ this.getSegmentControl() == null) {
            return false;
        }
        if (other.getSegmentControl() != null && !other.getSegmentControl().equals(this.getSegmentControl())) {
            return false;
        }
        if (other.getSegmentLength() == null ^ this.getSegmentLength() == null) {
            return false;
        }
        if (other.getSegmentLength() != null && !other.getSegmentLength().equals(this.getSegmentLength())) {
            return false;
        }
        if (other.getSegmentLengthControl() == null ^ this.getSegmentLengthControl() == null) {
            return false;
        }
        if (other.getSegmentLengthControl() != null && !other.getSegmentLengthControl().equals(this.getSegmentLengthControl())) {
            return false;
        }
        if (other.getSegmentsPerSubdirectory() == null ^ this.getSegmentsPerSubdirectory() == null) {
            return false;
        }
        if (other.getSegmentsPerSubdirectory() != null && !other.getSegmentsPerSubdirectory().equals(this.getSegmentsPerSubdirectory())) {
            return false;
        }
        if (other.getStreamInfResolution() == null ^ this.getStreamInfResolution() == null) {
            return false;
        }
        if (other.getStreamInfResolution() != null && !other.getStreamInfResolution().equals(this.getStreamInfResolution())) {
            return false;
        }
        if (other.getTargetDurationCompatibilityMode() == null ^ this.getTargetDurationCompatibilityMode() == null) {
            return false;
        }
        if (other.getTargetDurationCompatibilityMode() != null && !other.getTargetDurationCompatibilityMode().equals(this.getTargetDurationCompatibilityMode())) {
            return false;
        }
        if (other.getTimedMetadataId3Frame() == null ^ this.getTimedMetadataId3Frame() == null) {
            return false;
        }
        if (other.getTimedMetadataId3Frame() != null && !other.getTimedMetadataId3Frame().equals(this.getTimedMetadataId3Frame())) {
            return false;
        }
        if (other.getTimedMetadataId3Period() == null ^ this.getTimedMetadataId3Period() == null) {
            return false;
        }
        if (other.getTimedMetadataId3Period() != null && !other.getTimedMetadataId3Period().equals(this.getTimedMetadataId3Period())) {
            return false;
        }
        if (other.getTimestampDeltaMilliseconds() == null ^ this.getTimestampDeltaMilliseconds() == null) {
            return false;
        }
        return other.getTimestampDeltaMilliseconds() == null || other.getTimestampDeltaMilliseconds().equals(this.getTimestampDeltaMilliseconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdMarkers() == null ? 0 : this.getAdMarkers().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalManifests() == null ? 0 : this.getAdditionalManifests().hashCode());
        hashCode = 31 * hashCode + (this.getAudioOnlyHeader() == null ? 0 : this.getAudioOnlyHeader().hashCode());
        hashCode = 31 * hashCode + (this.getBaseUrl() == null ? 0 : this.getBaseUrl().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionLanguageMappings() == null ? 0 : this.getCaptionLanguageMappings().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionLanguageSetting() == null ? 0 : this.getCaptionLanguageSetting().hashCode());
        hashCode = 31 * hashCode + (this.getClientCache() == null ? 0 : this.getClientCache().hashCode());
        hashCode = 31 * hashCode + (this.getCodecSpecification() == null ? 0 : this.getCodecSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationSettings() == null ? 0 : this.getDestinationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryStructure() == null ? 0 : this.getDirectoryStructure().hashCode());
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getImageBasedTrickPlay() == null ? 0 : this.getImageBasedTrickPlay().hashCode());
        hashCode = 31 * hashCode + (this.getManifestCompression() == null ? 0 : this.getManifestCompression().hashCode());
        hashCode = 31 * hashCode + (this.getManifestDurationFormat() == null ? 0 : this.getManifestDurationFormat().hashCode());
        hashCode = 31 * hashCode + (this.getMinFinalSegmentLength() == null ? 0 : this.getMinFinalSegmentLength().hashCode());
        hashCode = 31 * hashCode + (this.getMinSegmentLength() == null ? 0 : this.getMinSegmentLength().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSelection() == null ? 0 : this.getOutputSelection().hashCode());
        hashCode = 31 * hashCode + (this.getProgramDateTime() == null ? 0 : this.getProgramDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getProgramDateTimePeriod() == null ? 0 : this.getProgramDateTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentControl() == null ? 0 : this.getSegmentControl().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentLength() == null ? 0 : this.getSegmentLength().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentLengthControl() == null ? 0 : this.getSegmentLengthControl().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentsPerSubdirectory() == null ? 0 : this.getSegmentsPerSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getStreamInfResolution() == null ? 0 : this.getStreamInfResolution().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDurationCompatibilityMode() == null ? 0 : this.getTargetDurationCompatibilityMode().hashCode());
        hashCode = 31 * hashCode + (this.getTimedMetadataId3Frame() == null ? 0 : this.getTimedMetadataId3Frame().hashCode());
        hashCode = 31 * hashCode + (this.getTimedMetadataId3Period() == null ? 0 : this.getTimedMetadataId3Period().hashCode());
        hashCode = 31 * hashCode + (this.getTimestampDeltaMilliseconds() == null ? 0 : this.getTimestampDeltaMilliseconds().hashCode());
        return hashCode;
    }

    public HlsGroupSettings clone() {
        try {
            return (HlsGroupSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

