/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AdvancedInputFilter;
import com.amazonaws.services.mediaconvert.model.AdvancedInputFilterSettings;
import com.amazonaws.services.mediaconvert.model.AudioSelector;
import com.amazonaws.services.mediaconvert.model.AudioSelectorGroup;
import com.amazonaws.services.mediaconvert.model.CaptionSelector;
import com.amazonaws.services.mediaconvert.model.ImageInserter;
import com.amazonaws.services.mediaconvert.model.InputClipping;
import com.amazonaws.services.mediaconvert.model.InputDeblockFilter;
import com.amazonaws.services.mediaconvert.model.InputDenoiseFilter;
import com.amazonaws.services.mediaconvert.model.InputFilterEnable;
import com.amazonaws.services.mediaconvert.model.InputPsiControl;
import com.amazonaws.services.mediaconvert.model.InputScanType;
import com.amazonaws.services.mediaconvert.model.InputTimecodeSource;
import com.amazonaws.services.mediaconvert.model.Rectangle;
import com.amazonaws.services.mediaconvert.model.VideoOverlay;
import com.amazonaws.services.mediaconvert.model.VideoSelector;
import com.amazonaws.services.mediaconvert.model.transform.InputTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String advancedInputFilter;
    private AdvancedInputFilterSettings advancedInputFilterSettings;
    private Map<String, AudioSelectorGroup> audioSelectorGroups;
    private Map<String, AudioSelector> audioSelectors;
    private Map<String, CaptionSelector> captionSelectors;
    private Rectangle crop;
    private String deblockFilter;
    private String denoiseFilter;
    private String dolbyVisionMetadataXml;
    private String filterEnable;
    private Integer filterStrength;
    private ImageInserter imageInserter;
    private List<InputClipping> inputClippings;
    private String inputScanType;
    private Rectangle position;
    private Integer programNumber;
    private String psiControl;
    private String timecodeSource;
    private String timecodeStart;
    private List<VideoOverlay> videoOverlays;
    private VideoSelector videoSelector;

    public void setAdvancedInputFilter(String advancedInputFilter) {
        this.advancedInputFilter = advancedInputFilter;
    }

    public String getAdvancedInputFilter() {
        return this.advancedInputFilter;
    }

    public InputTemplate withAdvancedInputFilter(String advancedInputFilter) {
        this.setAdvancedInputFilter(advancedInputFilter);
        return this;
    }

    public InputTemplate withAdvancedInputFilter(AdvancedInputFilter advancedInputFilter) {
        this.advancedInputFilter = advancedInputFilter.toString();
        return this;
    }

    public void setAdvancedInputFilterSettings(AdvancedInputFilterSettings advancedInputFilterSettings) {
        this.advancedInputFilterSettings = advancedInputFilterSettings;
    }

    public AdvancedInputFilterSettings getAdvancedInputFilterSettings() {
        return this.advancedInputFilterSettings;
    }

    public InputTemplate withAdvancedInputFilterSettings(AdvancedInputFilterSettings advancedInputFilterSettings) {
        this.setAdvancedInputFilterSettings(advancedInputFilterSettings);
        return this;
    }

    public Map<String, AudioSelectorGroup> getAudioSelectorGroups() {
        return this.audioSelectorGroups;
    }

    public void setAudioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
        this.audioSelectorGroups = audioSelectorGroups;
    }

    public InputTemplate withAudioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
        this.setAudioSelectorGroups(audioSelectorGroups);
        return this;
    }

    public InputTemplate addAudioSelectorGroupsEntry(String key, AudioSelectorGroup value) {
        if (null == this.audioSelectorGroups) {
            this.audioSelectorGroups = new HashMap<String, AudioSelectorGroup>();
        }
        if (this.audioSelectorGroups.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.audioSelectorGroups.put(key, value);
        return this;
    }

    public InputTemplate clearAudioSelectorGroupsEntries() {
        this.audioSelectorGroups = null;
        return this;
    }

    public Map<String, AudioSelector> getAudioSelectors() {
        return this.audioSelectors;
    }

    public void setAudioSelectors(Map<String, AudioSelector> audioSelectors) {
        this.audioSelectors = audioSelectors;
    }

    public InputTemplate withAudioSelectors(Map<String, AudioSelector> audioSelectors) {
        this.setAudioSelectors(audioSelectors);
        return this;
    }

    public InputTemplate addAudioSelectorsEntry(String key, AudioSelector value) {
        if (null == this.audioSelectors) {
            this.audioSelectors = new HashMap<String, AudioSelector>();
        }
        if (this.audioSelectors.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.audioSelectors.put(key, value);
        return this;
    }

    public InputTemplate clearAudioSelectorsEntries() {
        this.audioSelectors = null;
        return this;
    }

    public Map<String, CaptionSelector> getCaptionSelectors() {
        return this.captionSelectors;
    }

    public void setCaptionSelectors(Map<String, CaptionSelector> captionSelectors) {
        this.captionSelectors = captionSelectors;
    }

    public InputTemplate withCaptionSelectors(Map<String, CaptionSelector> captionSelectors) {
        this.setCaptionSelectors(captionSelectors);
        return this;
    }

    public InputTemplate addCaptionSelectorsEntry(String key, CaptionSelector value) {
        if (null == this.captionSelectors) {
            this.captionSelectors = new HashMap<String, CaptionSelector>();
        }
        if (this.captionSelectors.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.captionSelectors.put(key, value);
        return this;
    }

    public InputTemplate clearCaptionSelectorsEntries() {
        this.captionSelectors = null;
        return this;
    }

    public void setCrop(Rectangle crop) {
        this.crop = crop;
    }

    public Rectangle getCrop() {
        return this.crop;
    }

    public InputTemplate withCrop(Rectangle crop) {
        this.setCrop(crop);
        return this;
    }

    public void setDeblockFilter(String deblockFilter) {
        this.deblockFilter = deblockFilter;
    }

    public String getDeblockFilter() {
        return this.deblockFilter;
    }

    public InputTemplate withDeblockFilter(String deblockFilter) {
        this.setDeblockFilter(deblockFilter);
        return this;
    }

    public InputTemplate withDeblockFilter(InputDeblockFilter deblockFilter) {
        this.deblockFilter = deblockFilter.toString();
        return this;
    }

    public void setDenoiseFilter(String denoiseFilter) {
        this.denoiseFilter = denoiseFilter;
    }

    public String getDenoiseFilter() {
        return this.denoiseFilter;
    }

    public InputTemplate withDenoiseFilter(String denoiseFilter) {
        this.setDenoiseFilter(denoiseFilter);
        return this;
    }

    public InputTemplate withDenoiseFilter(InputDenoiseFilter denoiseFilter) {
        this.denoiseFilter = denoiseFilter.toString();
        return this;
    }

    public void setDolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
        this.dolbyVisionMetadataXml = dolbyVisionMetadataXml;
    }

    public String getDolbyVisionMetadataXml() {
        return this.dolbyVisionMetadataXml;
    }

    public InputTemplate withDolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
        this.setDolbyVisionMetadataXml(dolbyVisionMetadataXml);
        return this;
    }

    public void setFilterEnable(String filterEnable) {
        this.filterEnable = filterEnable;
    }

    public String getFilterEnable() {
        return this.filterEnable;
    }

    public InputTemplate withFilterEnable(String filterEnable) {
        this.setFilterEnable(filterEnable);
        return this;
    }

    public InputTemplate withFilterEnable(InputFilterEnable filterEnable) {
        this.filterEnable = filterEnable.toString();
        return this;
    }

    public void setFilterStrength(Integer filterStrength) {
        this.filterStrength = filterStrength;
    }

    public Integer getFilterStrength() {
        return this.filterStrength;
    }

    public InputTemplate withFilterStrength(Integer filterStrength) {
        this.setFilterStrength(filterStrength);
        return this;
    }

    public void setImageInserter(ImageInserter imageInserter) {
        this.imageInserter = imageInserter;
    }

    public ImageInserter getImageInserter() {
        return this.imageInserter;
    }

    public InputTemplate withImageInserter(ImageInserter imageInserter) {
        this.setImageInserter(imageInserter);
        return this;
    }

    public List<InputClipping> getInputClippings() {
        return this.inputClippings;
    }

    public void setInputClippings(Collection<InputClipping> inputClippings) {
        if (inputClippings == null) {
            this.inputClippings = null;
            return;
        }
        this.inputClippings = new ArrayList<InputClipping>(inputClippings);
    }

    public InputTemplate withInputClippings(InputClipping ... inputClippings) {
        if (this.inputClippings == null) {
            this.setInputClippings(new ArrayList<InputClipping>(inputClippings.length));
        }
        for (InputClipping ele : inputClippings) {
            this.inputClippings.add(ele);
        }
        return this;
    }

    public InputTemplate withInputClippings(Collection<InputClipping> inputClippings) {
        this.setInputClippings(inputClippings);
        return this;
    }

    public void setInputScanType(String inputScanType) {
        this.inputScanType = inputScanType;
    }

    public String getInputScanType() {
        return this.inputScanType;
    }

    public InputTemplate withInputScanType(String inputScanType) {
        this.setInputScanType(inputScanType);
        return this;
    }

    public InputTemplate withInputScanType(InputScanType inputScanType) {
        this.inputScanType = inputScanType.toString();
        return this;
    }

    public void setPosition(Rectangle position) {
        this.position = position;
    }

    public Rectangle getPosition() {
        return this.position;
    }

    public InputTemplate withPosition(Rectangle position) {
        this.setPosition(position);
        return this;
    }

    public void setProgramNumber(Integer programNumber) {
        this.programNumber = programNumber;
    }

    public Integer getProgramNumber() {
        return this.programNumber;
    }

    public InputTemplate withProgramNumber(Integer programNumber) {
        this.setProgramNumber(programNumber);
        return this;
    }

    public void setPsiControl(String psiControl) {
        this.psiControl = psiControl;
    }

    public String getPsiControl() {
        return this.psiControl;
    }

    public InputTemplate withPsiControl(String psiControl) {
        this.setPsiControl(psiControl);
        return this;
    }

    public InputTemplate withPsiControl(InputPsiControl psiControl) {
        this.psiControl = psiControl.toString();
        return this;
    }

    public void setTimecodeSource(String timecodeSource) {
        this.timecodeSource = timecodeSource;
    }

    public String getTimecodeSource() {
        return this.timecodeSource;
    }

    public InputTemplate withTimecodeSource(String timecodeSource) {
        this.setTimecodeSource(timecodeSource);
        return this;
    }

    public InputTemplate withTimecodeSource(InputTimecodeSource timecodeSource) {
        this.timecodeSource = timecodeSource.toString();
        return this;
    }

    public void setTimecodeStart(String timecodeStart) {
        this.timecodeStart = timecodeStart;
    }

    public String getTimecodeStart() {
        return this.timecodeStart;
    }

    public InputTemplate withTimecodeStart(String timecodeStart) {
        this.setTimecodeStart(timecodeStart);
        return this;
    }

    public List<VideoOverlay> getVideoOverlays() {
        return this.videoOverlays;
    }

    public void setVideoOverlays(Collection<VideoOverlay> videoOverlays) {
        if (videoOverlays == null) {
            this.videoOverlays = null;
            return;
        }
        this.videoOverlays = new ArrayList<VideoOverlay>(videoOverlays);
    }

    public InputTemplate withVideoOverlays(VideoOverlay ... videoOverlays) {
        if (this.videoOverlays == null) {
            this.setVideoOverlays(new ArrayList<VideoOverlay>(videoOverlays.length));
        }
        for (VideoOverlay ele : videoOverlays) {
            this.videoOverlays.add(ele);
        }
        return this;
    }

    public InputTemplate withVideoOverlays(Collection<VideoOverlay> videoOverlays) {
        this.setVideoOverlays(videoOverlays);
        return this;
    }

    public void setVideoSelector(VideoSelector videoSelector) {
        this.videoSelector = videoSelector;
    }

    public VideoSelector getVideoSelector() {
        return this.videoSelector;
    }

    public InputTemplate withVideoSelector(VideoSelector videoSelector) {
        this.setVideoSelector(videoSelector);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdvancedInputFilter() != null) {
            sb.append("AdvancedInputFilter: ").append(this.getAdvancedInputFilter()).append(",");
        }
        if (this.getAdvancedInputFilterSettings() != null) {
            sb.append("AdvancedInputFilterSettings: ").append(this.getAdvancedInputFilterSettings()).append(",");
        }
        if (this.getAudioSelectorGroups() != null) {
            sb.append("AudioSelectorGroups: ").append(this.getAudioSelectorGroups()).append(",");
        }
        if (this.getAudioSelectors() != null) {
            sb.append("AudioSelectors: ").append(this.getAudioSelectors()).append(",");
        }
        if (this.getCaptionSelectors() != null) {
            sb.append("CaptionSelectors: ").append(this.getCaptionSelectors()).append(",");
        }
        if (this.getCrop() != null) {
            sb.append("Crop: ").append(this.getCrop()).append(",");
        }
        if (this.getDeblockFilter() != null) {
            sb.append("DeblockFilter: ").append(this.getDeblockFilter()).append(",");
        }
        if (this.getDenoiseFilter() != null) {
            sb.append("DenoiseFilter: ").append(this.getDenoiseFilter()).append(",");
        }
        if (this.getDolbyVisionMetadataXml() != null) {
            sb.append("DolbyVisionMetadataXml: ").append(this.getDolbyVisionMetadataXml()).append(",");
        }
        if (this.getFilterEnable() != null) {
            sb.append("FilterEnable: ").append(this.getFilterEnable()).append(",");
        }
        if (this.getFilterStrength() != null) {
            sb.append("FilterStrength: ").append(this.getFilterStrength()).append(",");
        }
        if (this.getImageInserter() != null) {
            sb.append("ImageInserter: ").append(this.getImageInserter()).append(",");
        }
        if (this.getInputClippings() != null) {
            sb.append("InputClippings: ").append(this.getInputClippings()).append(",");
        }
        if (this.getInputScanType() != null) {
            sb.append("InputScanType: ").append(this.getInputScanType()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append(this.getPosition()).append(",");
        }
        if (this.getProgramNumber() != null) {
            sb.append("ProgramNumber: ").append(this.getProgramNumber()).append(",");
        }
        if (this.getPsiControl() != null) {
            sb.append("PsiControl: ").append(this.getPsiControl()).append(",");
        }
        if (this.getTimecodeSource() != null) {
            sb.append("TimecodeSource: ").append(this.getTimecodeSource()).append(",");
        }
        if (this.getTimecodeStart() != null) {
            sb.append("TimecodeStart: ").append(this.getTimecodeStart()).append(",");
        }
        if (this.getVideoOverlays() != null) {
            sb.append("VideoOverlays: ").append(this.getVideoOverlays()).append(",");
        }
        if (this.getVideoSelector() != null) {
            sb.append("VideoSelector: ").append(this.getVideoSelector());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTemplate)) {
            return false;
        }
        InputTemplate other = (InputTemplate)obj;
        if (other.getAdvancedInputFilter() == null ^ this.getAdvancedInputFilter() == null) {
            return false;
        }
        if (other.getAdvancedInputFilter() != null && !other.getAdvancedInputFilter().equals(this.getAdvancedInputFilter())) {
            return false;
        }
        if (other.getAdvancedInputFilterSettings() == null ^ this.getAdvancedInputFilterSettings() == null) {
            return false;
        }
        if (other.getAdvancedInputFilterSettings() != null && !other.getAdvancedInputFilterSettings().equals(this.getAdvancedInputFilterSettings())) {
            return false;
        }
        if (other.getAudioSelectorGroups() == null ^ this.getAudioSelectorGroups() == null) {
            return false;
        }
        if (other.getAudioSelectorGroups() != null && !other.getAudioSelectorGroups().equals(this.getAudioSelectorGroups())) {
            return false;
        }
        if (other.getAudioSelectors() == null ^ this.getAudioSelectors() == null) {
            return false;
        }
        if (other.getAudioSelectors() != null && !other.getAudioSelectors().equals(this.getAudioSelectors())) {
            return false;
        }
        if (other.getCaptionSelectors() == null ^ this.getCaptionSelectors() == null) {
            return false;
        }
        if (other.getCaptionSelectors() != null && !other.getCaptionSelectors().equals(this.getCaptionSelectors())) {
            return false;
        }
        if (other.getCrop() == null ^ this.getCrop() == null) {
            return false;
        }
        if (other.getCrop() != null && !other.getCrop().equals(this.getCrop())) {
            return false;
        }
        if (other.getDeblockFilter() == null ^ this.getDeblockFilter() == null) {
            return false;
        }
        if (other.getDeblockFilter() != null && !other.getDeblockFilter().equals(this.getDeblockFilter())) {
            return false;
        }
        if (other.getDenoiseFilter() == null ^ this.getDenoiseFilter() == null) {
            return false;
        }
        if (other.getDenoiseFilter() != null && !other.getDenoiseFilter().equals(this.getDenoiseFilter())) {
            return false;
        }
        if (other.getDolbyVisionMetadataXml() == null ^ this.getDolbyVisionMetadataXml() == null) {
            return false;
        }
        if (other.getDolbyVisionMetadataXml() != null && !other.getDolbyVisionMetadataXml().equals(this.getDolbyVisionMetadataXml())) {
            return false;
        }
        if (other.getFilterEnable() == null ^ this.getFilterEnable() == null) {
            return false;
        }
        if (other.getFilterEnable() != null && !other.getFilterEnable().equals(this.getFilterEnable())) {
            return false;
        }
        if (other.getFilterStrength() == null ^ this.getFilterStrength() == null) {
            return false;
        }
        if (other.getFilterStrength() != null && !other.getFilterStrength().equals(this.getFilterStrength())) {
            return false;
        }
        if (other.getImageInserter() == null ^ this.getImageInserter() == null) {
            return false;
        }
        if (other.getImageInserter() != null && !other.getImageInserter().equals(this.getImageInserter())) {
            return false;
        }
        if (other.getInputClippings() == null ^ this.getInputClippings() == null) {
            return false;
        }
        if (other.getInputClippings() != null && !other.getInputClippings().equals(this.getInputClippings())) {
            return false;
        }
        if (other.getInputScanType() == null ^ this.getInputScanType() == null) {
            return false;
        }
        if (other.getInputScanType() != null && !other.getInputScanType().equals(this.getInputScanType())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getProgramNumber() == null ^ this.getProgramNumber() == null) {
            return false;
        }
        if (other.getProgramNumber() != null && !other.getProgramNumber().equals(this.getProgramNumber())) {
            return false;
        }
        if (other.getPsiControl() == null ^ this.getPsiControl() == null) {
            return false;
        }
        if (other.getPsiControl() != null && !other.getPsiControl().equals(this.getPsiControl())) {
            return false;
        }
        if (other.getTimecodeSource() == null ^ this.getTimecodeSource() == null) {
            return false;
        }
        if (other.getTimecodeSource() != null && !other.getTimecodeSource().equals(this.getTimecodeSource())) {
            return false;
        }
        if (other.getTimecodeStart() == null ^ this.getTimecodeStart() == null) {
            return false;
        }
        if (other.getTimecodeStart() != null && !other.getTimecodeStart().equals(this.getTimecodeStart())) {
            return false;
        }
        if (other.getVideoOverlays() == null ^ this.getVideoOverlays() == null) {
            return false;
        }
        if (other.getVideoOverlays() != null && !other.getVideoOverlays().equals(this.getVideoOverlays())) {
            return false;
        }
        if (other.getVideoSelector() == null ^ this.getVideoSelector() == null) {
            return false;
        }
        return other.getVideoSelector() == null || other.getVideoSelector().equals(this.getVideoSelector());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdvancedInputFilter() == null ? 0 : this.getAdvancedInputFilter().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedInputFilterSettings() == null ? 0 : this.getAdvancedInputFilterSettings().hashCode());
        hashCode = 31 * hashCode + (this.getAudioSelectorGroups() == null ? 0 : this.getAudioSelectorGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAudioSelectors() == null ? 0 : this.getAudioSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionSelectors() == null ? 0 : this.getCaptionSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getCrop() == null ? 0 : this.getCrop().hashCode());
        hashCode = 31 * hashCode + (this.getDeblockFilter() == null ? 0 : this.getDeblockFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDenoiseFilter() == null ? 0 : this.getDenoiseFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDolbyVisionMetadataXml() == null ? 0 : this.getDolbyVisionMetadataXml().hashCode());
        hashCode = 31 * hashCode + (this.getFilterEnable() == null ? 0 : this.getFilterEnable().hashCode());
        hashCode = 31 * hashCode + (this.getFilterStrength() == null ? 0 : this.getFilterStrength().hashCode());
        hashCode = 31 * hashCode + (this.getImageInserter() == null ? 0 : this.getImageInserter().hashCode());
        hashCode = 31 * hashCode + (this.getInputClippings() == null ? 0 : this.getInputClippings().hashCode());
        hashCode = 31 * hashCode + (this.getInputScanType() == null ? 0 : this.getInputScanType().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getProgramNumber() == null ? 0 : this.getProgramNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPsiControl() == null ? 0 : this.getPsiControl().hashCode());
        hashCode = 31 * hashCode + (this.getTimecodeSource() == null ? 0 : this.getTimecodeSource().hashCode());
        hashCode = 31 * hashCode + (this.getTimecodeStart() == null ? 0 : this.getTimecodeStart().hashCode());
        hashCode = 31 * hashCode + (this.getVideoOverlays() == null ? 0 : this.getVideoOverlays().hashCode());
        hashCode = 31 * hashCode + (this.getVideoSelector() == null ? 0 : this.getVideoSelector().hashCode());
        return hashCode;
    }

    public InputTemplate clone() {
        try {
            return (InputTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

