/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.Mp2CodingMode;
import com.amazonaws.services.medialive.model.transform.Mp2SettingsMarshaller;
import java.io.Serializable;

public class Mp2Settings
implements Serializable,
Cloneable,
StructuredPojo {
    private Double bitrate;
    private String codingMode;
    private Double sampleRate;

    public void setBitrate(Double bitrate) {
        this.bitrate = bitrate;
    }

    public Double getBitrate() {
        return this.bitrate;
    }

    public Mp2Settings withBitrate(Double bitrate) {
        this.setBitrate(bitrate);
        return this;
    }

    public void setCodingMode(String codingMode) {
        this.codingMode = codingMode;
    }

    public String getCodingMode() {
        return this.codingMode;
    }

    public Mp2Settings withCodingMode(String codingMode) {
        this.setCodingMode(codingMode);
        return this;
    }

    public Mp2Settings withCodingMode(Mp2CodingMode codingMode) {
        this.codingMode = codingMode.toString();
        return this;
    }

    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Double getSampleRate() {
        return this.sampleRate;
    }

    public Mp2Settings withSampleRate(Double sampleRate) {
        this.setSampleRate(sampleRate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBitrate() != null) {
            sb.append("Bitrate: ").append(this.getBitrate()).append(",");
        }
        if (this.getCodingMode() != null) {
            sb.append("CodingMode: ").append(this.getCodingMode()).append(",");
        }
        if (this.getSampleRate() != null) {
            sb.append("SampleRate: ").append(this.getSampleRate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp2Settings)) {
            return false;
        }
        Mp2Settings other = (Mp2Settings)obj;
        if (other.getBitrate() == null ^ this.getBitrate() == null) {
            return false;
        }
        if (other.getBitrate() != null && !other.getBitrate().equals(this.getBitrate())) {
            return false;
        }
        if (other.getCodingMode() == null ^ this.getCodingMode() == null) {
            return false;
        }
        if (other.getCodingMode() != null && !other.getCodingMode().equals(this.getCodingMode())) {
            return false;
        }
        if (other.getSampleRate() == null ^ this.getSampleRate() == null) {
            return false;
        }
        return other.getSampleRate() == null || other.getSampleRate().equals(this.getSampleRate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBitrate() == null ? 0 : this.getBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getCodingMode() == null ? 0 : this.getCodingMode().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRate() == null ? 0 : this.getSampleRate().hashCode());
        return hashCode;
    }

    public Mp2Settings clone() {
        try {
            return (Mp2Settings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Mp2SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

