/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medialive.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * Placeholder documentation for CreateMultiplexResponse
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateMultiplexResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /** The newly created multiplex. */
    private Multiplex multiplex;

    /**
     * The newly created multiplex.
     * 
     * @param multiplex
     *        The newly created multiplex.
     */

    public void setMultiplex(Multiplex multiplex) {
        this.multiplex = multiplex;
    }

    /**
     * The newly created multiplex.
     * 
     * @return The newly created multiplex.
     */

    public Multiplex getMultiplex() {
        return this.multiplex;
    }

    /**
     * The newly created multiplex.
     * 
     * @param multiplex
     *        The newly created multiplex.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMultiplexResult withMultiplex(Multiplex multiplex) {
        setMultiplex(multiplex);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMultiplex() != null)
            sb.append("Multiplex: ").append(getMultiplex());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateMultiplexResult == false)
            return false;
        CreateMultiplexResult other = (CreateMultiplexResult) obj;
        if (other.getMultiplex() == null ^ this.getMultiplex() == null)
            return false;
        if (other.getMultiplex() != null && other.getMultiplex().equals(this.getMultiplex()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMultiplex() == null) ? 0 : getMultiplex().hashCode());
        return hashCode;
    }

    @Override
    public CreateMultiplexResult clone() {
        try {
            return (CreateMultiplexResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
