/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mgn.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateWaveRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Account ID.
     * </p>
     */
    private String accountID;
    /**
     * <p>
     * Wave description.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Wave name.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Wave tags.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * Account ID.
     * </p>
     * 
     * @param accountID
     *        Account ID.
     */

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    /**
     * <p>
     * Account ID.
     * </p>
     * 
     * @return Account ID.
     */

    public String getAccountID() {
        return this.accountID;
    }

    /**
     * <p>
     * Account ID.
     * </p>
     * 
     * @param accountID
     *        Account ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest withAccountID(String accountID) {
        setAccountID(accountID);
        return this;
    }

    /**
     * <p>
     * Wave description.
     * </p>
     * 
     * @param description
     *        Wave description.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * Wave description.
     * </p>
     * 
     * @return Wave description.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * Wave description.
     * </p>
     * 
     * @param description
     *        Wave description.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Wave name.
     * </p>
     * 
     * @param name
     *        Wave name.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Wave name.
     * </p>
     * 
     * @return Wave name.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Wave name.
     * </p>
     * 
     * @param name
     *        Wave name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Wave tags.
     * </p>
     * 
     * @return Wave tags.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Wave tags.
     * </p>
     * 
     * @param tags
     *        Wave tags.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Wave tags.
     * </p>
     * 
     * @param tags
     *        Wave tags.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateWaveRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateWaveRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountID() != null)
            sb.append("AccountID: ").append(getAccountID()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateWaveRequest == false)
            return false;
        CreateWaveRequest other = (CreateWaveRequest) obj;
        if (other.getAccountID() == null ^ this.getAccountID() == null)
            return false;
        if (other.getAccountID() != null && other.getAccountID().equals(this.getAccountID()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountID() == null) ? 0 : getAccountID().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateWaveRequest clone() {
        return (CreateWaveRequest) super.clone();
    }

}
