/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessionBackups" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListStreamingSessionBackupsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Information about the streaming session backups.
     * </p>
     */
    private java.util.List<StreamingSessionBackup> streamingSessionBackups;

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results, or null if there are no more results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results, or null if there are no more results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamingSessionBackupsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Information about the streaming session backups.
     * </p>
     * 
     * @return Information about the streaming session backups.
     */

    public java.util.List<StreamingSessionBackup> getStreamingSessionBackups() {
        return streamingSessionBackups;
    }

    /**
     * <p>
     * Information about the streaming session backups.
     * </p>
     * 
     * @param streamingSessionBackups
     *        Information about the streaming session backups.
     */

    public void setStreamingSessionBackups(java.util.Collection<StreamingSessionBackup> streamingSessionBackups) {
        if (streamingSessionBackups == null) {
            this.streamingSessionBackups = null;
            return;
        }

        this.streamingSessionBackups = new java.util.ArrayList<StreamingSessionBackup>(streamingSessionBackups);
    }

    /**
     * <p>
     * Information about the streaming session backups.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStreamingSessionBackups(java.util.Collection)} or
     * {@link #withStreamingSessionBackups(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param streamingSessionBackups
     *        Information about the streaming session backups.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamingSessionBackupsResult withStreamingSessionBackups(StreamingSessionBackup... streamingSessionBackups) {
        if (this.streamingSessionBackups == null) {
            setStreamingSessionBackups(new java.util.ArrayList<StreamingSessionBackup>(streamingSessionBackups.length));
        }
        for (StreamingSessionBackup ele : streamingSessionBackups) {
            this.streamingSessionBackups.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the streaming session backups.
     * </p>
     * 
     * @param streamingSessionBackups
     *        Information about the streaming session backups.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStreamingSessionBackupsResult withStreamingSessionBackups(java.util.Collection<StreamingSessionBackup> streamingSessionBackups) {
        setStreamingSessionBackups(streamingSessionBackups);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getStreamingSessionBackups() != null)
            sb.append("StreamingSessionBackups: ").append(getStreamingSessionBackups());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListStreamingSessionBackupsResult == false)
            return false;
        ListStreamingSessionBackupsResult other = (ListStreamingSessionBackupsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getStreamingSessionBackups() == null ^ this.getStreamingSessionBackups() == null)
            return false;
        if (other.getStreamingSessionBackups() != null && other.getStreamingSessionBackups().equals(this.getStreamingSessionBackups()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getStreamingSessionBackups() == null) ? 0 : getStreamingSessionBackups().hashCode());
        return hashCode;
    }

    @Override
    public ListStreamingSessionBackupsResult clone() {
        try {
            return (ListStreamingSessionBackupsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
