/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.oam;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.oam.AWSOAMAsync;
import com.amazonaws.services.oam.AWSOAMAsyncClientBuilder;
import com.amazonaws.services.oam.AWSOAMClient;
import com.amazonaws.services.oam.model.CreateLinkRequest;
import com.amazonaws.services.oam.model.CreateLinkResult;
import com.amazonaws.services.oam.model.CreateSinkRequest;
import com.amazonaws.services.oam.model.CreateSinkResult;
import com.amazonaws.services.oam.model.DeleteLinkRequest;
import com.amazonaws.services.oam.model.DeleteLinkResult;
import com.amazonaws.services.oam.model.DeleteSinkRequest;
import com.amazonaws.services.oam.model.DeleteSinkResult;
import com.amazonaws.services.oam.model.GetLinkRequest;
import com.amazonaws.services.oam.model.GetLinkResult;
import com.amazonaws.services.oam.model.GetSinkPolicyRequest;
import com.amazonaws.services.oam.model.GetSinkPolicyResult;
import com.amazonaws.services.oam.model.GetSinkRequest;
import com.amazonaws.services.oam.model.GetSinkResult;
import com.amazonaws.services.oam.model.ListAttachedLinksRequest;
import com.amazonaws.services.oam.model.ListAttachedLinksResult;
import com.amazonaws.services.oam.model.ListLinksRequest;
import com.amazonaws.services.oam.model.ListLinksResult;
import com.amazonaws.services.oam.model.ListSinksRequest;
import com.amazonaws.services.oam.model.ListSinksResult;
import com.amazonaws.services.oam.model.ListTagsForResourceRequest;
import com.amazonaws.services.oam.model.ListTagsForResourceResult;
import com.amazonaws.services.oam.model.PutSinkPolicyRequest;
import com.amazonaws.services.oam.model.PutSinkPolicyResult;
import com.amazonaws.services.oam.model.TagResourceRequest;
import com.amazonaws.services.oam.model.TagResourceResult;
import com.amazonaws.services.oam.model.UntagResourceRequest;
import com.amazonaws.services.oam.model.UntagResourceResult;
import com.amazonaws.services.oam.model.UpdateLinkRequest;
import com.amazonaws.services.oam.model.UpdateLinkResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOAMAsyncClient
extends AWSOAMClient
implements AWSOAMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSOAMAsyncClientBuilder asyncBuilder() {
        return AWSOAMAsyncClientBuilder.standard();
    }

    AWSOAMAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSOAMAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateLinkResult> createLinkAsync(CreateLinkRequest request) {
        return this.createLinkAsync(request, null);
    }

    @Override
    public Future<CreateLinkResult> createLinkAsync(CreateLinkRequest request, final AsyncHandler<CreateLinkRequest, CreateLinkResult> asyncHandler) {
        final CreateLinkRequest finalRequest = (CreateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLinkResult>(){

            @Override
            public CreateLinkResult call() throws Exception {
                CreateLinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeCreateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSinkResult> createSinkAsync(CreateSinkRequest request) {
        return this.createSinkAsync(request, null);
    }

    @Override
    public Future<CreateSinkResult> createSinkAsync(CreateSinkRequest request, final AsyncHandler<CreateSinkRequest, CreateSinkResult> asyncHandler) {
        final CreateSinkRequest finalRequest = (CreateSinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSinkResult>(){

            @Override
            public CreateSinkResult call() throws Exception {
                CreateSinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeCreateSink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLinkResult> deleteLinkAsync(DeleteLinkRequest request) {
        return this.deleteLinkAsync(request, null);
    }

    @Override
    public Future<DeleteLinkResult> deleteLinkAsync(DeleteLinkRequest request, final AsyncHandler<DeleteLinkRequest, DeleteLinkResult> asyncHandler) {
        final DeleteLinkRequest finalRequest = (DeleteLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLinkResult>(){

            @Override
            public DeleteLinkResult call() throws Exception {
                DeleteLinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeDeleteLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSinkResult> deleteSinkAsync(DeleteSinkRequest request) {
        return this.deleteSinkAsync(request, null);
    }

    @Override
    public Future<DeleteSinkResult> deleteSinkAsync(DeleteSinkRequest request, final AsyncHandler<DeleteSinkRequest, DeleteSinkResult> asyncHandler) {
        final DeleteSinkRequest finalRequest = (DeleteSinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSinkResult>(){

            @Override
            public DeleteSinkResult call() throws Exception {
                DeleteSinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeDeleteSink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLinkResult> getLinkAsync(GetLinkRequest request) {
        return this.getLinkAsync(request, null);
    }

    @Override
    public Future<GetLinkResult> getLinkAsync(GetLinkRequest request, final AsyncHandler<GetLinkRequest, GetLinkResult> asyncHandler) {
        final GetLinkRequest finalRequest = (GetLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLinkResult>(){

            @Override
            public GetLinkResult call() throws Exception {
                GetLinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeGetLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSinkResult> getSinkAsync(GetSinkRequest request) {
        return this.getSinkAsync(request, null);
    }

    @Override
    public Future<GetSinkResult> getSinkAsync(GetSinkRequest request, final AsyncHandler<GetSinkRequest, GetSinkResult> asyncHandler) {
        final GetSinkRequest finalRequest = (GetSinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSinkResult>(){

            @Override
            public GetSinkResult call() throws Exception {
                GetSinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeGetSink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSinkPolicyResult> getSinkPolicyAsync(GetSinkPolicyRequest request) {
        return this.getSinkPolicyAsync(request, null);
    }

    @Override
    public Future<GetSinkPolicyResult> getSinkPolicyAsync(GetSinkPolicyRequest request, final AsyncHandler<GetSinkPolicyRequest, GetSinkPolicyResult> asyncHandler) {
        final GetSinkPolicyRequest finalRequest = (GetSinkPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSinkPolicyResult>(){

            @Override
            public GetSinkPolicyResult call() throws Exception {
                GetSinkPolicyResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeGetSinkPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttachedLinksResult> listAttachedLinksAsync(ListAttachedLinksRequest request) {
        return this.listAttachedLinksAsync(request, null);
    }

    @Override
    public Future<ListAttachedLinksResult> listAttachedLinksAsync(ListAttachedLinksRequest request, final AsyncHandler<ListAttachedLinksRequest, ListAttachedLinksResult> asyncHandler) {
        final ListAttachedLinksRequest finalRequest = (ListAttachedLinksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttachedLinksResult>(){

            @Override
            public ListAttachedLinksResult call() throws Exception {
                ListAttachedLinksResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeListAttachedLinks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLinksResult> listLinksAsync(ListLinksRequest request) {
        return this.listLinksAsync(request, null);
    }

    @Override
    public Future<ListLinksResult> listLinksAsync(ListLinksRequest request, final AsyncHandler<ListLinksRequest, ListLinksResult> asyncHandler) {
        final ListLinksRequest finalRequest = (ListLinksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLinksResult>(){

            @Override
            public ListLinksResult call() throws Exception {
                ListLinksResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeListLinks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSinksResult> listSinksAsync(ListSinksRequest request) {
        return this.listSinksAsync(request, null);
    }

    @Override
    public Future<ListSinksResult> listSinksAsync(ListSinksRequest request, final AsyncHandler<ListSinksRequest, ListSinksResult> asyncHandler) {
        final ListSinksRequest finalRequest = (ListSinksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSinksResult>(){

            @Override
            public ListSinksResult call() throws Exception {
                ListSinksResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeListSinks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSinkPolicyResult> putSinkPolicyAsync(PutSinkPolicyRequest request) {
        return this.putSinkPolicyAsync(request, null);
    }

    @Override
    public Future<PutSinkPolicyResult> putSinkPolicyAsync(PutSinkPolicyRequest request, final AsyncHandler<PutSinkPolicyRequest, PutSinkPolicyResult> asyncHandler) {
        final PutSinkPolicyRequest finalRequest = (PutSinkPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSinkPolicyResult>(){

            @Override
            public PutSinkPolicyResult call() throws Exception {
                PutSinkPolicyResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executePutSinkPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLinkResult> updateLinkAsync(UpdateLinkRequest request) {
        return this.updateLinkAsync(request, null);
    }

    @Override
    public Future<UpdateLinkResult> updateLinkAsync(UpdateLinkRequest request, final AsyncHandler<UpdateLinkRequest, UpdateLinkResult> asyncHandler) {
        final UpdateLinkRequest finalRequest = (UpdateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLinkResult>(){

            @Override
            public UpdateLinkResult call() throws Exception {
                UpdateLinkResult result = null;
                try {
                    result = AWSOAMAsyncClient.this.executeUpdateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

