/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.omics.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetSequenceStoreResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetSequenceStoreResultJsonUnmarshaller implements Unmarshaller<GetSequenceStoreResult, JsonUnmarshallerContext> {

    public GetSequenceStoreResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetSequenceStoreResult getSequenceStoreResult = new GetSequenceStoreResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getSequenceStoreResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sseConfig", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setSseConfig(SseConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setCreationTime(DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("fallbackLocation", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setFallbackLocation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3Access", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setS3Access(SequenceStoreS3AccessJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("eTagAlgorithmFamily", targetDepth)) {
                    context.nextToken();
                    getSequenceStoreResult.setETagAlgorithmFamily(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getSequenceStoreResult;
    }

    private static GetSequenceStoreResultJsonUnmarshaller instance;

    public static GetSequenceStoreResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetSequenceStoreResultJsonUnmarshaller();
        return instance;
    }
}
