/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opsworkscm.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes a configuration management server.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/Server" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Server implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     */
    private Boolean associatePublicIpAddress;
    /**
     * <p>
     * The number of automated backups to keep.
     * </p>
     */
    private Integer backupRetentionCount;
    /**
     * <p>
     * The name of the server.
     * </p>
     */
    private String serverName;
    /**
     * <p>
     * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The ARN of the CloudFormation stack that was used to create the server.
     * </p>
     */
    private String cloudFormationStackArn;
    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     */
    private Boolean disableAutomatedBackup;
    /**
     * <p>
     * A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     * </p>
     */
    private String endpoint;
    /**
     * <p>
     * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     */
    private String engine;
    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     */
    private String engineModel;
    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<EngineAttribute> engineAttributes;
    /**
     * <p>
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     * <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * The instance profile ARN of the server.
     * </p>
     */
    private String instanceProfileArn;
    /**
     * <p>
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance
     * type that is shown in the EC2 console.
     * </p>
     */
    private String instanceType;
    /**
     * <p>
     * The key pair associated with the server.
     * </p>
     */
    private String keyPair;
    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     */
    private String maintenanceStatus;
    /**
     * <p>
     * The preferred maintenance period specified for the server.
     * </p>
     */
    private String preferredMaintenanceWindow;
    /**
     * <p>
     * The preferred backup period specified for the server.
     * </p>
     */
    private String preferredBackupWindow;
    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     */
    private java.util.List<String> securityGroupIds;
    /**
     * <p>
     * The service role ARN used to create the server.
     * </p>
     */
    private String serviceRoleArn;
    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Depending on the server status, this field has either a human-readable message (such as a create or backup
     * error), or an escaped block of JSON (used for health check results).
     * </p>
     */
    private String statusReason;
    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     */
    private java.util.List<String> subnetIds;
    /**
     * <p>
     * The ARN of the server.
     * </p>
     */
    private String serverArn;

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     * 
     * @param associatePublicIpAddress
     *        Associate a public IP address with a server that you are launching.
     */

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     * 
     * @return Associate a public IP address with a server that you are launching.
     */

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     * 
     * @param associatePublicIpAddress
     *        Associate a public IP address with a server that you are launching.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        setAssociatePublicIpAddress(associatePublicIpAddress);
        return this;
    }

    /**
     * <p>
     * Associate a public IP address with a server that you are launching.
     * </p>
     * 
     * @return Associate a public IP address with a server that you are launching.
     */

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    /**
     * <p>
     * The number of automated backups to keep.
     * </p>
     * 
     * @param backupRetentionCount
     *        The number of automated backups to keep.
     */

    public void setBackupRetentionCount(Integer backupRetentionCount) {
        this.backupRetentionCount = backupRetentionCount;
    }

    /**
     * <p>
     * The number of automated backups to keep.
     * </p>
     * 
     * @return The number of automated backups to keep.
     */

    public Integer getBackupRetentionCount() {
        return this.backupRetentionCount;
    }

    /**
     * <p>
     * The number of automated backups to keep.
     * </p>
     * 
     * @param backupRetentionCount
     *        The number of automated backups to keep.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withBackupRetentionCount(Integer backupRetentionCount) {
        setBackupRetentionCount(backupRetentionCount);
        return this;
    }

    /**
     * <p>
     * The name of the server.
     * </p>
     * 
     * @param serverName
     *        The name of the server.
     */

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    /**
     * <p>
     * The name of the server.
     * </p>
     * 
     * @return The name of the server.
     */

    public String getServerName() {
        return this.serverName;
    }

    /**
     * <p>
     * The name of the server.
     * </p>
     * 
     * @param serverName
     *        The name of the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withServerName(String serverName) {
        setServerName(serverName);
        return this;
    }

    /**
     * <p>
     * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     * 
     * @param createdAt
     *        Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     * 
     * @return Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * </p>
     * 
     * @param createdAt
     *        Time stamp of server creation. Example <code>2016-07-29T13:38:47.520Z</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The ARN of the CloudFormation stack that was used to create the server.
     * </p>
     * 
     * @param cloudFormationStackArn
     *        The ARN of the CloudFormation stack that was used to create the server.
     */

    public void setCloudFormationStackArn(String cloudFormationStackArn) {
        this.cloudFormationStackArn = cloudFormationStackArn;
    }

    /**
     * <p>
     * The ARN of the CloudFormation stack that was used to create the server.
     * </p>
     * 
     * @return The ARN of the CloudFormation stack that was used to create the server.
     */

    public String getCloudFormationStackArn() {
        return this.cloudFormationStackArn;
    }

    /**
     * <p>
     * The ARN of the CloudFormation stack that was used to create the server.
     * </p>
     * 
     * @param cloudFormationStackArn
     *        The ARN of the CloudFormation stack that was used to create the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withCloudFormationStackArn(String cloudFormationStackArn) {
        setCloudFormationStackArn(cloudFormationStackArn);
        return this;
    }

    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     * 
     * @param disableAutomatedBackup
     *        Disables automated backups. The number of stored backups is dependent on the value of
     *        PreferredBackupCount.
     */

    public void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
        this.disableAutomatedBackup = disableAutomatedBackup;
    }

    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     * 
     * @return Disables automated backups. The number of stored backups is dependent on the value of
     *         PreferredBackupCount.
     */

    public Boolean getDisableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     * 
     * @param disableAutomatedBackup
     *        Disables automated backups. The number of stored backups is dependent on the value of
     *        PreferredBackupCount.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withDisableAutomatedBackup(Boolean disableAutomatedBackup) {
        setDisableAutomatedBackup(disableAutomatedBackup);
        return this;
    }

    /**
     * <p>
     * Disables automated backups. The number of stored backups is dependent on the value of PreferredBackupCount.
     * </p>
     * 
     * @return Disables automated backups. The number of stored backups is dependent on the value of
     *         PreferredBackupCount.
     */

    public Boolean isDisableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    /**
     * <p>
     * A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     * </p>
     * 
     * @param endpoint
     *        A DNS name that can be used to access the engine. Example:
     *        <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     */

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    /**
     * <p>
     * A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     * </p>
     * 
     * @return A DNS name that can be used to access the engine. Example:
     *         <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     */

    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * <p>
     * A DNS name that can be used to access the engine. Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     * </p>
     * 
     * @param endpoint
     *        A DNS name that can be used to access the engine. Example:
     *        <code>myserver-asdfghjkl.us-east-1.opsworks.io</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEndpoint(String endpoint) {
        setEndpoint(endpoint);
        return this;
    }

    /**
     * <p>
     * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     * 
     * @param engine
     *        The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     *        <code>Puppet</code>.
     */

    public void setEngine(String engine) {
        this.engine = engine;
    }

    /**
     * <p>
     * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     * 
     * @return The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     *         <code>Puppet</code>.
     */

    public String getEngine() {
        return this.engine;
    }

    /**
     * <p>
     * The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     * <code>Puppet</code>.
     * </p>
     * 
     * @param engine
     *        The engine type of the server. Valid values in this release include <code>ChefAutomate</code> and
     *        <code>Puppet</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEngine(String engine) {
        setEngine(engine);
        return this;
    }

    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     * 
     * @param engineModel
     *        The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet
     *        and <code>Single</code> for Chef.
     */

    public void setEngineModel(String engineModel) {
        this.engineModel = engineModel;
    }

    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     * 
     * @return The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet
     *         and <code>Single</code> for Chef.
     */

    public String getEngineModel() {
        return this.engineModel;
    }

    /**
     * <p>
     * The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet and
     * <code>Single</code> for Chef.
     * </p>
     * 
     * @param engineModel
     *        The engine model of the server. Valid values in this release include <code>Monolithic</code> for Puppet
     *        and <code>Single</code> for Chef.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEngineModel(String engineModel) {
        setEngineModel(engineModel);
        return this;
    }

    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The response of a createServer() request returns the master credential to access the server in
     *         EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of
     *         the result of createServer(). </p>
     *         <p class="title">
     *         <b>Attributes returned in a createServer response for Chef</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS
     *         OpsWorks for Chef Automate. This private key is required to access the Chef API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     *         includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and
     *         then change to the directory where you've unzipped the file contents. From this directory, you can run
     *         Knife commands.
     *         </p>
     *         </li>
     *         </ul>
     *         <p class="title">
     *         <b>Attributes returned in a createServer response for Puppet</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
     *         including a README and a required private key. Save this file, unzip it, and then change to the directory
     *         where you've unzipped the file contents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     *         Enterprise console after the server is online.
     *         </p>
     *         </li>
     */

    public java.util.List<EngineAttribute> getEngineAttributes() {
        return engineAttributes;
    }

    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     * 
     * @param engineAttributes
     *        The response of a createServer() request returns the master credential to access the server in
     *        EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of
     *        the result of createServer(). </p>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Chef</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
     *        for Chef Automate. This private key is required to access the Chef API.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     *        includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and
     *        then change to the directory where you've unzipped the file contents. From this directory, you can run
     *        Knife commands.
     *        </p>
     *        </li>
     *        </ul>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Puppet</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
     *        including a README and a required private key. Save this file, unzip it, and then change to the directory
     *        where you've unzipped the file contents.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     *        Enterprise console after the server is online.
     *        </p>
     *        </li>
     */

    public void setEngineAttributes(java.util.Collection<EngineAttribute> engineAttributes) {
        if (engineAttributes == null) {
            this.engineAttributes = null;
            return;
        }

        this.engineAttributes = new java.util.ArrayList<EngineAttribute>(engineAttributes);
    }

    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEngineAttributes(java.util.Collection)} or {@link #withEngineAttributes(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param engineAttributes
     *        The response of a createServer() request returns the master credential to access the server in
     *        EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of
     *        the result of createServer(). </p>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Chef</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
     *        for Chef Automate. This private key is required to access the Chef API.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     *        includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and
     *        then change to the directory where you've unzipped the file contents. From this directory, you can run
     *        Knife commands.
     *        </p>
     *        </li>
     *        </ul>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Puppet</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
     *        including a README and a required private key. Save this file, unzip it, and then change to the directory
     *        where you've unzipped the file contents.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     *        Enterprise console after the server is online.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEngineAttributes(EngineAttribute... engineAttributes) {
        if (this.engineAttributes == null) {
            setEngineAttributes(new java.util.ArrayList<EngineAttribute>(engineAttributes.length));
        }
        for (EngineAttribute ele : engineAttributes) {
            this.engineAttributes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The response of a createServer() request returns the master credential to access the server in EngineAttributes.
     * These credentials are not stored by AWS OpsWorks CM; they are returned only as part of the result of
     * createServer().
     * </p>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Chef</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks for
     * Chef Automate. This private key is required to access the Chef API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     * includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and then
     * change to the directory where you've unzipped the file contents. From this directory, you can run Knife commands.
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Attributes returned in a createServer response for Puppet</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit, including
     * a README and a required private key. Save this file, unzip it, and then change to the directory where you've
     * unzipped the file contents.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     * Enterprise console after the server is online.
     * </p>
     * </li>
     * </ul>
     * 
     * @param engineAttributes
     *        The response of a createServer() request returns the master credential to access the server in
     *        EngineAttributes. These credentials are not stored by AWS OpsWorks CM; they are returned only as part of
     *        the result of createServer(). </p>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Chef</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CHEF_AUTOMATE_PIVOTAL_KEY</code>: A base64-encoded RSA private key that is generated by AWS OpsWorks
     *        for Chef Automate. This private key is required to access the Chef API.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CHEF_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Chef starter kit, which
     *        includes a README, a configuration file, and the required RSA private key. Save this file, unzip it, and
     *        then change to the directory where you've unzipped the file contents. From this directory, you can run
     *        Knife commands.
     *        </p>
     *        </li>
     *        </ul>
     *        <p class="title">
     *        <b>Attributes returned in a createServer response for Puppet</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PUPPET_STARTER_KIT</code>: A base64-encoded ZIP file. The ZIP file contains a Puppet starter kit,
     *        including a README and a required private key. Save this file, unzip it, and then change to the directory
     *        where you've unzipped the file contents.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PUPPET_ADMIN_PASSWORD</code>: An administrator password that you can use to sign in to the Puppet
     *        Enterprise console after the server is online.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEngineAttributes(java.util.Collection<EngineAttribute> engineAttributes) {
        setEngineAttributes(engineAttributes);
        return this;
    }

    /**
     * <p>
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     * <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * </p>
     * 
     * @param engineVersion
     *        The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     *        <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     */

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     * <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * </p>
     * 
     * @return The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     *         <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     */

    public String getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     * <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * </p>
     * 
     * @param engineVersion
     *        The engine version of the server. For a Chef server, the valid value for EngineVersion is currently
     *        <code>12</code>. For a Puppet server, the valid value is <code>2017</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withEngineVersion(String engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * The instance profile ARN of the server.
     * </p>
     * 
     * @param instanceProfileArn
     *        The instance profile ARN of the server.
     */

    public void setInstanceProfileArn(String instanceProfileArn) {
        this.instanceProfileArn = instanceProfileArn;
    }

    /**
     * <p>
     * The instance profile ARN of the server.
     * </p>
     * 
     * @return The instance profile ARN of the server.
     */

    public String getInstanceProfileArn() {
        return this.instanceProfileArn;
    }

    /**
     * <p>
     * The instance profile ARN of the server.
     * </p>
     * 
     * @param instanceProfileArn
     *        The instance profile ARN of the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withInstanceProfileArn(String instanceProfileArn) {
        setInstanceProfileArn(instanceProfileArn);
        return this;
    }

    /**
     * <p>
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance
     * type that is shown in the EC2 console.
     * </p>
     * 
     * @param instanceType
     *        The instance type for the server, as specified in the CloudFormation stack. This might not be the same
     *        instance type that is shown in the EC2 console.
     */

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    /**
     * <p>
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance
     * type that is shown in the EC2 console.
     * </p>
     * 
     * @return The instance type for the server, as specified in the CloudFormation stack. This might not be the same
     *         instance type that is shown in the EC2 console.
     */

    public String getInstanceType() {
        return this.instanceType;
    }

    /**
     * <p>
     * The instance type for the server, as specified in the CloudFormation stack. This might not be the same instance
     * type that is shown in the EC2 console.
     * </p>
     * 
     * @param instanceType
     *        The instance type for the server, as specified in the CloudFormation stack. This might not be the same
     *        instance type that is shown in the EC2 console.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withInstanceType(String instanceType) {
        setInstanceType(instanceType);
        return this;
    }

    /**
     * <p>
     * The key pair associated with the server.
     * </p>
     * 
     * @param keyPair
     *        The key pair associated with the server.
     */

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    /**
     * <p>
     * The key pair associated with the server.
     * </p>
     * 
     * @return The key pair associated with the server.
     */

    public String getKeyPair() {
        return this.keyPair;
    }

    /**
     * <p>
     * The key pair associated with the server.
     * </p>
     * 
     * @param keyPair
     *        The key pair associated with the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withKeyPair(String keyPair) {
        setKeyPair(keyPair);
        return this;
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * 
     * @param maintenanceStatus
     *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @see MaintenanceStatus
     */

    public void setMaintenanceStatus(String maintenanceStatus) {
        this.maintenanceStatus = maintenanceStatus;
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * 
     * @return The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @see MaintenanceStatus
     */

    public String getMaintenanceStatus() {
        return this.maintenanceStatus;
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * 
     * @param maintenanceStatus
     *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MaintenanceStatus
     */

    public Server withMaintenanceStatus(String maintenanceStatus) {
        setMaintenanceStatus(maintenanceStatus);
        return this;
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * 
     * @param maintenanceStatus
     *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @see MaintenanceStatus
     */

    public void setMaintenanceStatus(MaintenanceStatus maintenanceStatus) {
        withMaintenanceStatus(maintenanceStatus);
    }

    /**
     * <p>
     * The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * </p>
     * 
     * @param maintenanceStatus
     *        The status of the most recent server maintenance run. Shows <code>SUCCESS</code> or <code>FAILED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MaintenanceStatus
     */

    public Server withMaintenanceStatus(MaintenanceStatus maintenanceStatus) {
        this.maintenanceStatus = maintenanceStatus.toString();
        return this;
    }

    /**
     * <p>
     * The preferred maintenance period specified for the server.
     * </p>
     * 
     * @param preferredMaintenanceWindow
     *        The preferred maintenance period specified for the server.
     */

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The preferred maintenance period specified for the server.
     * </p>
     * 
     * @return The preferred maintenance period specified for the server.
     */

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The preferred maintenance period specified for the server.
     * </p>
     * 
     * @param preferredMaintenanceWindow
     *        The preferred maintenance period specified for the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    /**
     * <p>
     * The preferred backup period specified for the server.
     * </p>
     * 
     * @param preferredBackupWindow
     *        The preferred backup period specified for the server.
     */

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    /**
     * <p>
     * The preferred backup period specified for the server.
     * </p>
     * 
     * @return The preferred backup period specified for the server.
     */

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    /**
     * <p>
     * The preferred backup period specified for the server.
     * </p>
     * 
     * @param preferredBackupWindow
     *        The preferred backup period specified for the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withPreferredBackupWindow(String preferredBackupWindow) {
        setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     * 
     * @return The security group IDs for the server, as specified in the CloudFormation stack. These might not be the
     *         same security groups that are shown in the EC2 console.
     */

    public java.util.List<String> getSecurityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     * 
     * @param securityGroupIds
     *        The security group IDs for the server, as specified in the CloudFormation stack. These might not be the
     *        same security groups that are shown in the EC2 console.
     */

    public void setSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }

        this.securityGroupIds = new java.util.ArrayList<String>(securityGroupIds);
    }

    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSecurityGroupIds(java.util.Collection)} or {@link #withSecurityGroupIds(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param securityGroupIds
     *        The security group IDs for the server, as specified in the CloudFormation stack. These might not be the
     *        same security groups that are shown in the EC2 console.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withSecurityGroupIds(String... securityGroupIds) {
        if (this.securityGroupIds == null) {
            setSecurityGroupIds(new java.util.ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The security group IDs for the server, as specified in the CloudFormation stack. These might not be the same
     * security groups that are shown in the EC2 console.
     * </p>
     * 
     * @param securityGroupIds
     *        The security group IDs for the server, as specified in the CloudFormation stack. These might not be the
     *        same security groups that are shown in the EC2 console.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        setSecurityGroupIds(securityGroupIds);
        return this;
    }

    /**
     * <p>
     * The service role ARN used to create the server.
     * </p>
     * 
     * @param serviceRoleArn
     *        The service role ARN used to create the server.
     */

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    /**
     * <p>
     * The service role ARN used to create the server.
     * </p>
     * 
     * @return The service role ARN used to create the server.
     */

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    /**
     * <p>
     * The service role ARN used to create the server.
     * </p>
     * 
     * @param serviceRoleArn
     *        The service role ARN used to create the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withServiceRoleArn(String serviceRoleArn) {
        setServiceRoleArn(serviceRoleArn);
        return this;
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * 
     * @param status
     *        The server's status. This field displays the states of actions in progress, such as creating, running, or
     *        backing up the server, as well as the server's health state.
     * @see ServerStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * 
     * @return The server's status. This field displays the states of actions in progress, such as creating, running, or
     *         backing up the server, as well as the server's health state.
     * @see ServerStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * 
     * @param status
     *        The server's status. This field displays the states of actions in progress, such as creating, running, or
     *        backing up the server, as well as the server's health state.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ServerStatus
     */

    public Server withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * 
     * @param status
     *        The server's status. This field displays the states of actions in progress, such as creating, running, or
     *        backing up the server, as well as the server's health state.
     * @see ServerStatus
     */

    public void setStatus(ServerStatus status) {
        withStatus(status);
    }

    /**
     * <p>
     * The server's status. This field displays the states of actions in progress, such as creating, running, or backing
     * up the server, as well as the server's health state.
     * </p>
     * 
     * @param status
     *        The server's status. This field displays the states of actions in progress, such as creating, running, or
     *        backing up the server, as well as the server's health state.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ServerStatus
     */

    public Server withStatus(ServerStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * Depending on the server status, this field has either a human-readable message (such as a create or backup
     * error), or an escaped block of JSON (used for health check results).
     * </p>
     * 
     * @param statusReason
     *        Depending on the server status, this field has either a human-readable message (such as a create or backup
     *        error), or an escaped block of JSON (used for health check results).
     */

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    /**
     * <p>
     * Depending on the server status, this field has either a human-readable message (such as a create or backup
     * error), or an escaped block of JSON (used for health check results).
     * </p>
     * 
     * @return Depending on the server status, this field has either a human-readable message (such as a create or
     *         backup error), or an escaped block of JSON (used for health check results).
     */

    public String getStatusReason() {
        return this.statusReason;
    }

    /**
     * <p>
     * Depending on the server status, this field has either a human-readable message (such as a create or backup
     * error), or an escaped block of JSON (used for health check results).
     * </p>
     * 
     * @param statusReason
     *        Depending on the server status, this field has either a human-readable message (such as a create or backup
     *        error), or an escaped block of JSON (used for health check results).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withStatusReason(String statusReason) {
        setStatusReason(statusReason);
        return this;
    }

    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     * 
     * @return The subnet IDs specified in a CreateServer request.
     */

    public java.util.List<String> getSubnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     * 
     * @param subnetIds
     *        The subnet IDs specified in a CreateServer request.
     */

    public void setSubnetIds(java.util.Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }

        this.subnetIds = new java.util.ArrayList<String>(subnetIds);
    }

    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubnetIds(java.util.Collection)} or {@link #withSubnetIds(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param subnetIds
     *        The subnet IDs specified in a CreateServer request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withSubnetIds(String... subnetIds) {
        if (this.subnetIds == null) {
            setSubnetIds(new java.util.ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The subnet IDs specified in a CreateServer request.
     * </p>
     * 
     * @param subnetIds
     *        The subnet IDs specified in a CreateServer request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withSubnetIds(java.util.Collection<String> subnetIds) {
        setSubnetIds(subnetIds);
        return this;
    }

    /**
     * <p>
     * The ARN of the server.
     * </p>
     * 
     * @param serverArn
     *        The ARN of the server.
     */

    public void setServerArn(String serverArn) {
        this.serverArn = serverArn;
    }

    /**
     * <p>
     * The ARN of the server.
     * </p>
     * 
     * @return The ARN of the server.
     */

    public String getServerArn() {
        return this.serverArn;
    }

    /**
     * <p>
     * The ARN of the server.
     * </p>
     * 
     * @param serverArn
     *        The ARN of the server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Server withServerArn(String serverArn) {
        setServerArn(serverArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAssociatePublicIpAddress() != null)
            sb.append("AssociatePublicIpAddress: ").append(getAssociatePublicIpAddress()).append(",");
        if (getBackupRetentionCount() != null)
            sb.append("BackupRetentionCount: ").append(getBackupRetentionCount()).append(",");
        if (getServerName() != null)
            sb.append("ServerName: ").append(getServerName()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getCloudFormationStackArn() != null)
            sb.append("CloudFormationStackArn: ").append(getCloudFormationStackArn()).append(",");
        if (getDisableAutomatedBackup() != null)
            sb.append("DisableAutomatedBackup: ").append(getDisableAutomatedBackup()).append(",");
        if (getEndpoint() != null)
            sb.append("Endpoint: ").append(getEndpoint()).append(",");
        if (getEngine() != null)
            sb.append("Engine: ").append(getEngine()).append(",");
        if (getEngineModel() != null)
            sb.append("EngineModel: ").append(getEngineModel()).append(",");
        if (getEngineAttributes() != null)
            sb.append("EngineAttributes: ").append(getEngineAttributes()).append(",");
        if (getEngineVersion() != null)
            sb.append("EngineVersion: ").append(getEngineVersion()).append(",");
        if (getInstanceProfileArn() != null)
            sb.append("InstanceProfileArn: ").append(getInstanceProfileArn()).append(",");
        if (getInstanceType() != null)
            sb.append("InstanceType: ").append(getInstanceType()).append(",");
        if (getKeyPair() != null)
            sb.append("KeyPair: ").append(getKeyPair()).append(",");
        if (getMaintenanceStatus() != null)
            sb.append("MaintenanceStatus: ").append(getMaintenanceStatus()).append(",");
        if (getPreferredMaintenanceWindow() != null)
            sb.append("PreferredMaintenanceWindow: ").append(getPreferredMaintenanceWindow()).append(",");
        if (getPreferredBackupWindow() != null)
            sb.append("PreferredBackupWindow: ").append(getPreferredBackupWindow()).append(",");
        if (getSecurityGroupIds() != null)
            sb.append("SecurityGroupIds: ").append(getSecurityGroupIds()).append(",");
        if (getServiceRoleArn() != null)
            sb.append("ServiceRoleArn: ").append(getServiceRoleArn()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getStatusReason() != null)
            sb.append("StatusReason: ").append(getStatusReason()).append(",");
        if (getSubnetIds() != null)
            sb.append("SubnetIds: ").append(getSubnetIds()).append(",");
        if (getServerArn() != null)
            sb.append("ServerArn: ").append(getServerArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Server == false)
            return false;
        Server other = (Server) obj;
        if (other.getAssociatePublicIpAddress() == null ^ this.getAssociatePublicIpAddress() == null)
            return false;
        if (other.getAssociatePublicIpAddress() != null && other.getAssociatePublicIpAddress().equals(this.getAssociatePublicIpAddress()) == false)
            return false;
        if (other.getBackupRetentionCount() == null ^ this.getBackupRetentionCount() == null)
            return false;
        if (other.getBackupRetentionCount() != null && other.getBackupRetentionCount().equals(this.getBackupRetentionCount()) == false)
            return false;
        if (other.getServerName() == null ^ this.getServerName() == null)
            return false;
        if (other.getServerName() != null && other.getServerName().equals(this.getServerName()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getCloudFormationStackArn() == null ^ this.getCloudFormationStackArn() == null)
            return false;
        if (other.getCloudFormationStackArn() != null && other.getCloudFormationStackArn().equals(this.getCloudFormationStackArn()) == false)
            return false;
        if (other.getDisableAutomatedBackup() == null ^ this.getDisableAutomatedBackup() == null)
            return false;
        if (other.getDisableAutomatedBackup() != null && other.getDisableAutomatedBackup().equals(this.getDisableAutomatedBackup()) == false)
            return false;
        if (other.getEndpoint() == null ^ this.getEndpoint() == null)
            return false;
        if (other.getEndpoint() != null && other.getEndpoint().equals(this.getEndpoint()) == false)
            return false;
        if (other.getEngine() == null ^ this.getEngine() == null)
            return false;
        if (other.getEngine() != null && other.getEngine().equals(this.getEngine()) == false)
            return false;
        if (other.getEngineModel() == null ^ this.getEngineModel() == null)
            return false;
        if (other.getEngineModel() != null && other.getEngineModel().equals(this.getEngineModel()) == false)
            return false;
        if (other.getEngineAttributes() == null ^ this.getEngineAttributes() == null)
            return false;
        if (other.getEngineAttributes() != null && other.getEngineAttributes().equals(this.getEngineAttributes()) == false)
            return false;
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null)
            return false;
        if (other.getEngineVersion() != null && other.getEngineVersion().equals(this.getEngineVersion()) == false)
            return false;
        if (other.getInstanceProfileArn() == null ^ this.getInstanceProfileArn() == null)
            return false;
        if (other.getInstanceProfileArn() != null && other.getInstanceProfileArn().equals(this.getInstanceProfileArn()) == false)
            return false;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null)
            return false;
        if (other.getInstanceType() != null && other.getInstanceType().equals(this.getInstanceType()) == false)
            return false;
        if (other.getKeyPair() == null ^ this.getKeyPair() == null)
            return false;
        if (other.getKeyPair() != null && other.getKeyPair().equals(this.getKeyPair()) == false)
            return false;
        if (other.getMaintenanceStatus() == null ^ this.getMaintenanceStatus() == null)
            return false;
        if (other.getMaintenanceStatus() != null && other.getMaintenanceStatus().equals(this.getMaintenanceStatus()) == false)
            return false;
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null)
            return false;
        if (other.getPreferredMaintenanceWindow() != null && other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow()) == false)
            return false;
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null)
            return false;
        if (other.getPreferredBackupWindow() != null && other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow()) == false)
            return false;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null)
            return false;
        if (other.getSecurityGroupIds() != null && other.getSecurityGroupIds().equals(this.getSecurityGroupIds()) == false)
            return false;
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null)
            return false;
        if (other.getServiceRoleArn() != null && other.getServiceRoleArn().equals(this.getServiceRoleArn()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getStatusReason() == null ^ this.getStatusReason() == null)
            return false;
        if (other.getStatusReason() != null && other.getStatusReason().equals(this.getStatusReason()) == false)
            return false;
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null)
            return false;
        if (other.getSubnetIds() != null && other.getSubnetIds().equals(this.getSubnetIds()) == false)
            return false;
        if (other.getServerArn() == null ^ this.getServerArn() == null)
            return false;
        if (other.getServerArn() != null && other.getServerArn().equals(this.getServerArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAssociatePublicIpAddress() == null) ? 0 : getAssociatePublicIpAddress().hashCode());
        hashCode = prime * hashCode + ((getBackupRetentionCount() == null) ? 0 : getBackupRetentionCount().hashCode());
        hashCode = prime * hashCode + ((getServerName() == null) ? 0 : getServerName().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getCloudFormationStackArn() == null) ? 0 : getCloudFormationStackArn().hashCode());
        hashCode = prime * hashCode + ((getDisableAutomatedBackup() == null) ? 0 : getDisableAutomatedBackup().hashCode());
        hashCode = prime * hashCode + ((getEndpoint() == null) ? 0 : getEndpoint().hashCode());
        hashCode = prime * hashCode + ((getEngine() == null) ? 0 : getEngine().hashCode());
        hashCode = prime * hashCode + ((getEngineModel() == null) ? 0 : getEngineModel().hashCode());
        hashCode = prime * hashCode + ((getEngineAttributes() == null) ? 0 : getEngineAttributes().hashCode());
        hashCode = prime * hashCode + ((getEngineVersion() == null) ? 0 : getEngineVersion().hashCode());
        hashCode = prime * hashCode + ((getInstanceProfileArn() == null) ? 0 : getInstanceProfileArn().hashCode());
        hashCode = prime * hashCode + ((getInstanceType() == null) ? 0 : getInstanceType().hashCode());
        hashCode = prime * hashCode + ((getKeyPair() == null) ? 0 : getKeyPair().hashCode());
        hashCode = prime * hashCode + ((getMaintenanceStatus() == null) ? 0 : getMaintenanceStatus().hashCode());
        hashCode = prime * hashCode + ((getPreferredMaintenanceWindow() == null) ? 0 : getPreferredMaintenanceWindow().hashCode());
        hashCode = prime * hashCode + ((getPreferredBackupWindow() == null) ? 0 : getPreferredBackupWindow().hashCode());
        hashCode = prime * hashCode + ((getSecurityGroupIds() == null) ? 0 : getSecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getServiceRoleArn() == null) ? 0 : getServiceRoleArn().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getStatusReason() == null) ? 0 : getStatusReason().hashCode());
        hashCode = prime * hashCode + ((getSubnetIds() == null) ? 0 : getSubnetIds().hashCode());
        hashCode = prime * hashCode + ((getServerArn() == null) ? 0 : getServerArn().hashCode());
        return hashCode;
    }

    @Override
    public Server clone() {
        try {
            return (Server) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.opsworkscm.model.transform.ServerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
