/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.panorama.model.PackageListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPackagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PackageListItem> packages;
    private String nextToken;

    public List<PackageListItem> getPackages() {
        return this.packages;
    }

    public void setPackages(Collection<PackageListItem> packages) {
        if (packages == null) {
            this.packages = null;
            return;
        }
        this.packages = new ArrayList<PackageListItem>(packages);
    }

    public ListPackagesResult withPackages(PackageListItem ... packages) {
        if (this.packages == null) {
            this.setPackages(new ArrayList<PackageListItem>(packages.length));
        }
        for (PackageListItem ele : packages) {
            this.packages.add(ele);
        }
        return this;
    }

    public ListPackagesResult withPackages(Collection<PackageListItem> packages) {
        this.setPackages(packages);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPackagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackages() != null) {
            sb.append("Packages: ").append(this.getPackages()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagesResult)) {
            return false;
        }
        ListPackagesResult other = (ListPackagesResult)obj;
        if (other.getPackages() == null ^ this.getPackages() == null) {
            return false;
        }
        if (other.getPackages() != null && !other.getPackages().equals(this.getPackages())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackages() == null ? 0 : this.getPackages().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPackagesResult clone() {
        try {
            return (ListPackagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

