/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.AttributesResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttributesResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String attributeType;
    private List<String> attributes;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public AttributesResource withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public AttributesResource withAttributeType(String attributeType) {
        this.setAttributeType(attributeType);
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<String> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<String>(attributes);
    }

    public AttributesResource withAttributes(String ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<String>(attributes.length));
        }
        for (String ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public AttributesResource withAttributes(Collection<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getAttributeType() != null) {
            sb.append("AttributeType: ").append(this.getAttributeType()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributesResource)) {
            return false;
        }
        AttributesResource other = (AttributesResource)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getAttributeType() == null ^ this.getAttributeType() == null) {
            return false;
        }
        if (other.getAttributeType() != null && !other.getAttributeType().equals(this.getAttributeType())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeType() == null ? 0 : this.getAttributeType().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public AttributesResource clone() {
        try {
            return (AttributesResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributesResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

