/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration;
import com.amazonaws.services.quicksight.model.SessionTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GenerateEmbedUrlForAnonymousUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private Long sessionLifetimeInMinutes;
    private String namespace;
    private List<SessionTag> sessionTags;
    private List<String> authorizedResourceArns;
    private AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
        this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
    }

    public Long getSessionLifetimeInMinutes() {
        return this.sessionLifetimeInMinutes;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
        this.setSessionLifetimeInMinutes(sessionLifetimeInMinutes);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<SessionTag> getSessionTags() {
        return this.sessionTags;
    }

    public void setSessionTags(Collection<SessionTag> sessionTags) {
        if (sessionTags == null) {
            this.sessionTags = null;
            return;
        }
        this.sessionTags = new ArrayList<SessionTag>(sessionTags);
    }

    public GenerateEmbedUrlForAnonymousUserRequest withSessionTags(SessionTag ... sessionTags) {
        if (this.sessionTags == null) {
            this.setSessionTags(new ArrayList<SessionTag>(sessionTags.length));
        }
        for (SessionTag ele : sessionTags) {
            this.sessionTags.add(ele);
        }
        return this;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withSessionTags(Collection<SessionTag> sessionTags) {
        this.setSessionTags(sessionTags);
        return this;
    }

    public List<String> getAuthorizedResourceArns() {
        return this.authorizedResourceArns;
    }

    public void setAuthorizedResourceArns(Collection<String> authorizedResourceArns) {
        if (authorizedResourceArns == null) {
            this.authorizedResourceArns = null;
            return;
        }
        this.authorizedResourceArns = new ArrayList<String>(authorizedResourceArns);
    }

    public GenerateEmbedUrlForAnonymousUserRequest withAuthorizedResourceArns(String ... authorizedResourceArns) {
        if (this.authorizedResourceArns == null) {
            this.setAuthorizedResourceArns(new ArrayList<String>(authorizedResourceArns.length));
        }
        for (String ele : authorizedResourceArns) {
            this.authorizedResourceArns.add(ele);
        }
        return this;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withAuthorizedResourceArns(Collection<String> authorizedResourceArns) {
        this.setAuthorizedResourceArns(authorizedResourceArns);
        return this;
    }

    public void setExperienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration) {
        this.experienceConfiguration = experienceConfiguration;
    }

    public AnonymousUserEmbeddingExperienceConfiguration getExperienceConfiguration() {
        return this.experienceConfiguration;
    }

    public GenerateEmbedUrlForAnonymousUserRequest withExperienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration) {
        this.setExperienceConfiguration(experienceConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getSessionLifetimeInMinutes() != null) {
            sb.append("SessionLifetimeInMinutes: ").append(this.getSessionLifetimeInMinutes()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getSessionTags() != null) {
            sb.append("SessionTags: ").append(this.getSessionTags()).append(",");
        }
        if (this.getAuthorizedResourceArns() != null) {
            sb.append("AuthorizedResourceArns: ").append(this.getAuthorizedResourceArns()).append(",");
        }
        if (this.getExperienceConfiguration() != null) {
            sb.append("ExperienceConfiguration: ").append(this.getExperienceConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateEmbedUrlForAnonymousUserRequest)) {
            return false;
        }
        GenerateEmbedUrlForAnonymousUserRequest other = (GenerateEmbedUrlForAnonymousUserRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getSessionLifetimeInMinutes() == null ^ this.getSessionLifetimeInMinutes() == null) {
            return false;
        }
        if (other.getSessionLifetimeInMinutes() != null && !other.getSessionLifetimeInMinutes().equals(this.getSessionLifetimeInMinutes())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getSessionTags() == null ^ this.getSessionTags() == null) {
            return false;
        }
        if (other.getSessionTags() != null && !other.getSessionTags().equals(this.getSessionTags())) {
            return false;
        }
        if (other.getAuthorizedResourceArns() == null ^ this.getAuthorizedResourceArns() == null) {
            return false;
        }
        if (other.getAuthorizedResourceArns() != null && !other.getAuthorizedResourceArns().equals(this.getAuthorizedResourceArns())) {
            return false;
        }
        if (other.getExperienceConfiguration() == null ^ this.getExperienceConfiguration() == null) {
            return false;
        }
        return other.getExperienceConfiguration() == null || other.getExperienceConfiguration().equals(this.getExperienceConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionLifetimeInMinutes() == null ? 0 : this.getSessionLifetimeInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getSessionTags() == null ? 0 : this.getSessionTags().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizedResourceArns() == null ? 0 : this.getAuthorizedResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getExperienceConfiguration() == null ? 0 : this.getExperienceConfiguration().hashCode());
        return hashCode;
    }

    public GenerateEmbedUrlForAnonymousUserRequest clone() {
        return (GenerateEmbedUrlForAnonymousUserRequest)super.clone();
    }
}

