/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DBSnapshot;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeDBSnapshotsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<DBSnapshot> dBSnapshots;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeDBSnapshotsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<DBSnapshot> getDBSnapshots() {
        if (this.dBSnapshots == null) {
            this.dBSnapshots = new SdkInternalList();
        }
        return this.dBSnapshots;
    }

    public void setDBSnapshots(Collection<DBSnapshot> dBSnapshots) {
        if (dBSnapshots == null) {
            this.dBSnapshots = null;
            return;
        }
        this.dBSnapshots = new SdkInternalList(dBSnapshots);
    }

    public DescribeDBSnapshotsResult withDBSnapshots(DBSnapshot ... dBSnapshots) {
        if (this.dBSnapshots == null) {
            this.setDBSnapshots((Collection<DBSnapshot>)new SdkInternalList(dBSnapshots.length));
        }
        for (DBSnapshot ele : dBSnapshots) {
            this.dBSnapshots.add((Object)ele);
        }
        return this;
    }

    public DescribeDBSnapshotsResult withDBSnapshots(Collection<DBSnapshot> dBSnapshots) {
        this.setDBSnapshots(dBSnapshots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getDBSnapshots() != null) {
            sb.append("DBSnapshots: " + this.getDBSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSnapshotsResult)) {
            return false;
        }
        DescribeDBSnapshotsResult other = (DescribeDBSnapshotsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getDBSnapshots() == null ^ this.getDBSnapshots() == null) {
            return false;
        }
        return other.getDBSnapshots() == null || other.getDBSnapshots().equals(this.getDBSnapshots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getDBSnapshots() == null ? 0 : this.getDBSnapshots().hashCode());
        return hashCode;
    }

    public DescribeDBSnapshotsResult clone() {
        try {
            return (DescribeDBSnapshotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

