/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeCustomAvailabilityZonesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCustomAvailabilityZonesRequestMarshaller
implements Marshaller<Request<DescribeCustomAvailabilityZonesRequest>, DescribeCustomAvailabilityZonesRequest> {
    public Request<DescribeCustomAvailabilityZonesRequest> marshall(DescribeCustomAvailabilityZonesRequest describeCustomAvailabilityZonesRequest) {
        if (describeCustomAvailabilityZonesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCustomAvailabilityZonesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeCustomAvailabilityZones");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCustomAvailabilityZonesRequest.getCustomAvailabilityZoneId() != null) {
            request.addParameter("CustomAvailabilityZoneId", StringUtils.fromString((String)describeCustomAvailabilityZonesRequest.getCustomAvailabilityZoneId()));
        }
        if (!describeCustomAvailabilityZonesRequest.getFilters().isEmpty() || !((SdkInternalList)describeCustomAvailabilityZonesRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeCustomAvailabilityZonesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeCustomAvailabilityZonesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeCustomAvailabilityZonesRequest.getMaxRecords()));
        }
        if (describeCustomAvailabilityZonesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeCustomAvailabilityZonesRequest.getMarker()));
        }
        return request;
    }
}

