/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.redshiftserverless.model.EndpointAccess;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EndpointAccessMarshaller {
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("address").build();
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointArn").build();
    private static final MarshallingInfo<Date> ENDPOINTCREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointCreateTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> ENDPOINTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointName").build();
    private static final MarshallingInfo<String> ENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointStatus").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("port").build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetIds").build();
    private static final MarshallingInfo<StructuredPojo> VPCENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcEndpoint").build();
    private static final MarshallingInfo<List> VPCSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcSecurityGroups").build();
    private static final MarshallingInfo<String> WORKGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workgroupName").build();
    private static final EndpointAccessMarshaller instance = new EndpointAccessMarshaller();

    public static EndpointAccessMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointAccess endpointAccess, ProtocolMarshaller protocolMarshaller) {
        if (endpointAccess == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointAccess.getAddress(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getEndpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getEndpointCreateTime(), ENDPOINTCREATETIME_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getEndpointName(), ENDPOINTNAME_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getEndpointStatus(), ENDPOINTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getPort(), PORT_BINDING);
            protocolMarshaller.marshall(endpointAccess.getSubnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getVpcEndpoint(), VPCENDPOINT_BINDING);
            protocolMarshaller.marshall(endpointAccess.getVpcSecurityGroups(), VPCSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)endpointAccess.getWorkgroupName(), WORKGROUPNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

