/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Asset;
import com.amazonaws.services.rekognition.model.transform.ValidationDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidationData
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Asset> assets;

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(Collection<Asset> assets) {
        if (assets == null) {
            this.assets = null;
            return;
        }
        this.assets = new ArrayList<Asset>(assets);
    }

    public ValidationData withAssets(Asset ... assets) {
        if (this.assets == null) {
            this.setAssets(new ArrayList<Asset>(assets.length));
        }
        for (Asset ele : assets) {
            this.assets.add(ele);
        }
        return this;
    }

    public ValidationData withAssets(Collection<Asset> assets) {
        this.setAssets(assets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssets() != null) {
            sb.append("Assets: ").append(this.getAssets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationData)) {
            return false;
        }
        ValidationData other = (ValidationData)obj;
        if (other.getAssets() == null ^ this.getAssets() == null) {
            return false;
        }
        return other.getAssets() == null || other.getAssets().equals(this.getAssets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssets() == null ? 0 : this.getAssets().hashCode());
        return hashCode;
    }

    public ValidationData clone() {
        try {
            return (ValidationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

