/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.AudioMetadata;
import com.amazonaws.services.rekognition.model.SegmentDetection;
import com.amazonaws.services.rekognition.model.SegmentTypeInfo;
import com.amazonaws.services.rekognition.model.VideoJobStatus;
import com.amazonaws.services.rekognition.model.VideoMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetSegmentDetectionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobStatus;
    private String statusMessage;
    private List<VideoMetadata> videoMetadata;
    private List<AudioMetadata> audioMetadata;
    private String nextToken;
    private List<SegmentDetection> segments;
    private List<SegmentTypeInfo> selectedSegmentTypes;

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetSegmentDetectionResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetSegmentDetectionResult withJobStatus(VideoJobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetSegmentDetectionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public List<VideoMetadata> getVideoMetadata() {
        return this.videoMetadata;
    }

    public void setVideoMetadata(Collection<VideoMetadata> videoMetadata) {
        if (videoMetadata == null) {
            this.videoMetadata = null;
            return;
        }
        this.videoMetadata = new ArrayList<VideoMetadata>(videoMetadata);
    }

    public GetSegmentDetectionResult withVideoMetadata(VideoMetadata ... videoMetadata) {
        if (this.videoMetadata == null) {
            this.setVideoMetadata(new ArrayList<VideoMetadata>(videoMetadata.length));
        }
        for (VideoMetadata ele : videoMetadata) {
            this.videoMetadata.add(ele);
        }
        return this;
    }

    public GetSegmentDetectionResult withVideoMetadata(Collection<VideoMetadata> videoMetadata) {
        this.setVideoMetadata(videoMetadata);
        return this;
    }

    public List<AudioMetadata> getAudioMetadata() {
        return this.audioMetadata;
    }

    public void setAudioMetadata(Collection<AudioMetadata> audioMetadata) {
        if (audioMetadata == null) {
            this.audioMetadata = null;
            return;
        }
        this.audioMetadata = new ArrayList<AudioMetadata>(audioMetadata);
    }

    public GetSegmentDetectionResult withAudioMetadata(AudioMetadata ... audioMetadata) {
        if (this.audioMetadata == null) {
            this.setAudioMetadata(new ArrayList<AudioMetadata>(audioMetadata.length));
        }
        for (AudioMetadata ele : audioMetadata) {
            this.audioMetadata.add(ele);
        }
        return this;
    }

    public GetSegmentDetectionResult withAudioMetadata(Collection<AudioMetadata> audioMetadata) {
        this.setAudioMetadata(audioMetadata);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetSegmentDetectionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SegmentDetection> getSegments() {
        return this.segments;
    }

    public void setSegments(Collection<SegmentDetection> segments) {
        if (segments == null) {
            this.segments = null;
            return;
        }
        this.segments = new ArrayList<SegmentDetection>(segments);
    }

    public GetSegmentDetectionResult withSegments(SegmentDetection ... segments) {
        if (this.segments == null) {
            this.setSegments(new ArrayList<SegmentDetection>(segments.length));
        }
        for (SegmentDetection ele : segments) {
            this.segments.add(ele);
        }
        return this;
    }

    public GetSegmentDetectionResult withSegments(Collection<SegmentDetection> segments) {
        this.setSegments(segments);
        return this;
    }

    public List<SegmentTypeInfo> getSelectedSegmentTypes() {
        return this.selectedSegmentTypes;
    }

    public void setSelectedSegmentTypes(Collection<SegmentTypeInfo> selectedSegmentTypes) {
        if (selectedSegmentTypes == null) {
            this.selectedSegmentTypes = null;
            return;
        }
        this.selectedSegmentTypes = new ArrayList<SegmentTypeInfo>(selectedSegmentTypes);
    }

    public GetSegmentDetectionResult withSelectedSegmentTypes(SegmentTypeInfo ... selectedSegmentTypes) {
        if (this.selectedSegmentTypes == null) {
            this.setSelectedSegmentTypes(new ArrayList<SegmentTypeInfo>(selectedSegmentTypes.length));
        }
        for (SegmentTypeInfo ele : selectedSegmentTypes) {
            this.selectedSegmentTypes.add(ele);
        }
        return this;
    }

    public GetSegmentDetectionResult withSelectedSegmentTypes(Collection<SegmentTypeInfo> selectedSegmentTypes) {
        this.setSelectedSegmentTypes(selectedSegmentTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getVideoMetadata() != null) {
            sb.append("VideoMetadata: ").append(this.getVideoMetadata()).append(",");
        }
        if (this.getAudioMetadata() != null) {
            sb.append("AudioMetadata: ").append(this.getAudioMetadata()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSegments() != null) {
            sb.append("Segments: ").append(this.getSegments()).append(",");
        }
        if (this.getSelectedSegmentTypes() != null) {
            sb.append("SelectedSegmentTypes: ").append(this.getSelectedSegmentTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentDetectionResult)) {
            return false;
        }
        GetSegmentDetectionResult other = (GetSegmentDetectionResult)obj;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getVideoMetadata() == null ^ this.getVideoMetadata() == null) {
            return false;
        }
        if (other.getVideoMetadata() != null && !other.getVideoMetadata().equals(this.getVideoMetadata())) {
            return false;
        }
        if (other.getAudioMetadata() == null ^ this.getAudioMetadata() == null) {
            return false;
        }
        if (other.getAudioMetadata() != null && !other.getAudioMetadata().equals(this.getAudioMetadata())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSegments() == null ^ this.getSegments() == null) {
            return false;
        }
        if (other.getSegments() != null && !other.getSegments().equals(this.getSegments())) {
            return false;
        }
        if (other.getSelectedSegmentTypes() == null ^ this.getSelectedSegmentTypes() == null) {
            return false;
        }
        return other.getSelectedSegmentTypes() == null || other.getSelectedSegmentTypes().equals(this.getSelectedSegmentTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVideoMetadata() == null ? 0 : this.getVideoMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getAudioMetadata() == null ? 0 : this.getAudioMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSegments() == null ? 0 : this.getSegments().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedSegmentTypes() == null ? 0 : this.getSelectedSegmentTypes().hashCode());
        return hashCode;
    }

    public GetSegmentDetectionResult clone() {
        try {
            return (GetSegmentDetectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

