/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.BodyPart;
import com.amazonaws.services.rekognition.model.EquipmentDetection;
import com.amazonaws.services.rekognition.model.transform.ProtectiveEquipmentBodyPartMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProtectiveEquipmentBodyPart
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Float confidence;
    private List<EquipmentDetection> equipmentDetections;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ProtectiveEquipmentBodyPart withName(String name) {
        this.setName(name);
        return this;
    }

    public ProtectiveEquipmentBodyPart withName(BodyPart name) {
        this.name = name.toString();
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public ProtectiveEquipmentBodyPart withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public List<EquipmentDetection> getEquipmentDetections() {
        return this.equipmentDetections;
    }

    public void setEquipmentDetections(Collection<EquipmentDetection> equipmentDetections) {
        if (equipmentDetections == null) {
            this.equipmentDetections = null;
            return;
        }
        this.equipmentDetections = new ArrayList<EquipmentDetection>(equipmentDetections);
    }

    public ProtectiveEquipmentBodyPart withEquipmentDetections(EquipmentDetection ... equipmentDetections) {
        if (this.equipmentDetections == null) {
            this.setEquipmentDetections(new ArrayList<EquipmentDetection>(equipmentDetections.length));
        }
        for (EquipmentDetection ele : equipmentDetections) {
            this.equipmentDetections.add(ele);
        }
        return this;
    }

    public ProtectiveEquipmentBodyPart withEquipmentDetections(Collection<EquipmentDetection> equipmentDetections) {
        this.setEquipmentDetections(equipmentDetections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getEquipmentDetections() != null) {
            sb.append("EquipmentDetections: ").append(this.getEquipmentDetections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentBodyPart)) {
            return false;
        }
        ProtectiveEquipmentBodyPart other = (ProtectiveEquipmentBodyPart)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getEquipmentDetections() == null ^ this.getEquipmentDetections() == null) {
            return false;
        }
        return other.getEquipmentDetections() == null || other.getEquipmentDetections().equals(this.getEquipmentDetections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getEquipmentDetections() == null ? 0 : this.getEquipmentDetections().hashCode());
        return hashCode;
    }

    public ProtectiveEquipmentBodyPart clone() {
        try {
            return (ProtectiveEquipmentBodyPart)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProtectiveEquipmentBodyPartMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

