/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourceexplorer2.model.Resource;
import com.amazonaws.services.resourceexplorer2.model.ResourceCount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private ResourceCount count;
    private String nextToken;
    private List<Resource> resources;
    private String viewArn;

    public void setCount(ResourceCount count) {
        this.count = count;
    }

    public ResourceCount getCount() {
        return this.count;
    }

    public SearchResult withCount(ResourceCount count) {
        this.setCount(count);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public SearchResult withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public SearchResult withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public void setViewArn(String viewArn) {
        this.viewArn = viewArn;
    }

    public String getViewArn() {
        return this.viewArn;
    }

    public SearchResult withViewArn(String viewArn) {
        this.setViewArn(viewArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getViewArn() != null) {
            sb.append("ViewArn: ").append(this.getViewArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getViewArn() == null ^ this.getViewArn() == null) {
            return false;
        }
        return other.getViewArn() == null || other.getViewArn().equals(this.getViewArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getViewArn() == null ? 0 : this.getViewArn().hashCode());
        return hashCode;
    }

    public SearchResult clone() {
        try {
            return (SearchResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

