/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.services.route53.model.ChangeAction;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.io.Serializable;

public class Change
implements Serializable,
Cloneable {
    private String action;
    private ResourceRecordSet resourceRecordSet;

    public Change() {
    }

    public Change(String action, ResourceRecordSet resourceRecordSet) {
        this.setAction(action);
        this.setResourceRecordSet(resourceRecordSet);
    }

    public Change(ChangeAction action, ResourceRecordSet resourceRecordSet) {
        this.setAction(action.toString());
        this.setResourceRecordSet(resourceRecordSet);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public Change withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setAction(ChangeAction action) {
        this.withAction(action);
    }

    public Change withAction(ChangeAction action) {
        this.action = action.toString();
        return this;
    }

    public void setResourceRecordSet(ResourceRecordSet resourceRecordSet) {
        this.resourceRecordSet = resourceRecordSet;
    }

    public ResourceRecordSet getResourceRecordSet() {
        return this.resourceRecordSet;
    }

    public Change withResourceRecordSet(ResourceRecordSet resourceRecordSet) {
        this.setResourceRecordSet(resourceRecordSet);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getResourceRecordSet() != null) {
            sb.append("ResourceRecordSet: ").append(this.getResourceRecordSet());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getResourceRecordSet() == null ^ this.getResourceRecordSet() == null) {
            return false;
        }
        return other.getResourceRecordSet() == null || other.getResourceRecordSet().equals(this.getResourceRecordSet());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRecordSet() == null ? 0 : this.getResourceRecordSet().hashCode());
        return hashCode;
    }

    public Change clone() {
        try {
            return (Change)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

