/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.s3control.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * A container for filter information that you can use to select S3 objects that are encrypted with Key Management
 * Service (KMS).
 * </p>
 * <note>
 * <p>
 * This is not supported by Amazon S3 on Outposts buckets.
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/SseKmsEncryptedObjects" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SseKmsEncryptedObjects implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key
     * stored in Key Management Service.
     * </p>
     */
    private String status;

    /**
     * <p>
     * Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key
     * stored in Key Management Service.
     * </p>
     * 
     * @param status
     *        Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an
     *        KMS key stored in Key Management Service.
     * @see SseKmsEncryptedObjectsStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key
     * stored in Key Management Service.
     * </p>
     * 
     * @return Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an
     *         KMS key stored in Key Management Service.
     * @see SseKmsEncryptedObjectsStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key
     * stored in Key Management Service.
     * </p>
     * 
     * @param status
     *        Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an
     *        KMS key stored in Key Management Service.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SseKmsEncryptedObjectsStatus
     */

    public SseKmsEncryptedObjects withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key
     * stored in Key Management Service.
     * </p>
     * 
     * @param status
     *        Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an
     *        KMS key stored in Key Management Service.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SseKmsEncryptedObjectsStatus
     */

    public SseKmsEncryptedObjects withStatus(SseKmsEncryptedObjectsStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SseKmsEncryptedObjects == false)
            return false;
        SseKmsEncryptedObjects other = (SseKmsEncryptedObjects) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public SseKmsEncryptedObjects clone() {
        try {
            return (SseKmsEncryptedObjects) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
