/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakeredgemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemakeredgemanager.model.EdgeMetric;
import com.amazonaws.services.sagemakeredgemanager.model.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendHeartbeatRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<EdgeMetric> agentMetrics;
    private List<Model> models;
    private String agentVersion;
    private String deviceName;
    private String deviceFleetName;

    public List<EdgeMetric> getAgentMetrics() {
        return this.agentMetrics;
    }

    public void setAgentMetrics(Collection<EdgeMetric> agentMetrics) {
        if (agentMetrics == null) {
            this.agentMetrics = null;
            return;
        }
        this.agentMetrics = new ArrayList<EdgeMetric>(agentMetrics);
    }

    public SendHeartbeatRequest withAgentMetrics(EdgeMetric ... agentMetrics) {
        if (this.agentMetrics == null) {
            this.setAgentMetrics(new ArrayList<EdgeMetric>(agentMetrics.length));
        }
        for (EdgeMetric ele : agentMetrics) {
            this.agentMetrics.add(ele);
        }
        return this;
    }

    public SendHeartbeatRequest withAgentMetrics(Collection<EdgeMetric> agentMetrics) {
        this.setAgentMetrics(agentMetrics);
        return this;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public void setModels(Collection<Model> models) {
        if (models == null) {
            this.models = null;
            return;
        }
        this.models = new ArrayList<Model>(models);
    }

    public SendHeartbeatRequest withModels(Model ... models) {
        if (this.models == null) {
            this.setModels(new ArrayList<Model>(models.length));
        }
        for (Model ele : models) {
            this.models.add(ele);
        }
        return this;
    }

    public SendHeartbeatRequest withModels(Collection<Model> models) {
        this.setModels(models);
        return this;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public SendHeartbeatRequest withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public SendHeartbeatRequest withDeviceName(String deviceName) {
        this.setDeviceName(deviceName);
        return this;
    }

    public void setDeviceFleetName(String deviceFleetName) {
        this.deviceFleetName = deviceFleetName;
    }

    public String getDeviceFleetName() {
        return this.deviceFleetName;
    }

    public SendHeartbeatRequest withDeviceFleetName(String deviceFleetName) {
        this.setDeviceFleetName(deviceFleetName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentMetrics() != null) {
            sb.append("AgentMetrics: ").append(this.getAgentMetrics()).append(",");
        }
        if (this.getModels() != null) {
            sb.append("Models: ").append(this.getModels()).append(",");
        }
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion()).append(",");
        }
        if (this.getDeviceName() != null) {
            sb.append("DeviceName: ").append(this.getDeviceName()).append(",");
        }
        if (this.getDeviceFleetName() != null) {
            sb.append("DeviceFleetName: ").append(this.getDeviceFleetName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendHeartbeatRequest)) {
            return false;
        }
        SendHeartbeatRequest other = (SendHeartbeatRequest)obj;
        if (other.getAgentMetrics() == null ^ this.getAgentMetrics() == null) {
            return false;
        }
        if (other.getAgentMetrics() != null && !other.getAgentMetrics().equals(this.getAgentMetrics())) {
            return false;
        }
        if (other.getModels() == null ^ this.getModels() == null) {
            return false;
        }
        if (other.getModels() != null && !other.getModels().equals(this.getModels())) {
            return false;
        }
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        if (other.getAgentVersion() != null && !other.getAgentVersion().equals(this.getAgentVersion())) {
            return false;
        }
        if (other.getDeviceName() == null ^ this.getDeviceName() == null) {
            return false;
        }
        if (other.getDeviceName() != null && !other.getDeviceName().equals(this.getDeviceName())) {
            return false;
        }
        if (other.getDeviceFleetName() == null ^ this.getDeviceFleetName() == null) {
            return false;
        }
        return other.getDeviceFleetName() == null || other.getDeviceFleetName().equals(this.getDeviceFleetName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentMetrics() == null ? 0 : this.getAgentMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getModels() == null ? 0 : this.getModels().hashCode());
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceName() == null ? 0 : this.getDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceFleetName() == null ? 0 : this.getDeviceFleetName().hashCode());
        return hashCode;
    }

    public SendHeartbeatRequest clone() {
        return (SendHeartbeatRequest)super.clone();
    }
}

