/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.Region;
import com.amazonaws.services.securitylake.model.RetentionSetting;
import com.amazonaws.services.securitylake.model.transform.LakeConfigurationRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LakeConfigurationRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionKey;
    private List<String> replicationDestinationRegions;
    private String replicationRoleArn;
    private List<RetentionSetting> retentionSettings;
    private Map<String, String> tagsMap;

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public LakeConfigurationRequest withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<String> getReplicationDestinationRegions() {
        return this.replicationDestinationRegions;
    }

    public void setReplicationDestinationRegions(Collection<String> replicationDestinationRegions) {
        if (replicationDestinationRegions == null) {
            this.replicationDestinationRegions = null;
            return;
        }
        this.replicationDestinationRegions = new ArrayList<String>(replicationDestinationRegions);
    }

    public LakeConfigurationRequest withReplicationDestinationRegions(String ... replicationDestinationRegions) {
        if (this.replicationDestinationRegions == null) {
            this.setReplicationDestinationRegions(new ArrayList<String>(replicationDestinationRegions.length));
        }
        for (String ele : replicationDestinationRegions) {
            this.replicationDestinationRegions.add(ele);
        }
        return this;
    }

    public LakeConfigurationRequest withReplicationDestinationRegions(Collection<String> replicationDestinationRegions) {
        this.setReplicationDestinationRegions(replicationDestinationRegions);
        return this;
    }

    public LakeConfigurationRequest withReplicationDestinationRegions(Region ... replicationDestinationRegions) {
        ArrayList<String> replicationDestinationRegionsCopy = new ArrayList<String>(replicationDestinationRegions.length);
        for (Region value : replicationDestinationRegions) {
            replicationDestinationRegionsCopy.add(value.toString());
        }
        if (this.getReplicationDestinationRegions() == null) {
            this.setReplicationDestinationRegions(replicationDestinationRegionsCopy);
        } else {
            this.getReplicationDestinationRegions().addAll(replicationDestinationRegionsCopy);
        }
        return this;
    }

    public void setReplicationRoleArn(String replicationRoleArn) {
        this.replicationRoleArn = replicationRoleArn;
    }

    public String getReplicationRoleArn() {
        return this.replicationRoleArn;
    }

    public LakeConfigurationRequest withReplicationRoleArn(String replicationRoleArn) {
        this.setReplicationRoleArn(replicationRoleArn);
        return this;
    }

    public List<RetentionSetting> getRetentionSettings() {
        return this.retentionSettings;
    }

    public void setRetentionSettings(Collection<RetentionSetting> retentionSettings) {
        if (retentionSettings == null) {
            this.retentionSettings = null;
            return;
        }
        this.retentionSettings = new ArrayList<RetentionSetting>(retentionSettings);
    }

    public LakeConfigurationRequest withRetentionSettings(RetentionSetting ... retentionSettings) {
        if (this.retentionSettings == null) {
            this.setRetentionSettings(new ArrayList<RetentionSetting>(retentionSettings.length));
        }
        for (RetentionSetting ele : retentionSettings) {
            this.retentionSettings.add(ele);
        }
        return this;
    }

    public LakeConfigurationRequest withRetentionSettings(Collection<RetentionSetting> retentionSettings) {
        this.setRetentionSettings(retentionSettings);
        return this;
    }

    public Map<String, String> getTagsMap() {
        return this.tagsMap;
    }

    public void setTagsMap(Map<String, String> tagsMap) {
        this.tagsMap = tagsMap;
    }

    public LakeConfigurationRequest withTagsMap(Map<String, String> tagsMap) {
        this.setTagsMap(tagsMap);
        return this;
    }

    public LakeConfigurationRequest addTagsMapEntry(String key, String value) {
        if (null == this.tagsMap) {
            this.tagsMap = new HashMap<String, String>();
        }
        if (this.tagsMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tagsMap.put(key, value);
        return this;
    }

    public LakeConfigurationRequest clearTagsMapEntries() {
        this.tagsMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getReplicationDestinationRegions() != null) {
            sb.append("ReplicationDestinationRegions: ").append(this.getReplicationDestinationRegions()).append(",");
        }
        if (this.getReplicationRoleArn() != null) {
            sb.append("ReplicationRoleArn: ").append(this.getReplicationRoleArn()).append(",");
        }
        if (this.getRetentionSettings() != null) {
            sb.append("RetentionSettings: ").append(this.getRetentionSettings()).append(",");
        }
        if (this.getTagsMap() != null) {
            sb.append("TagsMap: ").append(this.getTagsMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeConfigurationRequest)) {
            return false;
        }
        LakeConfigurationRequest other = (LakeConfigurationRequest)obj;
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getReplicationDestinationRegions() == null ^ this.getReplicationDestinationRegions() == null) {
            return false;
        }
        if (other.getReplicationDestinationRegions() != null && !other.getReplicationDestinationRegions().equals(this.getReplicationDestinationRegions())) {
            return false;
        }
        if (other.getReplicationRoleArn() == null ^ this.getReplicationRoleArn() == null) {
            return false;
        }
        if (other.getReplicationRoleArn() != null && !other.getReplicationRoleArn().equals(this.getReplicationRoleArn())) {
            return false;
        }
        if (other.getRetentionSettings() == null ^ this.getRetentionSettings() == null) {
            return false;
        }
        if (other.getRetentionSettings() != null && !other.getRetentionSettings().equals(this.getRetentionSettings())) {
            return false;
        }
        if (other.getTagsMap() == null ^ this.getTagsMap() == null) {
            return false;
        }
        return other.getTagsMap() == null || other.getTagsMap().equals(this.getTagsMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationDestinationRegions() == null ? 0 : this.getReplicationDestinationRegions().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationRoleArn() == null ? 0 : this.getReplicationRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionSettings() == null ? 0 : this.getRetentionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getTagsMap() == null ? 0 : this.getTagsMap().hashCode());
        return hashCode;
    }

    public LakeConfigurationRequest clone() {
        try {
            return (LakeConfigurationRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LakeConfigurationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

