/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.TerminateProvisionedProductRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TerminateProvisionedProductRequestMarshaller
implements Marshaller<Request<TerminateProvisionedProductRequest>, TerminateProvisionedProductRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TerminateProvisionedProductRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TerminateProvisionedProductRequest> marshall(TerminateProvisionedProductRequest terminateProvisionedProductRequest) {
        if (terminateProvisionedProductRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateProvisionedProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.TerminateProvisionedProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (terminateProvisionedProductRequest.getProvisionedProductName() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductName").writeValue(terminateProvisionedProductRequest.getProvisionedProductName());
            }
            if (terminateProvisionedProductRequest.getProvisionedProductId() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductId").writeValue(terminateProvisionedProductRequest.getProvisionedProductId());
            }
            jsonGenerator.writeFieldName("TerminateToken").writeValue(IdempotentUtils.resolveString((String)terminateProvisionedProductRequest.getTerminateToken()));
            if (terminateProvisionedProductRequest.getIgnoreErrors() != null) {
                jsonGenerator.writeFieldName("IgnoreErrors").writeValue(terminateProvisionedProductRequest.getIgnoreErrors().booleanValue());
            }
            if (terminateProvisionedProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(terminateProvisionedProductRequest.getAcceptLanguage());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

