/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.BouncedRecipientInfo;
import com.amazonaws.services.simpleemail.model.ExtensionField;
import com.amazonaws.services.simpleemail.model.MessageDsn;
import com.amazonaws.services.simpleemail.model.RecipientDsnFields;
import com.amazonaws.services.simpleemail.model.SendBounceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class SendBounceRequestMarshaller
implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {
    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {
        SdkInternalList bouncedRecipientInfoListList;
        MessageDsn messageDsn;
        if (sendBounceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendBounceRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBounceRequest.getOriginalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringUtils.fromString((String)sendBounceRequest.getOriginalMessageId()));
        }
        if (sendBounceRequest.getBounceSender() != null) {
            request.addParameter("BounceSender", StringUtils.fromString((String)sendBounceRequest.getBounceSender()));
        }
        if (sendBounceRequest.getExplanation() != null) {
            request.addParameter("Explanation", StringUtils.fromString((String)sendBounceRequest.getExplanation()));
        }
        if ((messageDsn = sendBounceRequest.getMessageDsn()) != null) {
            SdkInternalList extensionFieldsList;
            if (messageDsn.getReportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringUtils.fromString((String)messageDsn.getReportingMta()));
            }
            if (messageDsn.getArrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringUtils.fromDate((Date)messageDsn.getArrivalDate()));
            }
            if (!(extensionFieldsList = (SdkInternalList)messageDsn.getExtensionFields()).isEmpty() || !extensionFieldsList.isAutoConstruct()) {
                int extensionFieldsListIndex = 1;
                for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                    if (extensionFieldsListValue.getName() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldsListValue.getName()));
                    }
                    if (extensionFieldsListValue.getValue() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldsListValue.getValue()));
                    }
                    ++extensionFieldsListIndex;
                }
            }
        }
        if (!(bouncedRecipientInfoListList = (SdkInternalList)sendBounceRequest.getBouncedRecipientInfoList()).isEmpty() || !bouncedRecipientInfoListList.isAutoConstruct()) {
            int bouncedRecipientInfoListListIndex = 1;
            for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {
                RecipientDsnFields recipientDsnFields;
                if (bouncedRecipientInfoListListValue.getRecipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient", StringUtils.fromString((String)bouncedRecipientInfoListListValue.getRecipient()));
                }
                if (bouncedRecipientInfoListListValue.getRecipientArn() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn", StringUtils.fromString((String)bouncedRecipientInfoListListValue.getRecipientArn()));
                }
                if (bouncedRecipientInfoListListValue.getBounceType() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType", StringUtils.fromString((String)bouncedRecipientInfoListListValue.getBounceType()));
                }
                if ((recipientDsnFields = bouncedRecipientInfoListListValue.getRecipientDsnFields()) != null) {
                    SdkInternalList extensionFieldsList;
                    if (recipientDsnFields.getFinalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.FinalRecipient", StringUtils.fromString((String)recipientDsnFields.getFinalRecipient()));
                    }
                    if (recipientDsnFields.getAction() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Action", StringUtils.fromString((String)recipientDsnFields.getAction()));
                    }
                    if (recipientDsnFields.getRemoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.RemoteMta", StringUtils.fromString((String)recipientDsnFields.getRemoteMta()));
                    }
                    if (recipientDsnFields.getStatus() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Status", StringUtils.fromString((String)recipientDsnFields.getStatus()));
                    }
                    if (recipientDsnFields.getDiagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.DiagnosticCode", StringUtils.fromString((String)recipientDsnFields.getDiagnosticCode()));
                    }
                    if (recipientDsnFields.getLastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.LastAttemptDate", StringUtils.fromDate((Date)recipientDsnFields.getLastAttemptDate()));
                    }
                    if (!(extensionFieldsList = (SdkInternalList)recipientDsnFields.getExtensionFields()).isEmpty() || !extensionFieldsList.isAutoConstruct()) {
                        int extensionFieldsListIndex = 1;
                        for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                            if (extensionFieldsListValue.getName() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldsListValue.getName()));
                            }
                            if (extensionFieldsListValue.getValue() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldsListValue.getValue()));
                            }
                            ++extensionFieldsListIndex;
                        }
                    }
                }
                ++bouncedRecipientInfoListListIndex;
            }
        }
        if (sendBounceRequest.getBounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringUtils.fromString((String)sendBounceRequest.getBounceSenderArn()));
        }
        return request;
    }
}

