/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowball.model.ClusterMetadata;
import java.util.Date;

@SdkInternalApi
public class ClusterMetadataMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<String> CLUSTERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterState").build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").build();
    private static final ClusterMetadataMarshaller instance = new ClusterMetadataMarshaller();

    public static ClusterMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterMetadata clusterMetadata, ProtocolMarshaller protocolMarshaller) {
        if (clusterMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterMetadata.getClusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getKmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getRoleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getClusterState(), CLUSTERSTATE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getJobType(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getSnowballType(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getAddressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getShippingOption(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getNotification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.getForwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

