/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)sendMessageRequest.getQueueUrl()));
        }
        if (sendMessageRequest.getMessageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString((String)sendMessageRequest.getMessageBody()));
        }
        if (sendMessageRequest.getDelaySeconds() != null) {
            request.addParameter("DelaySeconds", StringUtils.fromInteger((Integer)sendMessageRequest.getDelaySeconds()));
        }
        Map<String, MessageAttributeValue> messageAttributes = sendMessageRequest.getMessageAttributes();
        int messageAttributesListIndex = 1;
        for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                SdkInternalList binaryListValuesList;
                SdkInternalList stringListValuesList;
                if (entry.getValue().getStringValue() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().getStringValue()));
                }
                if (entry.getValue().getBinaryValue() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().getBinaryValue()));
                }
                if (!(stringListValuesList = (SdkInternalList)entry.getValue().getStringListValues()).isEmpty() || !stringListValuesList.isAutoConstruct()) {
                    int stringListValuesListIndex = 1;
                    for (String stringListValuesListValue : stringListValuesList) {
                        if (stringListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString((String)stringListValuesListValue));
                        }
                        ++stringListValuesListIndex;
                    }
                }
                if (!(binaryListValuesList = (SdkInternalList)entry.getValue().getBinaryListValues()).isEmpty() || !binaryListValuesList.isAutoConstruct()) {
                    int binaryListValuesListIndex = 1;
                    for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                        if (binaryListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesListValue));
                        }
                        ++binaryListValuesListIndex;
                    }
                }
                if (entry.getValue().getDataType() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().getDataType()));
                }
            }
            ++messageAttributesListIndex;
        }
        return request;
    }
}

