/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement;

import javax.annotation.Generated;

import com.amazonaws.services.simplesystemsmanagement.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSSimpleSystemsManagement}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSimpleSystemsManagement implements AWSSimpleSystemsManagement {

    protected AbstractAWSSimpleSystemsManagement() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTagsToResourceResult addTagsToResource(AddTagsToResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelCommandResult cancelCommand(CancelCommandRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateActivationResult createActivation(CreateActivationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssociationResult createAssociation(CreateAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssociationBatchResult createAssociationBatch(CreateAssociationBatchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDocumentResult createDocument(CreateDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMaintenanceWindowResult createMaintenanceWindow(CreateMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePatchBaselineResult createPatchBaseline(CreatePatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourceDataSyncResult createResourceDataSync(CreateResourceDataSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteActivationResult deleteActivation(DeleteActivationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssociationResult deleteAssociation(DeleteAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInventoryResult deleteInventory(DeleteInventoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMaintenanceWindowResult deleteMaintenanceWindow(DeleteMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteParameterResult deleteParameter(DeleteParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteParametersResult deleteParameters(DeleteParametersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePatchBaselineResult deletePatchBaseline(DeletePatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourceDataSyncResult deleteResourceDataSync(DeleteResourceDataSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterManagedInstanceResult deregisterManagedInstance(DeregisterManagedInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterPatchBaselineForPatchGroupResult deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTargetFromMaintenanceWindowResult deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTaskFromMaintenanceWindowResult deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeActivationsResult describeActivations(DescribeActivationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssociationResult describeAssociation(DescribeAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssociationExecutionTargetsResult describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssociationExecutionsResult describeAssociationExecutions(DescribeAssociationExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutomationExecutionsResult describeAutomationExecutions(DescribeAutomationExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutomationStepExecutionsResult describeAutomationStepExecutions(DescribeAutomationStepExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAvailablePatchesResult describeAvailablePatches(DescribeAvailablePatchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentResult describeDocument(DescribeDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentPermissionResult describeDocumentPermission(DescribeDocumentPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEffectiveInstanceAssociationsResult describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEffectivePatchesForPatchBaselineResult describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceAssociationsStatusResult describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceInformationResult describeInstanceInformation(DescribeInstanceInformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstancePatchStatesResult describeInstancePatchStates(DescribeInstancePatchStatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstancePatchStatesForPatchGroupResult describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstancePatchesResult describeInstancePatches(DescribeInstancePatchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInventoryDeletionsResult describeInventoryDeletions(DescribeInventoryDeletionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowExecutionTaskInvocationsResult describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowExecutionTasksResult describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowExecutionsResult describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowTargetsResult describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowTasksResult describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceWindowsResult describeMaintenanceWindows(DescribeMaintenanceWindowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeParametersResult describeParameters(DescribeParametersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePatchBaselinesResult describePatchBaselines(DescribePatchBaselinesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePatchGroupStateResult describePatchGroupState(DescribePatchGroupStateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePatchGroupsResult describePatchGroups(DescribePatchGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAutomationExecutionResult getAutomationExecution(GetAutomationExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCommandInvocationResult getCommandInvocation(GetCommandInvocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDefaultPatchBaselineResult getDefaultPatchBaseline(GetDefaultPatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeployablePatchSnapshotForInstanceResult getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDocumentResult getDocument(GetDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInventoryResult getInventory(GetInventoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInventorySchemaResult getInventorySchema(GetInventorySchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMaintenanceWindowResult getMaintenanceWindow(GetMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMaintenanceWindowExecutionResult getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMaintenanceWindowExecutionTaskResult getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMaintenanceWindowExecutionTaskInvocationResult getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMaintenanceWindowTaskResult getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParameterResult getParameter(GetParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParameterHistoryResult getParameterHistory(GetParameterHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParametersResult getParameters(GetParametersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetParametersByPathResult getParametersByPath(GetParametersByPathRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPatchBaselineResult getPatchBaseline(GetPatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPatchBaselineForPatchGroupResult getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public LabelParameterVersionResult labelParameterVersion(LabelParameterVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociationVersionsResult listAssociationVersions(ListAssociationVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociationsResult listAssociations(ListAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCommandInvocationsResult listCommandInvocations(ListCommandInvocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCommandsResult listCommands(ListCommandsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComplianceItemsResult listComplianceItems(ListComplianceItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComplianceSummariesResult listComplianceSummaries(ListComplianceSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentVersionsResult listDocumentVersions(ListDocumentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentsResult listDocuments(ListDocumentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentsResult listDocuments() {
        return listDocuments(new ListDocumentsRequest());
    }

    @Override
    public ListInventoryEntriesResult listInventoryEntries(ListInventoryEntriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceComplianceSummariesResult listResourceComplianceSummaries(ListResourceComplianceSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceDataSyncResult listResourceDataSync(ListResourceDataSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ModifyDocumentPermissionResult modifyDocumentPermission(ModifyDocumentPermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutComplianceItemsResult putComplianceItems(PutComplianceItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutInventoryResult putInventory(PutInventoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutParameterResult putParameter(PutParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterDefaultPatchBaselineResult registerDefaultPatchBaseline(RegisterDefaultPatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterPatchBaselineForPatchGroupResult registerPatchBaselineForPatchGroup(RegisterPatchBaselineForPatchGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTargetWithMaintenanceWindowResult registerTargetWithMaintenanceWindow(RegisterTargetWithMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTaskWithMaintenanceWindowResult registerTaskWithMaintenanceWindow(RegisterTaskWithMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource(RemoveTagsFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendAutomationSignalResult sendAutomationSignal(SendAutomationSignalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendCommandResult sendCommand(SendCommandRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAssociationsOnceResult startAssociationsOnce(StartAssociationsOnceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAutomationExecutionResult startAutomationExecution(StartAutomationExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopAutomationExecutionResult stopAutomationExecution(StopAutomationExecutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssociationResult updateAssociation(UpdateAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssociationStatusResult updateAssociationStatus(UpdateAssociationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDocumentResult updateDocument(UpdateDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDocumentDefaultVersionResult updateDocumentDefaultVersion(UpdateDocumentDefaultVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMaintenanceWindowResult updateMaintenanceWindow(UpdateMaintenanceWindowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMaintenanceWindowTargetResult updateMaintenanceWindowTarget(UpdateMaintenanceWindowTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMaintenanceWindowTaskResult updateMaintenanceWindowTask(UpdateMaintenanceWindowTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateManagedInstanceRoleResult updateManagedInstanceRole(UpdateManagedInstanceRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePatchBaselineResult updatePatchBaseline(UpdatePatchBaselineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
