/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.ssmincidents.AWSSSMIncidents;
import com.amazonaws.services.ssmincidents.model.GetReplicationSetRequest;
import com.amazonaws.services.ssmincidents.waiters.GetReplicationSetFunction;
import com.amazonaws.services.ssmincidents.waiters.WaitForReplicationSetActive;
import com.amazonaws.services.ssmincidents.waiters.WaitForReplicationSetDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSSSMIncidentsWaiters {
    private final AWSSSMIncidents client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSSSMIncidentsWaiters");

    @SdkInternalApi
    public AWSSSMIncidentsWaiters(AWSSSMIncidents client) {
        this.client = client;
    }

    public Waiter<GetReplicationSetRequest> waitForReplicationSetDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReplicationSetFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new WaitForReplicationSetDeleted.IsResourceNotFoundExceptionMatcher(), new WaitForReplicationSetDeleted.IsDELETINGMatcher(), new WaitForReplicationSetDeleted.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(5), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetReplicationSetRequest> waitForReplicationSetActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetReplicationSetFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new WaitForReplicationSetActive.IsACTIVEMatcher(), new WaitForReplicationSetActive.IsCREATINGMatcher(), new WaitForReplicationSetActive.IsUPDATINGMatcher(), new WaitForReplicationSetActive.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(5), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

