/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmincidents.model.transform.AttributeValueListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttributeValueList
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Integer> integerValues;
    private List<String> stringValues;

    public List<Integer> getIntegerValues() {
        return this.integerValues;
    }

    public void setIntegerValues(Collection<Integer> integerValues) {
        if (integerValues == null) {
            this.integerValues = null;
            return;
        }
        this.integerValues = new ArrayList<Integer>(integerValues);
    }

    public AttributeValueList withIntegerValues(Integer ... integerValues) {
        if (this.integerValues == null) {
            this.setIntegerValues(new ArrayList<Integer>(integerValues.length));
        }
        for (Integer ele : integerValues) {
            this.integerValues.add(ele);
        }
        return this;
    }

    public AttributeValueList withIntegerValues(Collection<Integer> integerValues) {
        this.setIntegerValues(integerValues);
        return this;
    }

    public List<String> getStringValues() {
        return this.stringValues;
    }

    public void setStringValues(Collection<String> stringValues) {
        if (stringValues == null) {
            this.stringValues = null;
            return;
        }
        this.stringValues = new ArrayList<String>(stringValues);
    }

    public AttributeValueList withStringValues(String ... stringValues) {
        if (this.stringValues == null) {
            this.setStringValues(new ArrayList<String>(stringValues.length));
        }
        for (String ele : stringValues) {
            this.stringValues.add(ele);
        }
        return this;
    }

    public AttributeValueList withStringValues(Collection<String> stringValues) {
        this.setStringValues(stringValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntegerValues() != null) {
            sb.append("IntegerValues: ").append(this.getIntegerValues()).append(",");
        }
        if (this.getStringValues() != null) {
            sb.append("StringValues: ").append(this.getStringValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueList)) {
            return false;
        }
        AttributeValueList other = (AttributeValueList)obj;
        if (other.getIntegerValues() == null ^ this.getIntegerValues() == null) {
            return false;
        }
        if (other.getIntegerValues() != null && !other.getIntegerValues().equals(this.getIntegerValues())) {
            return false;
        }
        if (other.getStringValues() == null ^ this.getStringValues() == null) {
            return false;
        }
        return other.getStringValues() == null || other.getStringValues().equals(this.getStringValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntegerValues() == null ? 0 : this.getIntegerValues().hashCode());
        hashCode = 31 * hashCode + (this.getStringValues() == null ? 0 : this.getStringValues().hashCode());
        return hashCode;
    }

    public AttributeValueList clone() {
        try {
            return (AttributeValueList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

