/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.textract.AmazonTextract;
import com.amazonaws.services.textract.AmazonTextractClientBuilder;
import com.amazonaws.services.textract.model.AmazonTextractException;
import com.amazonaws.services.textract.model.AnalyzeDocumentRequest;
import com.amazonaws.services.textract.model.AnalyzeDocumentResult;
import com.amazonaws.services.textract.model.AnalyzeExpenseRequest;
import com.amazonaws.services.textract.model.AnalyzeExpenseResult;
import com.amazonaws.services.textract.model.AnalyzeIDRequest;
import com.amazonaws.services.textract.model.AnalyzeIDResult;
import com.amazonaws.services.textract.model.CreateAdapterRequest;
import com.amazonaws.services.textract.model.CreateAdapterResult;
import com.amazonaws.services.textract.model.CreateAdapterVersionRequest;
import com.amazonaws.services.textract.model.CreateAdapterVersionResult;
import com.amazonaws.services.textract.model.DeleteAdapterRequest;
import com.amazonaws.services.textract.model.DeleteAdapterResult;
import com.amazonaws.services.textract.model.DeleteAdapterVersionRequest;
import com.amazonaws.services.textract.model.DeleteAdapterVersionResult;
import com.amazonaws.services.textract.model.DetectDocumentTextRequest;
import com.amazonaws.services.textract.model.DetectDocumentTextResult;
import com.amazonaws.services.textract.model.GetAdapterRequest;
import com.amazonaws.services.textract.model.GetAdapterResult;
import com.amazonaws.services.textract.model.GetAdapterVersionRequest;
import com.amazonaws.services.textract.model.GetAdapterVersionResult;
import com.amazonaws.services.textract.model.GetDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.GetDocumentAnalysisResult;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.GetExpenseAnalysisRequest;
import com.amazonaws.services.textract.model.GetExpenseAnalysisResult;
import com.amazonaws.services.textract.model.GetLendingAnalysisRequest;
import com.amazonaws.services.textract.model.GetLendingAnalysisResult;
import com.amazonaws.services.textract.model.GetLendingAnalysisSummaryRequest;
import com.amazonaws.services.textract.model.GetLendingAnalysisSummaryResult;
import com.amazonaws.services.textract.model.ListAdapterVersionsRequest;
import com.amazonaws.services.textract.model.ListAdapterVersionsResult;
import com.amazonaws.services.textract.model.ListAdaptersRequest;
import com.amazonaws.services.textract.model.ListAdaptersResult;
import com.amazonaws.services.textract.model.ListTagsForResourceRequest;
import com.amazonaws.services.textract.model.ListTagsForResourceResult;
import com.amazonaws.services.textract.model.StartDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.StartDocumentAnalysisResult;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.StartExpenseAnalysisRequest;
import com.amazonaws.services.textract.model.StartExpenseAnalysisResult;
import com.amazonaws.services.textract.model.StartLendingAnalysisRequest;
import com.amazonaws.services.textract.model.StartLendingAnalysisResult;
import com.amazonaws.services.textract.model.TagResourceRequest;
import com.amazonaws.services.textract.model.TagResourceResult;
import com.amazonaws.services.textract.model.UntagResourceRequest;
import com.amazonaws.services.textract.model.UntagResourceResult;
import com.amazonaws.services.textract.model.UpdateAdapterRequest;
import com.amazonaws.services.textract.model.UpdateAdapterResult;
import com.amazonaws.services.textract.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeDocumentRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeDocumentResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeExpenseRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeExpenseResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeIDRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.AnalyzeIDResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.BadDocumentExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.CreateAdapterRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.CreateAdapterResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.CreateAdapterVersionRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.CreateAdapterVersionResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.DeleteAdapterRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.DeleteAdapterResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.DeleteAdapterVersionRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.DeleteAdapterVersionResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.DetectDocumentTextRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.DetectDocumentTextResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.DocumentTooLargeExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetAdapterRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetAdapterResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetAdapterVersionRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetAdapterVersionResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetDocumentAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetDocumentAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetDocumentTextDetectionRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetDocumentTextDetectionResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetExpenseAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetExpenseAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetLendingAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetLendingAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.GetLendingAnalysisSummaryRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.GetLendingAnalysisSummaryResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.HumanLoopQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.IdempotentParameterMismatchExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.InvalidJobIdExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.InvalidKMSKeyExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.InvalidS3ObjectExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.ListAdapterVersionsRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.ListAdapterVersionsResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ListAdaptersRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.ListAdaptersResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ProvisionedThroughputExceededExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.StartDocumentAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.StartDocumentAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.StartDocumentTextDetectionRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.StartDocumentTextDetectionResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.StartExpenseAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.StartExpenseAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.StartLendingAnalysisRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.StartLendingAnalysisResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.UnsupportedDocumentExceptionUnmarshaller;
import com.amazonaws.services.textract.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.UpdateAdapterRequestProtocolMarshaller;
import com.amazonaws.services.textract.model.transform.UpdateAdapterResultJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTextractClient
extends AmazonWebServiceClient
implements AmazonTextract {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTextract.class);
    private static final String DEFAULT_SIGNING_NAME = "textract";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadDocumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadDocumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HumanLoopQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)HumanLoopQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DocumentTooLargeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DocumentTooLargeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedDocumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedDocumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3ObjectException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidS3ObjectExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidKMSKeyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidKMSKeyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withExceptionUnmarshaller((JsonErrorUnmarshaller)IdempotentParameterMismatchExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ProvisionedThroughputExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobIdException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidJobIdExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonTextractException.class));

    public static AmazonTextractClientBuilder builder() {
        return AmazonTextractClientBuilder.standard();
    }

    AmazonTextractClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonTextractClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("textract.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/textract/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/textract/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AnalyzeDocumentResult analyzeDocument(AnalyzeDocumentRequest request) {
        request = (AnalyzeDocumentRequest)this.beforeClientExecution(request);
        return this.executeAnalyzeDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AnalyzeDocumentResult executeAnalyzeDocument(AnalyzeDocumentRequest analyzeDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(analyzeDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AnalyzeDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AnalyzeDocumentRequestProtocolMarshaller(protocolFactory).marshall((AnalyzeDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)analyzeDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AnalyzeDocument");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AnalyzeDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AnalyzeDocumentResult analyzeDocumentResult = (AnalyzeDocumentResult)response.getAwsResponse();
            return analyzeDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AnalyzeExpenseResult analyzeExpense(AnalyzeExpenseRequest request) {
        request = (AnalyzeExpenseRequest)this.beforeClientExecution(request);
        return this.executeAnalyzeExpense(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AnalyzeExpenseResult executeAnalyzeExpense(AnalyzeExpenseRequest analyzeExpenseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(analyzeExpenseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AnalyzeExpenseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AnalyzeExpenseRequestProtocolMarshaller(protocolFactory).marshall((AnalyzeExpenseRequest)super.beforeMarshalling((AmazonWebServiceRequest)analyzeExpenseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AnalyzeExpense");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AnalyzeExpenseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AnalyzeExpenseResult analyzeExpenseResult = (AnalyzeExpenseResult)response.getAwsResponse();
            return analyzeExpenseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AnalyzeIDResult analyzeID(AnalyzeIDRequest request) {
        request = (AnalyzeIDRequest)this.beforeClientExecution(request);
        return this.executeAnalyzeID(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AnalyzeIDResult executeAnalyzeID(AnalyzeIDRequest analyzeIDRequest) {
        ExecutionContext executionContext = this.createExecutionContext(analyzeIDRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AnalyzeIDRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AnalyzeIDRequestProtocolMarshaller(protocolFactory).marshall((AnalyzeIDRequest)super.beforeMarshalling((AmazonWebServiceRequest)analyzeIDRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AnalyzeID");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AnalyzeIDResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AnalyzeIDResult analyzeIDResult = (AnalyzeIDResult)response.getAwsResponse();
            return analyzeIDResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAdapterResult createAdapter(CreateAdapterRequest request) {
        request = (CreateAdapterRequest)this.beforeClientExecution(request);
        return this.executeCreateAdapter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAdapterResult executeCreateAdapter(CreateAdapterRequest createAdapterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAdapterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAdapterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAdapterRequestProtocolMarshaller(protocolFactory).marshall((CreateAdapterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAdapterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAdapter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAdapterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAdapterResult createAdapterResult = (CreateAdapterResult)response.getAwsResponse();
            return createAdapterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAdapterVersionResult createAdapterVersion(CreateAdapterVersionRequest request) {
        request = (CreateAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executeCreateAdapterVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAdapterVersionResult executeCreateAdapterVersion(CreateAdapterVersionRequest createAdapterVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAdapterVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAdapterVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAdapterVersionRequestProtocolMarshaller(protocolFactory).marshall((CreateAdapterVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAdapterVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAdapterVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAdapterVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAdapterVersionResult createAdapterVersionResult = (CreateAdapterVersionResult)response.getAwsResponse();
            return createAdapterVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAdapterResult deleteAdapter(DeleteAdapterRequest request) {
        request = (DeleteAdapterRequest)this.beforeClientExecution(request);
        return this.executeDeleteAdapter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAdapterResult executeDeleteAdapter(DeleteAdapterRequest deleteAdapterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAdapterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAdapterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAdapterRequestProtocolMarshaller(protocolFactory).marshall((DeleteAdapterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAdapterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAdapter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAdapterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAdapterResult deleteAdapterResult = (DeleteAdapterResult)response.getAwsResponse();
            return deleteAdapterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAdapterVersionResult deleteAdapterVersion(DeleteAdapterVersionRequest request) {
        request = (DeleteAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executeDeleteAdapterVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAdapterVersionResult executeDeleteAdapterVersion(DeleteAdapterVersionRequest deleteAdapterVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAdapterVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAdapterVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAdapterVersionRequestProtocolMarshaller(protocolFactory).marshall((DeleteAdapterVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAdapterVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAdapterVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAdapterVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAdapterVersionResult deleteAdapterVersionResult = (DeleteAdapterVersionResult)response.getAwsResponse();
            return deleteAdapterVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectDocumentTextResult detectDocumentText(DetectDocumentTextRequest request) {
        request = (DetectDocumentTextRequest)this.beforeClientExecution(request);
        return this.executeDetectDocumentText(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectDocumentTextResult executeDetectDocumentText(DetectDocumentTextRequest detectDocumentTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectDocumentTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectDocumentTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectDocumentTextRequestProtocolMarshaller(protocolFactory).marshall((DetectDocumentTextRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectDocumentTextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectDocumentText");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectDocumentTextResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectDocumentTextResult detectDocumentTextResult = (DetectDocumentTextResult)response.getAwsResponse();
            return detectDocumentTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAdapterResult getAdapter(GetAdapterRequest request) {
        request = (GetAdapterRequest)this.beforeClientExecution(request);
        return this.executeGetAdapter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAdapterResult executeGetAdapter(GetAdapterRequest getAdapterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAdapterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAdapterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAdapterRequestProtocolMarshaller(protocolFactory).marshall((GetAdapterRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAdapterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAdapter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAdapterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAdapterResult getAdapterResult = (GetAdapterResult)response.getAwsResponse();
            return getAdapterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAdapterVersionResult getAdapterVersion(GetAdapterVersionRequest request) {
        request = (GetAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executeGetAdapterVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAdapterVersionResult executeGetAdapterVersion(GetAdapterVersionRequest getAdapterVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAdapterVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAdapterVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAdapterVersionRequestProtocolMarshaller(protocolFactory).marshall((GetAdapterVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAdapterVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAdapterVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAdapterVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAdapterVersionResult getAdapterVersionResult = (GetAdapterVersionResult)response.getAwsResponse();
            return getAdapterVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDocumentAnalysisResult getDocumentAnalysis(GetDocumentAnalysisRequest request) {
        request = (GetDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executeGetDocumentAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDocumentAnalysisResult executeGetDocumentAnalysis(GetDocumentAnalysisRequest getDocumentAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentAnalysisRequestProtocolMarshaller(protocolFactory).marshall((GetDocumentAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDocumentAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDocumentAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentAnalysisResult getDocumentAnalysisResult = (GetDocumentAnalysisResult)response.getAwsResponse();
            return getDocumentAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDocumentTextDetectionResult getDocumentTextDetection(GetDocumentTextDetectionRequest request) {
        request = (GetDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executeGetDocumentTextDetection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDocumentTextDetectionResult executeGetDocumentTextDetection(GetDocumentTextDetectionRequest getDocumentTextDetectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentTextDetectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentTextDetectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentTextDetectionRequestProtocolMarshaller(protocolFactory).marshall((GetDocumentTextDetectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDocumentTextDetectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDocumentTextDetection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentTextDetectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentTextDetectionResult getDocumentTextDetectionResult = (GetDocumentTextDetectionResult)response.getAwsResponse();
            return getDocumentTextDetectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetExpenseAnalysisResult getExpenseAnalysis(GetExpenseAnalysisRequest request) {
        request = (GetExpenseAnalysisRequest)this.beforeClientExecution(request);
        return this.executeGetExpenseAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetExpenseAnalysisResult executeGetExpenseAnalysis(GetExpenseAnalysisRequest getExpenseAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExpenseAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExpenseAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExpenseAnalysisRequestProtocolMarshaller(protocolFactory).marshall((GetExpenseAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)getExpenseAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetExpenseAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetExpenseAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExpenseAnalysisResult getExpenseAnalysisResult = (GetExpenseAnalysisResult)response.getAwsResponse();
            return getExpenseAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLendingAnalysisResult getLendingAnalysis(GetLendingAnalysisRequest request) {
        request = (GetLendingAnalysisRequest)this.beforeClientExecution(request);
        return this.executeGetLendingAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLendingAnalysisResult executeGetLendingAnalysis(GetLendingAnalysisRequest getLendingAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLendingAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLendingAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLendingAnalysisRequestProtocolMarshaller(protocolFactory).marshall((GetLendingAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLendingAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLendingAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLendingAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLendingAnalysisResult getLendingAnalysisResult = (GetLendingAnalysisResult)response.getAwsResponse();
            return getLendingAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLendingAnalysisSummaryResult getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest request) {
        request = (GetLendingAnalysisSummaryRequest)this.beforeClientExecution(request);
        return this.executeGetLendingAnalysisSummary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLendingAnalysisSummaryResult executeGetLendingAnalysisSummary(GetLendingAnalysisSummaryRequest getLendingAnalysisSummaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLendingAnalysisSummaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLendingAnalysisSummaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLendingAnalysisSummaryRequestProtocolMarshaller(protocolFactory).marshall((GetLendingAnalysisSummaryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLendingAnalysisSummaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLendingAnalysisSummary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLendingAnalysisSummaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLendingAnalysisSummaryResult getLendingAnalysisSummaryResult = (GetLendingAnalysisSummaryResult)response.getAwsResponse();
            return getLendingAnalysisSummaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAdapterVersionsResult listAdapterVersions(ListAdapterVersionsRequest request) {
        request = (ListAdapterVersionsRequest)this.beforeClientExecution(request);
        return this.executeListAdapterVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAdapterVersionsResult executeListAdapterVersions(ListAdapterVersionsRequest listAdapterVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAdapterVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAdapterVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAdapterVersionsRequestProtocolMarshaller(protocolFactory).marshall((ListAdapterVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAdapterVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAdapterVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAdapterVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAdapterVersionsResult listAdapterVersionsResult = (ListAdapterVersionsResult)response.getAwsResponse();
            return listAdapterVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAdaptersResult listAdapters(ListAdaptersRequest request) {
        request = (ListAdaptersRequest)this.beforeClientExecution(request);
        return this.executeListAdapters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAdaptersResult executeListAdapters(ListAdaptersRequest listAdaptersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAdaptersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAdaptersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAdaptersRequestProtocolMarshaller(protocolFactory).marshall((ListAdaptersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAdaptersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAdapters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAdaptersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAdaptersResult listAdaptersResult = (ListAdaptersResult)response.getAwsResponse();
            return listAdaptersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDocumentAnalysisResult startDocumentAnalysis(StartDocumentAnalysisRequest request) {
        request = (StartDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executeStartDocumentAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDocumentAnalysisResult executeStartDocumentAnalysis(StartDocumentAnalysisRequest startDocumentAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDocumentAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDocumentAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDocumentAnalysisRequestProtocolMarshaller(protocolFactory).marshall((StartDocumentAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDocumentAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDocumentAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDocumentAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDocumentAnalysisResult startDocumentAnalysisResult = (StartDocumentAnalysisResult)response.getAwsResponse();
            return startDocumentAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDocumentTextDetectionResult startDocumentTextDetection(StartDocumentTextDetectionRequest request) {
        request = (StartDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executeStartDocumentTextDetection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDocumentTextDetectionResult executeStartDocumentTextDetection(StartDocumentTextDetectionRequest startDocumentTextDetectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDocumentTextDetectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDocumentTextDetectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDocumentTextDetectionRequestProtocolMarshaller(protocolFactory).marshall((StartDocumentTextDetectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDocumentTextDetectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDocumentTextDetection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDocumentTextDetectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDocumentTextDetectionResult startDocumentTextDetectionResult = (StartDocumentTextDetectionResult)response.getAwsResponse();
            return startDocumentTextDetectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartExpenseAnalysisResult startExpenseAnalysis(StartExpenseAnalysisRequest request) {
        request = (StartExpenseAnalysisRequest)this.beforeClientExecution(request);
        return this.executeStartExpenseAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartExpenseAnalysisResult executeStartExpenseAnalysis(StartExpenseAnalysisRequest startExpenseAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startExpenseAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartExpenseAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartExpenseAnalysisRequestProtocolMarshaller(protocolFactory).marshall((StartExpenseAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)startExpenseAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartExpenseAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartExpenseAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartExpenseAnalysisResult startExpenseAnalysisResult = (StartExpenseAnalysisResult)response.getAwsResponse();
            return startExpenseAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartLendingAnalysisResult startLendingAnalysis(StartLendingAnalysisRequest request) {
        request = (StartLendingAnalysisRequest)this.beforeClientExecution(request);
        return this.executeStartLendingAnalysis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartLendingAnalysisResult executeStartLendingAnalysis(StartLendingAnalysisRequest startLendingAnalysisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLendingAnalysisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLendingAnalysisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLendingAnalysisRequestProtocolMarshaller(protocolFactory).marshall((StartLendingAnalysisRequest)super.beforeMarshalling((AmazonWebServiceRequest)startLendingAnalysisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartLendingAnalysis");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartLendingAnalysisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartLendingAnalysisResult startLendingAnalysisResult = (StartLendingAnalysisResult)response.getAwsResponse();
            return startLendingAnalysisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAdapterResult updateAdapter(UpdateAdapterRequest request) {
        request = (UpdateAdapterRequest)this.beforeClientExecution(request);
        return this.executeUpdateAdapter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAdapterResult executeUpdateAdapter(UpdateAdapterRequest updateAdapterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAdapterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAdapterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAdapterRequestProtocolMarshaller(protocolFactory).marshall((UpdateAdapterRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAdapterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Textract");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAdapter");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAdapterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAdapterResult updateAdapterResult = (UpdateAdapterResult)response.getAwsResponse();
            return updateAdapterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

