/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.DocumentMetadata;
import com.amazonaws.services.textract.model.ExpenseDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalyzeExpenseResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private DocumentMetadata documentMetadata;
    private List<ExpenseDocument> expenseDocuments;

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public AnalyzeExpenseResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public List<ExpenseDocument> getExpenseDocuments() {
        return this.expenseDocuments;
    }

    public void setExpenseDocuments(Collection<ExpenseDocument> expenseDocuments) {
        if (expenseDocuments == null) {
            this.expenseDocuments = null;
            return;
        }
        this.expenseDocuments = new ArrayList<ExpenseDocument>(expenseDocuments);
    }

    public AnalyzeExpenseResult withExpenseDocuments(ExpenseDocument ... expenseDocuments) {
        if (this.expenseDocuments == null) {
            this.setExpenseDocuments(new ArrayList<ExpenseDocument>(expenseDocuments.length));
        }
        for (ExpenseDocument ele : expenseDocuments) {
            this.expenseDocuments.add(ele);
        }
        return this;
    }

    public AnalyzeExpenseResult withExpenseDocuments(Collection<ExpenseDocument> expenseDocuments) {
        this.setExpenseDocuments(expenseDocuments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getExpenseDocuments() != null) {
            sb.append("ExpenseDocuments: ").append(this.getExpenseDocuments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeExpenseResult)) {
            return false;
        }
        AnalyzeExpenseResult other = (AnalyzeExpenseResult)obj;
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getExpenseDocuments() == null ^ this.getExpenseDocuments() == null) {
            return false;
        }
        return other.getExpenseDocuments() == null || other.getExpenseDocuments().equals(this.getExpenseDocuments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getExpenseDocuments() == null ? 0 : this.getExpenseDocuments().hashCode());
        return hashCode;
    }

    public AnalyzeExpenseResult clone() {
        try {
            return (AnalyzeExpenseResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

