/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.AdapterOverview;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAdaptersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AdapterOverview> adapters;
    private String nextToken;

    public List<AdapterOverview> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(Collection<AdapterOverview> adapters) {
        if (adapters == null) {
            this.adapters = null;
            return;
        }
        this.adapters = new ArrayList<AdapterOverview>(adapters);
    }

    public ListAdaptersResult withAdapters(AdapterOverview ... adapters) {
        if (this.adapters == null) {
            this.setAdapters(new ArrayList<AdapterOverview>(adapters.length));
        }
        for (AdapterOverview ele : adapters) {
            this.adapters.add(ele);
        }
        return this;
    }

    public ListAdaptersResult withAdapters(Collection<AdapterOverview> adapters) {
        this.setAdapters(adapters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAdaptersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapters() != null) {
            sb.append("Adapters: ").append(this.getAdapters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdaptersResult)) {
            return false;
        }
        ListAdaptersResult other = (ListAdaptersResult)obj;
        if (other.getAdapters() == null ^ this.getAdapters() == null) {
            return false;
        }
        if (other.getAdapters() != null && !other.getAdapters().equals(this.getAdapters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapters() == null ? 0 : this.getAdapters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAdaptersResult clone() {
        try {
            return (ListAdaptersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

