/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.DetectedSignature;

@SdkInternalApi
public class DetectedSignatureMarshaller {
    private static final MarshallingInfo<Integer> PAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Page").build();
    private static final DetectedSignatureMarshaller instance = new DetectedSignatureMarshaller();

    public static DetectedSignatureMarshaller getInstance() {
        return instance;
    }

    public void marshall(DetectedSignature detectedSignature, ProtocolMarshaller protocolMarshaller) {
        if (detectedSignature == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)detectedSignature.getPage(), PAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

