/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.NormalizedValue;

@SdkInternalApi
public class NormalizedValueMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<String> VALUETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValueType").build();
    private static final NormalizedValueMarshaller instance = new NormalizedValueMarshaller();

    public static NormalizedValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(NormalizedValue normalizedValue, ProtocolMarshaller protocolMarshaller) {
        if (normalizedValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)normalizedValue.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)normalizedValue.getValueType(), VALUETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

