/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.IPSetUpdate;
import com.amazonaws.services.waf.model.UpdateIPSetRequest;
import com.amazonaws.services.waf.model.transform.IPSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateIPSetRequestMarshaller
implements Marshaller<Request<UpdateIPSetRequest>, UpdateIPSetRequest> {
    public Request<UpdateIPSetRequest> marshall(UpdateIPSetRequest updateIPSetRequest) {
        if (updateIPSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateIPSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateIPSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IPSetUpdate> updatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateIPSetRequest.getIPSetId() != null) {
                jsonWriter.key("IPSetId").value((Object)updateIPSetRequest.getIPSetId());
            }
            if (updateIPSetRequest.getChangeToken() != null) {
                jsonWriter.key("ChangeToken").value((Object)updateIPSetRequest.getChangeToken());
            }
            if ((updatesList = updateIPSetRequest.getUpdates()) != null) {
                jsonWriter.key("Updates");
                jsonWriter.array();
                for (IPSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    IPSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

