/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocatePublicVirtualInterfaceRequestMarshaller
implements Marshaller<Request<AllocatePublicVirtualInterfaceRequest>, AllocatePublicVirtualInterfaceRequest> {
    @Override
    public Request<AllocatePublicVirtualInterfaceRequest> marshall(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        if (allocatePublicVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AllocatePublicVirtualInterfaceRequest> request = new DefaultRequest<AllocatePublicVirtualInterfaceRequest>(allocatePublicVirtualInterfaceRequest, "AmazonDirectConnect");
        String target = "OvertureService.AllocatePublicVirtualInterface";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (allocatePublicVirtualInterfaceRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(allocatePublicVirtualInterfaceRequest.getConnectionId());
            }
            if (allocatePublicVirtualInterfaceRequest.getOwnerAccount() != null) {
                jsonWriter.key("ownerAccount").value(allocatePublicVirtualInterfaceRequest.getOwnerAccount());
            }
            if ((newPublicVirtualInterfaceAllocation = allocatePublicVirtualInterfaceRequest.getNewPublicVirtualInterfaceAllocation()) != null) {
                ListWithAutoConstructFlag routeFilterPrefixesList;
                jsonWriter.key("newPublicVirtualInterfaceAllocation");
                jsonWriter.object();
                if (newPublicVirtualInterfaceAllocation.getVirtualInterfaceName() != null) {
                    jsonWriter.key("virtualInterfaceName").value(newPublicVirtualInterfaceAllocation.getVirtualInterfaceName());
                }
                if (newPublicVirtualInterfaceAllocation.getVlan() != null) {
                    jsonWriter.key("vlan").value(newPublicVirtualInterfaceAllocation.getVlan());
                }
                if (newPublicVirtualInterfaceAllocation.getAsn() != null) {
                    jsonWriter.key("asn").value(newPublicVirtualInterfaceAllocation.getAsn());
                }
                if (newPublicVirtualInterfaceAllocation.getAuthKey() != null) {
                    jsonWriter.key("authKey").value(newPublicVirtualInterfaceAllocation.getAuthKey());
                }
                if (newPublicVirtualInterfaceAllocation.getAmazonAddress() != null) {
                    jsonWriter.key("amazonAddress").value(newPublicVirtualInterfaceAllocation.getAmazonAddress());
                }
                if (newPublicVirtualInterfaceAllocation.getCustomerAddress() != null) {
                    jsonWriter.key("customerAddress").value(newPublicVirtualInterfaceAllocation.getCustomerAddress());
                }
                if (!((routeFilterPrefixesList = (ListWithAutoConstructFlag)newPublicVirtualInterfaceAllocation.getRouteFilterPrefixes()) == null || routeFilterPrefixesList.isAutoConstruct() && routeFilterPrefixesList.isEmpty())) {
                    jsonWriter.key("routeFilterPrefixes");
                    jsonWriter.array();
                    for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                        if (routeFilterPrefixesListValue == null) continue;
                        jsonWriter.object();
                        if (routeFilterPrefixesListValue.getCidr() != null) {
                            jsonWriter.key("cidr").value(routeFilterPrefixesListValue.getCidr());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

