/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.services.ec2.model.transform.CopySnapshotRequestMarshaller;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePreSignUrlRequestHandler
extends CredentialsRequestHandler {
    @Override
    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest instanceof CopySnapshotRequest) {
            String serviceName = "ec2";
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            String sourceRegion = originalCopySnapshotRequest.getSourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.getSourceSnapshotId();
            URI endPointDestination = request.getEndpoint();
            String destinationRegion = originalCopySnapshotRequest.getDestinationRegion() != null ? originalCopySnapshotRequest.getDestinationRegion() : RegionUtils.getRegionByEndpoint(endPointDestination.getHost()).toString();
            URI endPointSource = this.toURI(RegionUtils.getRegion(sourceRegion).getServiceEndpoint(serviceName));
            Request<CopySnapshotRequest> requestForPresigning = this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion);
            requestForPresigning.setEndpoint(endPointSource);
            requestForPresigning.setHttpMethod(HttpMethodName.GET);
            AWS4Signer signer = new AWS4Signer();
            signer.presignRequest(requestForPresigning, this.awsCredentials, null);
            originalCopySnapshotRequest.setPresignedUrl(this.generateUrl(requestForPresigning));
            originalCopySnapshotRequest.setDestinationRegion(destinationRegion);
            request.addParameter("DestinationRegion", StringUtils.fromString(originalCopySnapshotRequest.getDestinationRegion()));
            request.addParameter("PresignedUrl", StringUtils.fromString(originalCopySnapshotRequest.getPresignedUrl()));
        }
    }

    private Request<CopySnapshotRequest> generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = new CopySnapshotRequest().withSourceSnapshotId(sourceSnapshotId).withSourceRegion(sourceRegion).withDestinationRegion(destinationRegion);
        return new CopySnapshotRequestMarshaller().marshall(copySnapshotRequest);
    }

    private String generateUrl(Request<?> request) {
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        if (encodedParams != null) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = (Object)((Object)Protocol.HTTPS) + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

