package com.android.emulator.bluetooth;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * An Emulated Bluetooth Service exposes a method to register an emulated
 * bluetooth device.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.0)",
    comments = "Source: emulated_bluetooth.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class EmulatedBluetoothServiceGrpc {

  private EmulatedBluetoothServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "android.emulation.bluetooth.EmulatedBluetoothService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.android.emulator.bluetooth.GattDevice,
      com.android.emulator.bluetooth.RegistrationStatus> getRegisterGattDeviceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "registerGattDevice",
      requestType = com.android.emulator.bluetooth.GattDevice.class,
      responseType = com.android.emulator.bluetooth.RegistrationStatus.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.bluetooth.GattDevice,
      com.android.emulator.bluetooth.RegistrationStatus> getRegisterGattDeviceMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.bluetooth.GattDevice, com.android.emulator.bluetooth.RegistrationStatus> getRegisterGattDeviceMethod;
    if ((getRegisterGattDeviceMethod = EmulatedBluetoothServiceGrpc.getRegisterGattDeviceMethod) == null) {
      synchronized (EmulatedBluetoothServiceGrpc.class) {
        if ((getRegisterGattDeviceMethod = EmulatedBluetoothServiceGrpc.getRegisterGattDeviceMethod) == null) {
          EmulatedBluetoothServiceGrpc.getRegisterGattDeviceMethod = getRegisterGattDeviceMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.bluetooth.GattDevice, com.android.emulator.bluetooth.RegistrationStatus>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "registerGattDevice"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.GattDevice.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.RegistrationStatus.getDefaultInstance()))
              .setSchemaDescriptor(new EmulatedBluetoothServiceMethodDescriptorSupplier("registerGattDevice"))
              .build();
        }
      }
    }
    return getRegisterGattDeviceMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EmulatedBluetoothServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceStub>() {
        @java.lang.Override
        public EmulatedBluetoothServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EmulatedBluetoothServiceStub(channel, callOptions);
        }
      };
    return EmulatedBluetoothServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EmulatedBluetoothServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceBlockingStub>() {
        @java.lang.Override
        public EmulatedBluetoothServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EmulatedBluetoothServiceBlockingStub(channel, callOptions);
        }
      };
    return EmulatedBluetoothServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static EmulatedBluetoothServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<EmulatedBluetoothServiceFutureStub>() {
        @java.lang.Override
        public EmulatedBluetoothServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new EmulatedBluetoothServiceFutureStub(channel, callOptions);
        }
      };
    return EmulatedBluetoothServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * An Emulated Bluetooth Service exposes a method to register an emulated
   * bluetooth device.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Registers an emulated bluetooth device. The emulator will reach out to
     * the emulated device to read/write and subscribe to properties.
     * The following gRPC error codes can be returned:
     * -  FAILED_PRECONDITION (code 9):
     *      - root canal is not available on this device
     *      - unable to reach the endpoint for the GattDevice
     * -  INTERNAL (code 13) if there was an internal emulator failure.
     * The device will not be discoverable in case of an error.
     * </pre>
     */
    default void registerGattDevice(com.android.emulator.bluetooth.GattDevice request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.RegistrationStatus> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRegisterGattDeviceMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service EmulatedBluetoothService.
   * <pre>
   * An Emulated Bluetooth Service exposes a method to register an emulated
   * bluetooth device.
   * </pre>
   */
  public static abstract class EmulatedBluetoothServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return EmulatedBluetoothServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service EmulatedBluetoothService.
   * <pre>
   * An Emulated Bluetooth Service exposes a method to register an emulated
   * bluetooth device.
   * </pre>
   */
  public static final class EmulatedBluetoothServiceStub
      extends io.grpc.stub.AbstractAsyncStub<EmulatedBluetoothServiceStub> {
    private EmulatedBluetoothServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EmulatedBluetoothServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EmulatedBluetoothServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Registers an emulated bluetooth device. The emulator will reach out to
     * the emulated device to read/write and subscribe to properties.
     * The following gRPC error codes can be returned:
     * -  FAILED_PRECONDITION (code 9):
     *      - root canal is not available on this device
     *      - unable to reach the endpoint for the GattDevice
     * -  INTERNAL (code 13) if there was an internal emulator failure.
     * The device will not be discoverable in case of an error.
     * </pre>
     */
    public void registerGattDevice(com.android.emulator.bluetooth.GattDevice request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.RegistrationStatus> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRegisterGattDeviceMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service EmulatedBluetoothService.
   * <pre>
   * An Emulated Bluetooth Service exposes a method to register an emulated
   * bluetooth device.
   * </pre>
   */
  public static final class EmulatedBluetoothServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<EmulatedBluetoothServiceBlockingStub> {
    private EmulatedBluetoothServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EmulatedBluetoothServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EmulatedBluetoothServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Registers an emulated bluetooth device. The emulator will reach out to
     * the emulated device to read/write and subscribe to properties.
     * The following gRPC error codes can be returned:
     * -  FAILED_PRECONDITION (code 9):
     *      - root canal is not available on this device
     *      - unable to reach the endpoint for the GattDevice
     * -  INTERNAL (code 13) if there was an internal emulator failure.
     * The device will not be discoverable in case of an error.
     * </pre>
     */
    public com.android.emulator.bluetooth.RegistrationStatus registerGattDevice(com.android.emulator.bluetooth.GattDevice request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRegisterGattDeviceMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service EmulatedBluetoothService.
   * <pre>
   * An Emulated Bluetooth Service exposes a method to register an emulated
   * bluetooth device.
   * </pre>
   */
  public static final class EmulatedBluetoothServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<EmulatedBluetoothServiceFutureStub> {
    private EmulatedBluetoothServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EmulatedBluetoothServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new EmulatedBluetoothServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Registers an emulated bluetooth device. The emulator will reach out to
     * the emulated device to read/write and subscribe to properties.
     * The following gRPC error codes can be returned:
     * -  FAILED_PRECONDITION (code 9):
     *      - root canal is not available on this device
     *      - unable to reach the endpoint for the GattDevice
     * -  INTERNAL (code 13) if there was an internal emulator failure.
     * The device will not be discoverable in case of an error.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.bluetooth.RegistrationStatus> registerGattDevice(
        com.android.emulator.bluetooth.GattDevice request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRegisterGattDeviceMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_REGISTER_GATT_DEVICE = 0;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_REGISTER_GATT_DEVICE:
          serviceImpl.registerGattDevice((com.android.emulator.bluetooth.GattDevice) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.RegistrationStatus>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getRegisterGattDeviceMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.bluetooth.GattDevice,
              com.android.emulator.bluetooth.RegistrationStatus>(
                service, METHODID_REGISTER_GATT_DEVICE)))
        .build();
  }

  private static abstract class EmulatedBluetoothServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    EmulatedBluetoothServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.bluetooth.EmulatedBluetooth.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("EmulatedBluetoothService");
    }
  }

  private static final class EmulatedBluetoothServiceFileDescriptorSupplier
      extends EmulatedBluetoothServiceBaseDescriptorSupplier {
    EmulatedBluetoothServiceFileDescriptorSupplier() {}
  }

  private static final class EmulatedBluetoothServiceMethodDescriptorSupplier
      extends EmulatedBluetoothServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    EmulatedBluetoothServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EmulatedBluetoothServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EmulatedBluetoothServiceFileDescriptorSupplier())
              .addMethod(getRegisterGattDeviceMethod())
              .build();
        }
      }
    }
    return result;
  }
}
