package com.android.emulator.bluetooth;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * You can provide your own GattDevice by implementing this service
 * and registering it with the android emulator.
 * The device will appear as a real bluetooth device, and you will
 * receive callbacks when the bluetooth system wants to
 * read, write or observe a characteristic.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.0)",
    comments = "Source: emulated_bluetooth_device.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class GattDeviceServiceGrpc {

  private GattDeviceServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "android.emulation.bluetooth.GattDeviceService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicReadRequestMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnCharacteristicReadRequest",
      requestType = com.android.emulator.bluetooth.CharacteristicValueRequest.class,
      responseType = com.android.emulator.bluetooth.CharacteristicValueResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicReadRequestMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicReadRequestMethod;
    if ((getOnCharacteristicReadRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicReadRequestMethod) == null) {
      synchronized (GattDeviceServiceGrpc.class) {
        if ((getOnCharacteristicReadRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicReadRequestMethod) == null) {
          GattDeviceServiceGrpc.getOnCharacteristicReadRequestMethod = getOnCharacteristicReadRequestMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnCharacteristicReadRequest"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueResponse.getDefaultInstance()))
              .setSchemaDescriptor(new GattDeviceServiceMethodDescriptorSupplier("OnCharacteristicReadRequest"))
              .build();
        }
      }
    }
    return getOnCharacteristicReadRequestMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicWriteRequestMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnCharacteristicWriteRequest",
      requestType = com.android.emulator.bluetooth.CharacteristicValueRequest.class,
      responseType = com.android.emulator.bluetooth.CharacteristicValueResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicWriteRequestMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicWriteRequestMethod;
    if ((getOnCharacteristicWriteRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicWriteRequestMethod) == null) {
      synchronized (GattDeviceServiceGrpc.class) {
        if ((getOnCharacteristicWriteRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicWriteRequestMethod) == null) {
          GattDeviceServiceGrpc.getOnCharacteristicWriteRequestMethod = getOnCharacteristicWriteRequestMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnCharacteristicWriteRequest"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueResponse.getDefaultInstance()))
              .setSchemaDescriptor(new GattDeviceServiceMethodDescriptorSupplier("OnCharacteristicWriteRequest"))
              .build();
        }
      }
    }
    return getOnCharacteristicWriteRequestMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicObserveRequestMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnCharacteristicObserveRequest",
      requestType = com.android.emulator.bluetooth.CharacteristicValueRequest.class,
      responseType = com.android.emulator.bluetooth.CharacteristicValueResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest,
      com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicObserveRequestMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse> getOnCharacteristicObserveRequestMethod;
    if ((getOnCharacteristicObserveRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicObserveRequestMethod) == null) {
      synchronized (GattDeviceServiceGrpc.class) {
        if ((getOnCharacteristicObserveRequestMethod = GattDeviceServiceGrpc.getOnCharacteristicObserveRequestMethod) == null) {
          GattDeviceServiceGrpc.getOnCharacteristicObserveRequestMethod = getOnCharacteristicObserveRequestMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.bluetooth.CharacteristicValueRequest, com.android.emulator.bluetooth.CharacteristicValueResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnCharacteristicObserveRequest"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.CharacteristicValueResponse.getDefaultInstance()))
              .setSchemaDescriptor(new GattDeviceServiceMethodDescriptorSupplier("OnCharacteristicObserveRequest"))
              .build();
        }
      }
    }
    return getOnCharacteristicObserveRequestMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.bluetooth.ConnectionStateChange,
      com.google.protobuf.Empty> getOnConnectionStateChangeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnConnectionStateChange",
      requestType = com.android.emulator.bluetooth.ConnectionStateChange.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.bluetooth.ConnectionStateChange,
      com.google.protobuf.Empty> getOnConnectionStateChangeMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.bluetooth.ConnectionStateChange, com.google.protobuf.Empty> getOnConnectionStateChangeMethod;
    if ((getOnConnectionStateChangeMethod = GattDeviceServiceGrpc.getOnConnectionStateChangeMethod) == null) {
      synchronized (GattDeviceServiceGrpc.class) {
        if ((getOnConnectionStateChangeMethod = GattDeviceServiceGrpc.getOnConnectionStateChangeMethod) == null) {
          GattDeviceServiceGrpc.getOnConnectionStateChangeMethod = getOnConnectionStateChangeMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.bluetooth.ConnectionStateChange, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnConnectionStateChange"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.bluetooth.ConnectionStateChange.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new GattDeviceServiceMethodDescriptorSupplier("OnConnectionStateChange"))
              .build();
        }
      }
    }
    return getOnConnectionStateChangeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static GattDeviceServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceStub>() {
        @java.lang.Override
        public GattDeviceServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new GattDeviceServiceStub(channel, callOptions);
        }
      };
    return GattDeviceServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static GattDeviceServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceBlockingStub>() {
        @java.lang.Override
        public GattDeviceServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new GattDeviceServiceBlockingStub(channel, callOptions);
        }
      };
    return GattDeviceServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static GattDeviceServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<GattDeviceServiceFutureStub>() {
        @java.lang.Override
        public GattDeviceServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new GattDeviceServiceFutureStub(channel, callOptions);
        }
      };
    return GattDeviceServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * You can provide your own GattDevice by implementing this service
   * and registering it with the android emulator.
   * The device will appear as a real bluetooth device, and you will
   * receive callbacks when the bluetooth system wants to
   * read, write or observe a characteristic.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * A remote client has requested to read a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    default void onCharacteristicReadRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnCharacteristicReadRequestMethod(), responseObserver);
    }

    /**
     * <pre>
     * A remote client has requested to write to a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    default void onCharacteristicWriteRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnCharacteristicWriteRequestMethod(), responseObserver);
    }

    /**
     * <pre>
     * Listens for notifications from the emulated device, the device should
     * write to the stream with a response when a change has occurred.
     * </pre>
     */
    default void onCharacteristicObserveRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnCharacteristicObserveRequestMethod(), responseObserver);
    }

    /**
     * <pre>
     * A remote device has been connected or disconnected.
     * </pre>
     */
    default void onConnectionStateChange(com.android.emulator.bluetooth.ConnectionStateChange request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnConnectionStateChangeMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service GattDeviceService.
   * <pre>
   * You can provide your own GattDevice by implementing this service
   * and registering it with the android emulator.
   * The device will appear as a real bluetooth device, and you will
   * receive callbacks when the bluetooth system wants to
   * read, write or observe a characteristic.
   * </pre>
   */
  public static abstract class GattDeviceServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return GattDeviceServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service GattDeviceService.
   * <pre>
   * You can provide your own GattDevice by implementing this service
   * and registering it with the android emulator.
   * The device will appear as a real bluetooth device, and you will
   * receive callbacks when the bluetooth system wants to
   * read, write or observe a characteristic.
   * </pre>
   */
  public static final class GattDeviceServiceStub
      extends io.grpc.stub.AbstractAsyncStub<GattDeviceServiceStub> {
    private GattDeviceServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GattDeviceServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new GattDeviceServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * A remote client has requested to read a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public void onCharacteristicReadRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnCharacteristicReadRequestMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * A remote client has requested to write to a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public void onCharacteristicWriteRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnCharacteristicWriteRequestMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Listens for notifications from the emulated device, the device should
     * write to the stream with a response when a change has occurred.
     * </pre>
     */
    public void onCharacteristicObserveRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getOnCharacteristicObserveRequestMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * A remote device has been connected or disconnected.
     * </pre>
     */
    public void onConnectionStateChange(com.android.emulator.bluetooth.ConnectionStateChange request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnConnectionStateChangeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service GattDeviceService.
   * <pre>
   * You can provide your own GattDevice by implementing this service
   * and registering it with the android emulator.
   * The device will appear as a real bluetooth device, and you will
   * receive callbacks when the bluetooth system wants to
   * read, write or observe a characteristic.
   * </pre>
   */
  public static final class GattDeviceServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<GattDeviceServiceBlockingStub> {
    private GattDeviceServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GattDeviceServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new GattDeviceServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * A remote client has requested to read a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public com.android.emulator.bluetooth.CharacteristicValueResponse onCharacteristicReadRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnCharacteristicReadRequestMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * A remote client has requested to write to a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public com.android.emulator.bluetooth.CharacteristicValueResponse onCharacteristicWriteRequest(com.android.emulator.bluetooth.CharacteristicValueRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnCharacteristicWriteRequestMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Listens for notifications from the emulated device, the device should
     * write to the stream with a response when a change has occurred.
     * </pre>
     */
    public java.util.Iterator<com.android.emulator.bluetooth.CharacteristicValueResponse> onCharacteristicObserveRequest(
        com.android.emulator.bluetooth.CharacteristicValueRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getOnCharacteristicObserveRequestMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * A remote device has been connected or disconnected.
     * </pre>
     */
    public com.google.protobuf.Empty onConnectionStateChange(com.android.emulator.bluetooth.ConnectionStateChange request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnConnectionStateChangeMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service GattDeviceService.
   * <pre>
   * You can provide your own GattDevice by implementing this service
   * and registering it with the android emulator.
   * The device will appear as a real bluetooth device, and you will
   * receive callbacks when the bluetooth system wants to
   * read, write or observe a characteristic.
   * </pre>
   */
  public static final class GattDeviceServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<GattDeviceServiceFutureStub> {
    private GattDeviceServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GattDeviceServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new GattDeviceServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * A remote client has requested to read a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.bluetooth.CharacteristicValueResponse> onCharacteristicReadRequest(
        com.android.emulator.bluetooth.CharacteristicValueRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnCharacteristicReadRequestMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * A remote client has requested to write to a local characteristic.
     * Return the current observed value.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.bluetooth.CharacteristicValueResponse> onCharacteristicWriteRequest(
        com.android.emulator.bluetooth.CharacteristicValueRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnCharacteristicWriteRequestMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * A remote device has been connected or disconnected.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> onConnectionStateChange(
        com.android.emulator.bluetooth.ConnectionStateChange request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnConnectionStateChangeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ON_CHARACTERISTIC_READ_REQUEST = 0;
  private static final int METHODID_ON_CHARACTERISTIC_WRITE_REQUEST = 1;
  private static final int METHODID_ON_CHARACTERISTIC_OBSERVE_REQUEST = 2;
  private static final int METHODID_ON_CONNECTION_STATE_CHANGE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ON_CHARACTERISTIC_READ_REQUEST:
          serviceImpl.onCharacteristicReadRequest((com.android.emulator.bluetooth.CharacteristicValueRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse>) responseObserver);
          break;
        case METHODID_ON_CHARACTERISTIC_WRITE_REQUEST:
          serviceImpl.onCharacteristicWriteRequest((com.android.emulator.bluetooth.CharacteristicValueRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse>) responseObserver);
          break;
        case METHODID_ON_CHARACTERISTIC_OBSERVE_REQUEST:
          serviceImpl.onCharacteristicObserveRequest((com.android.emulator.bluetooth.CharacteristicValueRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.bluetooth.CharacteristicValueResponse>) responseObserver);
          break;
        case METHODID_ON_CONNECTION_STATE_CHANGE:
          serviceImpl.onConnectionStateChange((com.android.emulator.bluetooth.ConnectionStateChange) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getOnCharacteristicReadRequestMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.bluetooth.CharacteristicValueRequest,
              com.android.emulator.bluetooth.CharacteristicValueResponse>(
                service, METHODID_ON_CHARACTERISTIC_READ_REQUEST)))
        .addMethod(
          getOnCharacteristicWriteRequestMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.bluetooth.CharacteristicValueRequest,
              com.android.emulator.bluetooth.CharacteristicValueResponse>(
                service, METHODID_ON_CHARACTERISTIC_WRITE_REQUEST)))
        .addMethod(
          getOnCharacteristicObserveRequestMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              com.android.emulator.bluetooth.CharacteristicValueRequest,
              com.android.emulator.bluetooth.CharacteristicValueResponse>(
                service, METHODID_ON_CHARACTERISTIC_OBSERVE_REQUEST)))
        .addMethod(
          getOnConnectionStateChangeMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.bluetooth.ConnectionStateChange,
              com.google.protobuf.Empty>(
                service, METHODID_ON_CONNECTION_STATE_CHANGE)))
        .build();
  }

  private static abstract class GattDeviceServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    GattDeviceServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.bluetooth.EmulatedBluetoothDevice.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("GattDeviceService");
    }
  }

  private static final class GattDeviceServiceFileDescriptorSupplier
      extends GattDeviceServiceBaseDescriptorSupplier {
    GattDeviceServiceFileDescriptorSupplier() {}
  }

  private static final class GattDeviceServiceMethodDescriptorSupplier
      extends GattDeviceServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    GattDeviceServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (GattDeviceServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new GattDeviceServiceFileDescriptorSupplier())
              .addMethod(getOnCharacteristicReadRequestMethod())
              .addMethod(getOnCharacteristicWriteRequestMethod())
              .addMethod(getOnCharacteristicObserveRequestMethod())
              .addMethod(getOnConnectionStateChangeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
