package com.android.emulator.control;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The ADB service enables you to interact with the running Adb service inside
 * the emulator. This service is usually not available as it has the ability to
 * retrieve the private adb key from the running image and make adb accessible
 * if and only if:
 * 1. The private key is available to the running emulator.
 * 2. The public key corresponding the private key is embedded in the encrypted
 *    partition.
 * This service is usually *ONLY* available to containerized emulators that are
 * running with mutual authentication on the gRPC endpoint (that is SSL is
 * enabled and a valid client certificate is required.).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.0)",
    comments = "Source: adb_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class AdbGrpc {

  private AdbGrpc() {}

  public static final java.lang.String SERVICE_NAME = "android.emulation.control.Adb";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.android.emulator.control.AdbKey> getPullAdbKeyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "pullAdbKey",
      requestType = com.google.protobuf.Empty.class,
      responseType = com.android.emulator.control.AdbKey.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.android.emulator.control.AdbKey> getPullAdbKeyMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, com.android.emulator.control.AdbKey> getPullAdbKeyMethod;
    if ((getPullAdbKeyMethod = AdbGrpc.getPullAdbKeyMethod) == null) {
      synchronized (AdbGrpc.class) {
        if ((getPullAdbKeyMethod = AdbGrpc.getPullAdbKeyMethod) == null) {
          AdbGrpc.getPullAdbKeyMethod = getPullAdbKeyMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, com.android.emulator.control.AdbKey>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "pullAdbKey"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.AdbKey.getDefaultInstance()))
              .setSchemaDescriptor(new AdbMethodDescriptorSupplier("pullAdbKey"))
              .build();
        }
      }
    }
    return getPullAdbKeyMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.AdbPacket,
      com.android.emulator.control.AdbPacket> getForwardAdbMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "forwardAdb",
      requestType = com.android.emulator.control.AdbPacket.class,
      responseType = com.android.emulator.control.AdbPacket.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.AdbPacket,
      com.android.emulator.control.AdbPacket> getForwardAdbMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.AdbPacket, com.android.emulator.control.AdbPacket> getForwardAdbMethod;
    if ((getForwardAdbMethod = AdbGrpc.getForwardAdbMethod) == null) {
      synchronized (AdbGrpc.class) {
        if ((getForwardAdbMethod = AdbGrpc.getForwardAdbMethod) == null) {
          AdbGrpc.getForwardAdbMethod = getForwardAdbMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.AdbPacket, com.android.emulator.control.AdbPacket>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "forwardAdb"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.AdbPacket.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.AdbPacket.getDefaultInstance()))
              .setSchemaDescriptor(new AdbMethodDescriptorSupplier("forwardAdb"))
              .build();
        }
      }
    }
    return getForwardAdbMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static AdbStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AdbStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AdbStub>() {
        @java.lang.Override
        public AdbStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AdbStub(channel, callOptions);
        }
      };
    return AdbStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static AdbBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AdbBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AdbBlockingStub>() {
        @java.lang.Override
        public AdbBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AdbBlockingStub(channel, callOptions);
        }
      };
    return AdbBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static AdbFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AdbFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AdbFutureStub>() {
        @java.lang.Override
        public AdbFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AdbFutureStub(channel, callOptions);
        }
      };
    return AdbFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The ADB service enables you to interact with the running Adb service inside
   * the emulator. This service is usually not available as it has the ability to
   * retrieve the private adb key from the running image and make adb accessible
   * if and only if:
   * 1. The private key is available to the running emulator.
   * 2. The public key corresponding the private key is embedded in the encrypted
   *    partition.
   * This service is usually *ONLY* available to containerized emulators that are
   * running with mutual authentication on the gRPC endpoint (that is SSL is
   * enabled and a valid client certificate is required.).
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Pulls the private key that the emulator uses to communicate with the
     * emulator. This private key should be made accessible to adb when you wish
     * to establish a connection to this emulator.
     * The following gRPC error codes can be returned:
     * -  unimplemented (code 14) if the AdbService is not availab.e
     * -  aborted (code 10) if:
     *     - The private key file cannot be found.
     *     - The private key file cannot be read.
     * </pre>
     */
    default void pullAdbKey(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.AdbKey> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPullAdbKeyMethod(), responseObserver);
    }

    /**
     * <pre>
     * Forwards the incoming bytes to the running adb deamon.
     * </pre>
     */
    default void forwardAdb(com.android.emulator.control.AdbPacket request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.AdbPacket> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getForwardAdbMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Adb.
   * <pre>
   * The ADB service enables you to interact with the running Adb service inside
   * the emulator. This service is usually not available as it has the ability to
   * retrieve the private adb key from the running image and make adb accessible
   * if and only if:
   * 1. The private key is available to the running emulator.
   * 2. The public key corresponding the private key is embedded in the encrypted
   *    partition.
   * This service is usually *ONLY* available to containerized emulators that are
   * running with mutual authentication on the gRPC endpoint (that is SSL is
   * enabled and a valid client certificate is required.).
   * </pre>
   */
  public static abstract class AdbImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return AdbGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Adb.
   * <pre>
   * The ADB service enables you to interact with the running Adb service inside
   * the emulator. This service is usually not available as it has the ability to
   * retrieve the private adb key from the running image and make adb accessible
   * if and only if:
   * 1. The private key is available to the running emulator.
   * 2. The public key corresponding the private key is embedded in the encrypted
   *    partition.
   * This service is usually *ONLY* available to containerized emulators that are
   * running with mutual authentication on the gRPC endpoint (that is SSL is
   * enabled and a valid client certificate is required.).
   * </pre>
   */
  public static final class AdbStub
      extends io.grpc.stub.AbstractAsyncStub<AdbStub> {
    private AdbStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AdbStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AdbStub(channel, callOptions);
    }

    /**
     * <pre>
     * Pulls the private key that the emulator uses to communicate with the
     * emulator. This private key should be made accessible to adb when you wish
     * to establish a connection to this emulator.
     * The following gRPC error codes can be returned:
     * -  unimplemented (code 14) if the AdbService is not availab.e
     * -  aborted (code 10) if:
     *     - The private key file cannot be found.
     *     - The private key file cannot be read.
     * </pre>
     */
    public void pullAdbKey(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.AdbKey> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPullAdbKeyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Forwards the incoming bytes to the running adb deamon.
     * </pre>
     */
    public void forwardAdb(com.android.emulator.control.AdbPacket request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.AdbPacket> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getForwardAdbMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Adb.
   * <pre>
   * The ADB service enables you to interact with the running Adb service inside
   * the emulator. This service is usually not available as it has the ability to
   * retrieve the private adb key from the running image and make adb accessible
   * if and only if:
   * 1. The private key is available to the running emulator.
   * 2. The public key corresponding the private key is embedded in the encrypted
   *    partition.
   * This service is usually *ONLY* available to containerized emulators that are
   * running with mutual authentication on the gRPC endpoint (that is SSL is
   * enabled and a valid client certificate is required.).
   * </pre>
   */
  public static final class AdbBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<AdbBlockingStub> {
    private AdbBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AdbBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AdbBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Pulls the private key that the emulator uses to communicate with the
     * emulator. This private key should be made accessible to adb when you wish
     * to establish a connection to this emulator.
     * The following gRPC error codes can be returned:
     * -  unimplemented (code 14) if the AdbService is not availab.e
     * -  aborted (code 10) if:
     *     - The private key file cannot be found.
     *     - The private key file cannot be read.
     * </pre>
     */
    public com.android.emulator.control.AdbKey pullAdbKey(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPullAdbKeyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Forwards the incoming bytes to the running adb deamon.
     * </pre>
     */
    public com.android.emulator.control.AdbPacket forwardAdb(com.android.emulator.control.AdbPacket request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getForwardAdbMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Adb.
   * <pre>
   * The ADB service enables you to interact with the running Adb service inside
   * the emulator. This service is usually not available as it has the ability to
   * retrieve the private adb key from the running image and make adb accessible
   * if and only if:
   * 1. The private key is available to the running emulator.
   * 2. The public key corresponding the private key is embedded in the encrypted
   *    partition.
   * This service is usually *ONLY* available to containerized emulators that are
   * running with mutual authentication on the gRPC endpoint (that is SSL is
   * enabled and a valid client certificate is required.).
   * </pre>
   */
  public static final class AdbFutureStub
      extends io.grpc.stub.AbstractFutureStub<AdbFutureStub> {
    private AdbFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AdbFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AdbFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Pulls the private key that the emulator uses to communicate with the
     * emulator. This private key should be made accessible to adb when you wish
     * to establish a connection to this emulator.
     * The following gRPC error codes can be returned:
     * -  unimplemented (code 14) if the AdbService is not availab.e
     * -  aborted (code 10) if:
     *     - The private key file cannot be found.
     *     - The private key file cannot be read.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.AdbKey> pullAdbKey(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPullAdbKeyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Forwards the incoming bytes to the running adb deamon.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.AdbPacket> forwardAdb(
        com.android.emulator.control.AdbPacket request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getForwardAdbMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PULL_ADB_KEY = 0;
  private static final int METHODID_FORWARD_ADB = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PULL_ADB_KEY:
          serviceImpl.pullAdbKey((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.AdbKey>) responseObserver);
          break;
        case METHODID_FORWARD_ADB:
          serviceImpl.forwardAdb((com.android.emulator.control.AdbPacket) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.AdbPacket>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getPullAdbKeyMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.google.protobuf.Empty,
              com.android.emulator.control.AdbKey>(
                service, METHODID_PULL_ADB_KEY)))
        .addMethod(
          getForwardAdbMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.AdbPacket,
              com.android.emulator.control.AdbPacket>(
                service, METHODID_FORWARD_ADB)))
        .build();
  }

  private static abstract class AdbBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    AdbBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.control.AdbService.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Adb");
    }
  }

  private static final class AdbFileDescriptorSupplier
      extends AdbBaseDescriptorSupplier {
    AdbFileDescriptorSupplier() {}
  }

  private static final class AdbMethodDescriptorSupplier
      extends AdbBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    AdbMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (AdbGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new AdbFileDescriptorSupplier())
              .addMethod(getPullAdbKeyMethod())
              .addMethod(getForwardAdbMethod())
              .build();
        }
      }
    }
    return result;
  }
}
