package com.android.emulator.control;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * An RTC service lets you interact with the emulator through WebRTC
 * Note that this is currently an experimental feature, and that the
 * service definition might change without notice. Use at your own risk!
 * The following endpoints are needed to establish the webrtc protocol
 * Due to limitiations in Javascript we cannot make use of bidirectional
 * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
 * details.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.0)",
    comments = "Source: rtc_service_v2.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class RtcGrpc {

  private RtcGrpc() {}

  public static final java.lang.String SERVICE_NAME = "android.emulation.control.v2.Rtc";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.RtcStreamRequest,
      com.android.emulator.control.RtcStreamResponse> getRequestRtcStreamMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RequestRtcStream",
      requestType = com.android.emulator.control.RtcStreamRequest.class,
      responseType = com.android.emulator.control.RtcStreamResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.RtcStreamRequest,
      com.android.emulator.control.RtcStreamResponse> getRequestRtcStreamMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.RtcStreamRequest, com.android.emulator.control.RtcStreamResponse> getRequestRtcStreamMethod;
    if ((getRequestRtcStreamMethod = RtcGrpc.getRequestRtcStreamMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getRequestRtcStreamMethod = RtcGrpc.getRequestRtcStreamMethod) == null) {
          RtcGrpc.getRequestRtcStreamMethod = getRequestRtcStreamMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.RtcStreamRequest, com.android.emulator.control.RtcStreamResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RequestRtcStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.RtcStreamRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.RtcStreamResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("RequestRtcStream"))
              .build();
        }
      }
    }
    return getRequestRtcStreamMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SendJsepMessageRequest,
      com.android.emulator.control.SendJsepMessageResponse> getSendJsepMessageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SendJsepMessage",
      requestType = com.android.emulator.control.SendJsepMessageRequest.class,
      responseType = com.android.emulator.control.SendJsepMessageResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SendJsepMessageRequest,
      com.android.emulator.control.SendJsepMessageResponse> getSendJsepMessageMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SendJsepMessageRequest, com.android.emulator.control.SendJsepMessageResponse> getSendJsepMessageMethod;
    if ((getSendJsepMessageMethod = RtcGrpc.getSendJsepMessageMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getSendJsepMessageMethod = RtcGrpc.getSendJsepMessageMethod) == null) {
          RtcGrpc.getSendJsepMessageMethod = getSendJsepMessageMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SendJsepMessageRequest, com.android.emulator.control.SendJsepMessageResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SendJsepMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SendJsepMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SendJsepMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("SendJsepMessage"))
              .build();
        }
      }
    }
    return getSendJsepMessageMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest,
      com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageStreamMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ReceiveJsepMessageStream",
      requestType = com.android.emulator.control.ReceiveJsepMessageRequest.class,
      responseType = com.android.emulator.control.ReceiveJsepMessageResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest,
      com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageStreamMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest, com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageStreamMethod;
    if ((getReceiveJsepMessageStreamMethod = RtcGrpc.getReceiveJsepMessageStreamMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getReceiveJsepMessageStreamMethod = RtcGrpc.getReceiveJsepMessageStreamMethod) == null) {
          RtcGrpc.getReceiveJsepMessageStreamMethod = getReceiveJsepMessageStreamMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.ReceiveJsepMessageRequest, com.android.emulator.control.ReceiveJsepMessageResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ReceiveJsepMessageStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.ReceiveJsepMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.ReceiveJsepMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("ReceiveJsepMessageStream"))
              .build();
        }
      }
    }
    return getReceiveJsepMessageStreamMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest,
      com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ReceiveJsepMessage",
      requestType = com.android.emulator.control.ReceiveJsepMessageRequest.class,
      responseType = com.android.emulator.control.ReceiveJsepMessageResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest,
      com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.ReceiveJsepMessageRequest, com.android.emulator.control.ReceiveJsepMessageResponse> getReceiveJsepMessageMethod;
    if ((getReceiveJsepMessageMethod = RtcGrpc.getReceiveJsepMessageMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getReceiveJsepMessageMethod = RtcGrpc.getReceiveJsepMessageMethod) == null) {
          RtcGrpc.getReceiveJsepMessageMethod = getReceiveJsepMessageMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.ReceiveJsepMessageRequest, com.android.emulator.control.ReceiveJsepMessageResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ReceiveJsepMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.ReceiveJsepMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.ReceiveJsepMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("ReceiveJsepMessage"))
              .build();
        }
      }
    }
    return getReceiveJsepMessageMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static RtcStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcStub>() {
        @java.lang.Override
        public RtcStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcStub(channel, callOptions);
        }
      };
    return RtcStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static RtcBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcBlockingStub>() {
        @java.lang.Override
        public RtcBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcBlockingStub(channel, callOptions);
        }
      };
    return RtcBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static RtcFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcFutureStub>() {
        @java.lang.Override
        public RtcFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcFutureStub(channel, callOptions);
        }
      };
    return RtcFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    default void requestRtcStream(com.android.emulator.control.RtcStreamRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.RtcStreamResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRequestRtcStreamMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    default void sendJsepMessage(com.android.emulator.control.SendJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SendJsepMessageResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSendJsepMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    default void receiveJsepMessageStream(com.android.emulator.control.ReceiveJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReceiveJsepMessageStreamMethod(), responseObserver);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    default void receiveJsepMessage(com.android.emulator.control.ReceiveJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReceiveJsepMessageMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Rtc.
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static abstract class RtcImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return RtcGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Rtc.
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcStub
      extends io.grpc.stub.AbstractAsyncStub<RtcStub> {
    private RtcStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public void requestRtcStream(com.android.emulator.control.RtcStreamRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.RtcStreamResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRequestRtcStreamMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public void sendJsepMessage(com.android.emulator.control.SendJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SendJsepMessageResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSendJsepMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessageStream(com.android.emulator.control.ReceiveJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getReceiveJsepMessageStreamMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessage(com.android.emulator.control.ReceiveJsepMessageRequest request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReceiveJsepMessageMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Rtc.
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<RtcBlockingStub> {
    private RtcBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public com.android.emulator.control.RtcStreamResponse requestRtcStream(com.android.emulator.control.RtcStreamRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRequestRtcStreamMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public com.android.emulator.control.SendJsepMessageResponse sendJsepMessage(com.android.emulator.control.SendJsepMessageRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSendJsepMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public java.util.Iterator<com.android.emulator.control.ReceiveJsepMessageResponse> receiveJsepMessageStream(
        com.android.emulator.control.ReceiveJsepMessageRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getReceiveJsepMessageStreamMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public com.android.emulator.control.ReceiveJsepMessageResponse receiveJsepMessage(com.android.emulator.control.ReceiveJsepMessageRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReceiveJsepMessageMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Rtc.
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcFutureStub
      extends io.grpc.stub.AbstractFutureStub<RtcFutureStub> {
    private RtcFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.RtcStreamResponse> requestRtcStream(
        com.android.emulator.control.RtcStreamRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRequestRtcStreamMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SendJsepMessageResponse> sendJsepMessage(
        com.android.emulator.control.SendJsepMessageRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSendJsepMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.ReceiveJsepMessageResponse> receiveJsepMessage(
        com.android.emulator.control.ReceiveJsepMessageRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReceiveJsepMessageMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_REQUEST_RTC_STREAM = 0;
  private static final int METHODID_SEND_JSEP_MESSAGE = 1;
  private static final int METHODID_RECEIVE_JSEP_MESSAGE_STREAM = 2;
  private static final int METHODID_RECEIVE_JSEP_MESSAGE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_REQUEST_RTC_STREAM:
          serviceImpl.requestRtcStream((com.android.emulator.control.RtcStreamRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.RtcStreamResponse>) responseObserver);
          break;
        case METHODID_SEND_JSEP_MESSAGE:
          serviceImpl.sendJsepMessage((com.android.emulator.control.SendJsepMessageRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SendJsepMessageResponse>) responseObserver);
          break;
        case METHODID_RECEIVE_JSEP_MESSAGE_STREAM:
          serviceImpl.receiveJsepMessageStream((com.android.emulator.control.ReceiveJsepMessageRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse>) responseObserver);
          break;
        case METHODID_RECEIVE_JSEP_MESSAGE:
          serviceImpl.receiveJsepMessage((com.android.emulator.control.ReceiveJsepMessageRequest) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.ReceiveJsepMessageResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getRequestRtcStreamMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.RtcStreamRequest,
              com.android.emulator.control.RtcStreamResponse>(
                service, METHODID_REQUEST_RTC_STREAM)))
        .addMethod(
          getSendJsepMessageMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SendJsepMessageRequest,
              com.android.emulator.control.SendJsepMessageResponse>(
                service, METHODID_SEND_JSEP_MESSAGE)))
        .addMethod(
          getReceiveJsepMessageStreamMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              com.android.emulator.control.ReceiveJsepMessageRequest,
              com.android.emulator.control.ReceiveJsepMessageResponse>(
                service, METHODID_RECEIVE_JSEP_MESSAGE_STREAM)))
        .addMethod(
          getReceiveJsepMessageMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.ReceiveJsepMessageRequest,
              com.android.emulator.control.ReceiveJsepMessageResponse>(
                service, METHODID_RECEIVE_JSEP_MESSAGE)))
        .build();
  }

  private static abstract class RtcBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    RtcBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.control.RtcServiceV2.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Rtc");
    }
  }

  private static final class RtcFileDescriptorSupplier
      extends RtcBaseDescriptorSupplier {
    RtcFileDescriptorSupplier() {}
  }

  private static final class RtcMethodDescriptorSupplier
      extends RtcBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    RtcMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (RtcGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new RtcFileDescriptorSupplier())
              .addMethod(getRequestRtcStreamMethod())
              .addMethod(getSendJsepMessageMethod())
              .addMethod(getReceiveJsepMessageStreamMethod())
              .addMethod(getReceiveJsepMessageMethod())
              .build();
        }
      }
    }
    return result;
  }
}
