package com.android.emulator.control;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The SnapshotService enables you to list, insert, store, and retrieve
 * snapshots.
 * Currently there are two types of snapshots:
 * - Local (default): These are snapshots that are created locally. They are
 *     stored internally inside qcow2 files and are very efficient. These are
 *     the snapshots usually created by interacting with the UI.
 * - Remote: These are snapshots that have been exported at a certain point.
 *     an exported snapshot is normalized (completely self contained) and
 *     can be imported into an emulator with a similar hardware configuration.
 * Currently the emulator has limited support for importing snapshots:
 * - Once an imported snapshot has been loaded into an emulator it is no longer
 * possible to create new snapshots.
 * - The hardware configuration of the emulator your are pushing a snapshot to
 * must match (or be very similar) to the one you pulled the snapshot from.
 * For example do not expect to be able to restore a snapshot on created on an
 * Intel cpu on an AMD cpu.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.0)",
    comments = "Source: snapshot_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class SnapshotServiceGrpc {

  private SnapshotServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "android.emulation.control.SnapshotService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotFilter,
      com.android.emulator.control.SnapshotList> getListSnapshotsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListSnapshots",
      requestType = com.android.emulator.control.SnapshotFilter.class,
      responseType = com.android.emulator.control.SnapshotList.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotFilter,
      com.android.emulator.control.SnapshotList> getListSnapshotsMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotFilter, com.android.emulator.control.SnapshotList> getListSnapshotsMethod;
    if ((getListSnapshotsMethod = SnapshotServiceGrpc.getListSnapshotsMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getListSnapshotsMethod = SnapshotServiceGrpc.getListSnapshotsMethod) == null) {
          SnapshotServiceGrpc.getListSnapshotsMethod = getListSnapshotsMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotFilter, com.android.emulator.control.SnapshotList>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListSnapshots"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotFilter.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotList.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("ListSnapshots"))
              .build();
        }
      }
    }
    return getListSnapshotsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getPullSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PullSnapshot",
      requestType = com.android.emulator.control.SnapshotPackage.class,
      responseType = com.android.emulator.control.SnapshotPackage.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getPullSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage> getPullSnapshotMethod;
    if ((getPullSnapshotMethod = SnapshotServiceGrpc.getPullSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getPullSnapshotMethod = SnapshotServiceGrpc.getPullSnapshotMethod) == null) {
          SnapshotServiceGrpc.getPullSnapshotMethod = getPullSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PullSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("PullSnapshot"))
              .build();
        }
      }
    }
    return getPullSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getPushSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PushSnapshot",
      requestType = com.android.emulator.control.SnapshotPackage.class,
      responseType = com.android.emulator.control.SnapshotPackage.class,
      methodType = io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getPushSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage> getPushSnapshotMethod;
    if ((getPushSnapshotMethod = SnapshotServiceGrpc.getPushSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getPushSnapshotMethod = SnapshotServiceGrpc.getPushSnapshotMethod) == null) {
          SnapshotServiceGrpc.getPushSnapshotMethod = getPushSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PushSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("PushSnapshot"))
              .build();
        }
      }
    }
    return getPushSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getLoadSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "LoadSnapshot",
      requestType = com.android.emulator.control.SnapshotPackage.class,
      responseType = com.android.emulator.control.SnapshotPackage.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getLoadSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage> getLoadSnapshotMethod;
    if ((getLoadSnapshotMethod = SnapshotServiceGrpc.getLoadSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getLoadSnapshotMethod = SnapshotServiceGrpc.getLoadSnapshotMethod) == null) {
          SnapshotServiceGrpc.getLoadSnapshotMethod = getLoadSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "LoadSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("LoadSnapshot"))
              .build();
        }
      }
    }
    return getLoadSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getSaveSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SaveSnapshot",
      requestType = com.android.emulator.control.SnapshotPackage.class,
      responseType = com.android.emulator.control.SnapshotPackage.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getSaveSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage> getSaveSnapshotMethod;
    if ((getSaveSnapshotMethod = SnapshotServiceGrpc.getSaveSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getSaveSnapshotMethod = SnapshotServiceGrpc.getSaveSnapshotMethod) == null) {
          SnapshotServiceGrpc.getSaveSnapshotMethod = getSaveSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SaveSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("SaveSnapshot"))
              .build();
        }
      }
    }
    return getSaveSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getDeleteSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteSnapshot",
      requestType = com.android.emulator.control.SnapshotPackage.class,
      responseType = com.android.emulator.control.SnapshotPackage.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage,
      com.android.emulator.control.SnapshotPackage> getDeleteSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage> getDeleteSnapshotMethod;
    if ((getDeleteSnapshotMethod = SnapshotServiceGrpc.getDeleteSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getDeleteSnapshotMethod = SnapshotServiceGrpc.getDeleteSnapshotMethod) == null) {
          SnapshotServiceGrpc.getDeleteSnapshotMethod = getDeleteSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotPackage, com.android.emulator.control.SnapshotPackage>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotPackage.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("DeleteSnapshot"))
              .build();
        }
      }
    }
    return getDeleteSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.IceboxTarget,
      com.android.emulator.control.IceboxTarget> getTrackProcessMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "TrackProcess",
      requestType = com.android.emulator.control.IceboxTarget.class,
      responseType = com.android.emulator.control.IceboxTarget.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.IceboxTarget,
      com.android.emulator.control.IceboxTarget> getTrackProcessMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.IceboxTarget, com.android.emulator.control.IceboxTarget> getTrackProcessMethod;
    if ((getTrackProcessMethod = SnapshotServiceGrpc.getTrackProcessMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getTrackProcessMethod = SnapshotServiceGrpc.getTrackProcessMethod) == null) {
          SnapshotServiceGrpc.getTrackProcessMethod = getTrackProcessMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.IceboxTarget, com.android.emulator.control.IceboxTarget>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "TrackProcess"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.IceboxTarget.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.IceboxTarget.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("TrackProcess"))
              .build();
        }
      }
    }
    return getTrackProcessMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotUpdateDescription,
      com.android.emulator.control.SnapshotDetails> getUpdateSnapshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateSnapshot",
      requestType = com.android.emulator.control.SnapshotUpdateDescription.class,
      responseType = com.android.emulator.control.SnapshotDetails.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotUpdateDescription,
      com.android.emulator.control.SnapshotDetails> getUpdateSnapshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotUpdateDescription, com.android.emulator.control.SnapshotDetails> getUpdateSnapshotMethod;
    if ((getUpdateSnapshotMethod = SnapshotServiceGrpc.getUpdateSnapshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getUpdateSnapshotMethod = SnapshotServiceGrpc.getUpdateSnapshotMethod) == null) {
          SnapshotServiceGrpc.getUpdateSnapshotMethod = getUpdateSnapshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotUpdateDescription, com.android.emulator.control.SnapshotDetails>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateSnapshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotUpdateDescription.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotDetails.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("UpdateSnapshot"))
              .build();
        }
      }
    }
    return getUpdateSnapshotMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotId,
      com.android.emulator.control.SnapshotScreenshotFile> getGetScreenshotMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetScreenshot",
      requestType = com.android.emulator.control.SnapshotId.class,
      responseType = com.android.emulator.control.SnapshotScreenshotFile.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotId,
      com.android.emulator.control.SnapshotScreenshotFile> getGetScreenshotMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.SnapshotId, com.android.emulator.control.SnapshotScreenshotFile> getGetScreenshotMethod;
    if ((getGetScreenshotMethod = SnapshotServiceGrpc.getGetScreenshotMethod) == null) {
      synchronized (SnapshotServiceGrpc.class) {
        if ((getGetScreenshotMethod = SnapshotServiceGrpc.getGetScreenshotMethod) == null) {
          SnapshotServiceGrpc.getGetScreenshotMethod = getGetScreenshotMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.SnapshotId, com.android.emulator.control.SnapshotScreenshotFile>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetScreenshot"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotId.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.SnapshotScreenshotFile.getDefaultInstance()))
              .setSchemaDescriptor(new SnapshotServiceMethodDescriptorSupplier("GetScreenshot"))
              .build();
        }
      }
    }
    return getGetScreenshotMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static SnapshotServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceStub>() {
        @java.lang.Override
        public SnapshotServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SnapshotServiceStub(channel, callOptions);
        }
      };
    return SnapshotServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static SnapshotServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceBlockingStub>() {
        @java.lang.Override
        public SnapshotServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SnapshotServiceBlockingStub(channel, callOptions);
        }
      };
    return SnapshotServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static SnapshotServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SnapshotServiceFutureStub>() {
        @java.lang.Override
        public SnapshotServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SnapshotServiceFutureStub(channel, callOptions);
        }
      };
    return SnapshotServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The SnapshotService enables you to list, insert, store, and retrieve
   * snapshots.
   * Currently there are two types of snapshots:
   * - Local (default): These are snapshots that are created locally. They are
   *     stored internally inside qcow2 files and are very efficient. These are
   *     the snapshots usually created by interacting with the UI.
   * - Remote: These are snapshots that have been exported at a certain point.
   *     an exported snapshot is normalized (completely self contained) and
   *     can be imported into an emulator with a similar hardware configuration.
   * Currently the emulator has limited support for importing snapshots:
   * - Once an imported snapshot has been loaded into an emulator it is no longer
   * possible to create new snapshots.
   * - The hardware configuration of the emulator your are pushing a snapshot to
   * must match (or be very similar) to the one you pulled the snapshot from.
   * For example do not expect to be able to restore a snapshot on created on an
   * Intel cpu on an AMD cpu.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Lists all the snapshots, filtered by the given query, that are stored
     * locally for the currently running avd. This includes all the snapshots
     * that were imported (pushed) into this emulator.
     * Returns a list of snapshot_id's and associated details that describes
     * the hardware configuration, logical name, etc of the snapshot.
     * </pre>
     */
    default void listSnapshots(com.android.emulator.control.SnapshotFilter request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotList> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListSnapshotsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Pulls down the snapshot stored inside the AVD as a tar.gz/tar stream
     * This will normalize the snapshot, all relevant data to push a snapshot
     * into a similar emulator will be placed inside the tar file.
     * Pulling  down a snapshot will pause the emulator until the snapshots
     * are rebased and ready for exporting. Once the snapshot is rebased
     * the emulator will continue and downloading should commence.
     * Note that pulling .gz stream is slow.
     * You must provide the snapshot_id and (desired) format.
     * If SnapshotPackage.path is set, the gRPC service will directly write the
     * exported snapshot to SnapshotPackage.path without streaming, which is
     * usually significantly faster. It would require emulator to have direct
     * access to SnapshotPackage.path, which usually means it can only be used
     * when pulling from a local emulator.
     * </pre>
     */
    default void pullSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPullSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Push a tar.gz stream contain the snapshot. The tar file should
     * be a snapshot that was exported through the PullSnapshot in the past.
     * The emulator will try to import the snapshot. The hardware configuration
     * of the current emulator should match the one used for pulling.
     * A detailed description of the snapshot (emulator_snapshot.Snapshot)
     * is stored in the snapshot.pb file inside the tar.
     * You must provide the snapshot_id and format in the first message.
     * Will return success and a possible error message when a failure occurs.
     * If SnapshotPackage.path is set, the gRPC service will directly unzip the
     * exported snapshot from SnapshotPackage.path without streaming, which is
     * usually significantly faster. It would require emulator to have direct
     * access to SnapshotPackage.path, which usually means it can only be used
     * when pushing to a local emulator.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> pushSnapshot(
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getPushSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Loads the given snapshot inside the emulator and activates it.
     * The device will be in the state as it was when the snapshot was created.
     * You will no longer be able to call Save if this was an imported
     * snapshot that was pushed into this emulator.
     * You must provide the snapshot_id to indicate which snapshot to load
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    default void loadSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getLoadSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Creates as a snapshot of the current state of the emulator.
     * You can only save a snapshot if you never activated (Load) an imported
     * snapshot (Push).
     * For example:
     * - PushSnapshot("some_snap.tar.gz");
     * - LoadSnapshot("some_snap");
     * - SaveSnapshot("same_newer_snap"); // &lt;--- Will currently fail.
     * You can provide the snapshot_id to indicate the name used for storing.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    default void saveSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSaveSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Deletes the snapshot with the given snapshot_id from the avd.
     * You must provide the snapshot_id to indicate which snapshot to delete.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    default void deleteSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Tracks the given process for automated snapshot creation in case of
     * assert failures.
     * Will return success and a possible error message when a failure occurs.
     * The snapshot_id field will contain the name of the snapshot that
     * will be created. The pid field will contain the process id that is
     * being tracked.
     * </pre>
     */
    default void trackProcess(com.android.emulator.control.IceboxTarget request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.IceboxTarget> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTrackProcessMethod(), responseObserver);
    }

    /**
     * <pre>
     * Updates the snapshot details.
     * This allows you to update the description, logical name
     * of the given snapshot.
     * You must provide all the details, even if you are not changing them.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INVALID_ARGUMENT (code 3): Neither description, nor logical_name were present.
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    default void updateSnapshot(com.android.emulator.control.SnapshotUpdateDescription request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotDetails> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateSnapshotMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get the screenshot of the given snapshot
     * Returns the emlator display at time of screenshot.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    default void getScreenshot(com.android.emulator.control.SnapshotId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotScreenshotFile> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetScreenshotMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service SnapshotService.
   * <pre>
   * The SnapshotService enables you to list, insert, store, and retrieve
   * snapshots.
   * Currently there are two types of snapshots:
   * - Local (default): These are snapshots that are created locally. They are
   *     stored internally inside qcow2 files and are very efficient. These are
   *     the snapshots usually created by interacting with the UI.
   * - Remote: These are snapshots that have been exported at a certain point.
   *     an exported snapshot is normalized (completely self contained) and
   *     can be imported into an emulator with a similar hardware configuration.
   * Currently the emulator has limited support for importing snapshots:
   * - Once an imported snapshot has been loaded into an emulator it is no longer
   * possible to create new snapshots.
   * - The hardware configuration of the emulator your are pushing a snapshot to
   * must match (or be very similar) to the one you pulled the snapshot from.
   * For example do not expect to be able to restore a snapshot on created on an
   * Intel cpu on an AMD cpu.
   * </pre>
   */
  public static abstract class SnapshotServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return SnapshotServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service SnapshotService.
   * <pre>
   * The SnapshotService enables you to list, insert, store, and retrieve
   * snapshots.
   * Currently there are two types of snapshots:
   * - Local (default): These are snapshots that are created locally. They are
   *     stored internally inside qcow2 files and are very efficient. These are
   *     the snapshots usually created by interacting with the UI.
   * - Remote: These are snapshots that have been exported at a certain point.
   *     an exported snapshot is normalized (completely self contained) and
   *     can be imported into an emulator with a similar hardware configuration.
   * Currently the emulator has limited support for importing snapshots:
   * - Once an imported snapshot has been loaded into an emulator it is no longer
   * possible to create new snapshots.
   * - The hardware configuration of the emulator your are pushing a snapshot to
   * must match (or be very similar) to the one you pulled the snapshot from.
   * For example do not expect to be able to restore a snapshot on created on an
   * Intel cpu on an AMD cpu.
   * </pre>
   */
  public static final class SnapshotServiceStub
      extends io.grpc.stub.AbstractAsyncStub<SnapshotServiceStub> {
    private SnapshotServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SnapshotServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SnapshotServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists all the snapshots, filtered by the given query, that are stored
     * locally for the currently running avd. This includes all the snapshots
     * that were imported (pushed) into this emulator.
     * Returns a list of snapshot_id's and associated details that describes
     * the hardware configuration, logical name, etc of the snapshot.
     * </pre>
     */
    public void listSnapshots(com.android.emulator.control.SnapshotFilter request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotList> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListSnapshotsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Pulls down the snapshot stored inside the AVD as a tar.gz/tar stream
     * This will normalize the snapshot, all relevant data to push a snapshot
     * into a similar emulator will be placed inside the tar file.
     * Pulling  down a snapshot will pause the emulator until the snapshots
     * are rebased and ready for exporting. Once the snapshot is rebased
     * the emulator will continue and downloading should commence.
     * Note that pulling .gz stream is slow.
     * You must provide the snapshot_id and (desired) format.
     * If SnapshotPackage.path is set, the gRPC service will directly write the
     * exported snapshot to SnapshotPackage.path without streaming, which is
     * usually significantly faster. It would require emulator to have direct
     * access to SnapshotPackage.path, which usually means it can only be used
     * when pulling from a local emulator.
     * </pre>
     */
    public void pullSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getPullSnapshotMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Push a tar.gz stream contain the snapshot. The tar file should
     * be a snapshot that was exported through the PullSnapshot in the past.
     * The emulator will try to import the snapshot. The hardware configuration
     * of the current emulator should match the one used for pulling.
     * A detailed description of the snapshot (emulator_snapshot.Snapshot)
     * is stored in the snapshot.pb file inside the tar.
     * You must provide the snapshot_id and format in the first message.
     * Will return success and a possible error message when a failure occurs.
     * If SnapshotPackage.path is set, the gRPC service will directly unzip the
     * exported snapshot from SnapshotPackage.path without streaming, which is
     * usually significantly faster. It would require emulator to have direct
     * access to SnapshotPackage.path, which usually means it can only be used
     * when pushing to a local emulator.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> pushSnapshot(
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncClientStreamingCall(
          getChannel().newCall(getPushSnapshotMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Loads the given snapshot inside the emulator and activates it.
     * The device will be in the state as it was when the snapshot was created.
     * You will no longer be able to call Save if this was an imported
     * snapshot that was pushed into this emulator.
     * You must provide the snapshot_id to indicate which snapshot to load
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public void loadSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getLoadSnapshotMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Creates as a snapshot of the current state of the emulator.
     * You can only save a snapshot if you never activated (Load) an imported
     * snapshot (Push).
     * For example:
     * - PushSnapshot("some_snap.tar.gz");
     * - LoadSnapshot("some_snap");
     * - SaveSnapshot("same_newer_snap"); // &lt;--- Will currently fail.
     * You can provide the snapshot_id to indicate the name used for storing.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public void saveSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSaveSnapshotMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Deletes the snapshot with the given snapshot_id from the avd.
     * You must provide the snapshot_id to indicate which snapshot to delete.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public void deleteSnapshot(com.android.emulator.control.SnapshotPackage request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteSnapshotMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Tracks the given process for automated snapshot creation in case of
     * assert failures.
     * Will return success and a possible error message when a failure occurs.
     * The snapshot_id field will contain the name of the snapshot that
     * will be created. The pid field will contain the process id that is
     * being tracked.
     * </pre>
     */
    public void trackProcess(com.android.emulator.control.IceboxTarget request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.IceboxTarget> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTrackProcessMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Updates the snapshot details.
     * This allows you to update the description, logical name
     * of the given snapshot.
     * You must provide all the details, even if you are not changing them.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INVALID_ARGUMENT (code 3): Neither description, nor logical_name were present.
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public void updateSnapshot(com.android.emulator.control.SnapshotUpdateDescription request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotDetails> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateSnapshotMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get the screenshot of the given snapshot
     * Returns the emlator display at time of screenshot.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public void getScreenshot(com.android.emulator.control.SnapshotId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotScreenshotFile> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetScreenshotMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service SnapshotService.
   * <pre>
   * The SnapshotService enables you to list, insert, store, and retrieve
   * snapshots.
   * Currently there are two types of snapshots:
   * - Local (default): These are snapshots that are created locally. They are
   *     stored internally inside qcow2 files and are very efficient. These are
   *     the snapshots usually created by interacting with the UI.
   * - Remote: These are snapshots that have been exported at a certain point.
   *     an exported snapshot is normalized (completely self contained) and
   *     can be imported into an emulator with a similar hardware configuration.
   * Currently the emulator has limited support for importing snapshots:
   * - Once an imported snapshot has been loaded into an emulator it is no longer
   * possible to create new snapshots.
   * - The hardware configuration of the emulator your are pushing a snapshot to
   * must match (or be very similar) to the one you pulled the snapshot from.
   * For example do not expect to be able to restore a snapshot on created on an
   * Intel cpu on an AMD cpu.
   * </pre>
   */
  public static final class SnapshotServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<SnapshotServiceBlockingStub> {
    private SnapshotServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SnapshotServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SnapshotServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists all the snapshots, filtered by the given query, that are stored
     * locally for the currently running avd. This includes all the snapshots
     * that were imported (pushed) into this emulator.
     * Returns a list of snapshot_id's and associated details that describes
     * the hardware configuration, logical name, etc of the snapshot.
     * </pre>
     */
    public com.android.emulator.control.SnapshotList listSnapshots(com.android.emulator.control.SnapshotFilter request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListSnapshotsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Pulls down the snapshot stored inside the AVD as a tar.gz/tar stream
     * This will normalize the snapshot, all relevant data to push a snapshot
     * into a similar emulator will be placed inside the tar file.
     * Pulling  down a snapshot will pause the emulator until the snapshots
     * are rebased and ready for exporting. Once the snapshot is rebased
     * the emulator will continue and downloading should commence.
     * Note that pulling .gz stream is slow.
     * You must provide the snapshot_id and (desired) format.
     * If SnapshotPackage.path is set, the gRPC service will directly write the
     * exported snapshot to SnapshotPackage.path without streaming, which is
     * usually significantly faster. It would require emulator to have direct
     * access to SnapshotPackage.path, which usually means it can only be used
     * when pulling from a local emulator.
     * </pre>
     */
    public java.util.Iterator<com.android.emulator.control.SnapshotPackage> pullSnapshot(
        com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getPullSnapshotMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Loads the given snapshot inside the emulator and activates it.
     * The device will be in the state as it was when the snapshot was created.
     * You will no longer be able to call Save if this was an imported
     * snapshot that was pushed into this emulator.
     * You must provide the snapshot_id to indicate which snapshot to load
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.android.emulator.control.SnapshotPackage loadSnapshot(com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getLoadSnapshotMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Creates as a snapshot of the current state of the emulator.
     * You can only save a snapshot if you never activated (Load) an imported
     * snapshot (Push).
     * For example:
     * - PushSnapshot("some_snap.tar.gz");
     * - LoadSnapshot("some_snap");
     * - SaveSnapshot("same_newer_snap"); // &lt;--- Will currently fail.
     * You can provide the snapshot_id to indicate the name used for storing.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.android.emulator.control.SnapshotPackage saveSnapshot(com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSaveSnapshotMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Deletes the snapshot with the given snapshot_id from the avd.
     * You must provide the snapshot_id to indicate which snapshot to delete.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.android.emulator.control.SnapshotPackage deleteSnapshot(com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteSnapshotMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Tracks the given process for automated snapshot creation in case of
     * assert failures.
     * Will return success and a possible error message when a failure occurs.
     * The snapshot_id field will contain the name of the snapshot that
     * will be created. The pid field will contain the process id that is
     * being tracked.
     * </pre>
     */
    public com.android.emulator.control.IceboxTarget trackProcess(com.android.emulator.control.IceboxTarget request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTrackProcessMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Updates the snapshot details.
     * This allows you to update the description, logical name
     * of the given snapshot.
     * You must provide all the details, even if you are not changing them.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INVALID_ARGUMENT (code 3): Neither description, nor logical_name were present.
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public com.android.emulator.control.SnapshotDetails updateSnapshot(com.android.emulator.control.SnapshotUpdateDescription request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateSnapshotMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get the screenshot of the given snapshot
     * Returns the emlator display at time of screenshot.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public com.android.emulator.control.SnapshotScreenshotFile getScreenshot(com.android.emulator.control.SnapshotId request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetScreenshotMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service SnapshotService.
   * <pre>
   * The SnapshotService enables you to list, insert, store, and retrieve
   * snapshots.
   * Currently there are two types of snapshots:
   * - Local (default): These are snapshots that are created locally. They are
   *     stored internally inside qcow2 files and are very efficient. These are
   *     the snapshots usually created by interacting with the UI.
   * - Remote: These are snapshots that have been exported at a certain point.
   *     an exported snapshot is normalized (completely self contained) and
   *     can be imported into an emulator with a similar hardware configuration.
   * Currently the emulator has limited support for importing snapshots:
   * - Once an imported snapshot has been loaded into an emulator it is no longer
   * possible to create new snapshots.
   * - The hardware configuration of the emulator your are pushing a snapshot to
   * must match (or be very similar) to the one you pulled the snapshot from.
   * For example do not expect to be able to restore a snapshot on created on an
   * Intel cpu on an AMD cpu.
   * </pre>
   */
  public static final class SnapshotServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<SnapshotServiceFutureStub> {
    private SnapshotServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SnapshotServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SnapshotServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists all the snapshots, filtered by the given query, that are stored
     * locally for the currently running avd. This includes all the snapshots
     * that were imported (pushed) into this emulator.
     * Returns a list of snapshot_id's and associated details that describes
     * the hardware configuration, logical name, etc of the snapshot.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotList> listSnapshots(
        com.android.emulator.control.SnapshotFilter request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListSnapshotsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Loads the given snapshot inside the emulator and activates it.
     * The device will be in the state as it was when the snapshot was created.
     * You will no longer be able to call Save if this was an imported
     * snapshot that was pushed into this emulator.
     * You must provide the snapshot_id to indicate which snapshot to load
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotPackage> loadSnapshot(
        com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getLoadSnapshotMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Creates as a snapshot of the current state of the emulator.
     * You can only save a snapshot if you never activated (Load) an imported
     * snapshot (Push).
     * For example:
     * - PushSnapshot("some_snap.tar.gz");
     * - LoadSnapshot("some_snap");
     * - SaveSnapshot("same_newer_snap"); // &lt;--- Will currently fail.
     * You can provide the snapshot_id to indicate the name used for storing.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotPackage> saveSnapshot(
        com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSaveSnapshotMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Deletes the snapshot with the given snapshot_id from the avd.
     * You must provide the snapshot_id to indicate which snapshot to delete.
     * Will return success and a possible error message when a failure occurs.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotPackage> deleteSnapshot(
        com.android.emulator.control.SnapshotPackage request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteSnapshotMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Tracks the given process for automated snapshot creation in case of
     * assert failures.
     * Will return success and a possible error message when a failure occurs.
     * The snapshot_id field will contain the name of the snapshot that
     * will be created. The pid field will contain the process id that is
     * being tracked.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.IceboxTarget> trackProcess(
        com.android.emulator.control.IceboxTarget request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTrackProcessMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Updates the snapshot details.
     * This allows you to update the description, logical name
     * of the given snapshot.
     * You must provide all the details, even if you are not changing them.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INVALID_ARGUMENT (code 3): Neither description, nor logical_name were present.
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotDetails> updateSnapshot(
        com.android.emulator.control.SnapshotUpdateDescription request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateSnapshotMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get the screenshot of the given snapshot
     * Returns the emlator display at time of screenshot.
     * The following gRPC error codes can be returned:
     *    NOT_FOUND (code 5): The given snapshot id does not exist
     *    INTERNAL  (code 13): An internal failure occured while accessing the
     *    data.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.SnapshotScreenshotFile> getScreenshot(
        com.android.emulator.control.SnapshotId request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetScreenshotMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_SNAPSHOTS = 0;
  private static final int METHODID_PULL_SNAPSHOT = 1;
  private static final int METHODID_LOAD_SNAPSHOT = 2;
  private static final int METHODID_SAVE_SNAPSHOT = 3;
  private static final int METHODID_DELETE_SNAPSHOT = 4;
  private static final int METHODID_TRACK_PROCESS = 5;
  private static final int METHODID_UPDATE_SNAPSHOT = 6;
  private static final int METHODID_GET_SCREENSHOT = 7;
  private static final int METHODID_PUSH_SNAPSHOT = 8;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_SNAPSHOTS:
          serviceImpl.listSnapshots((com.android.emulator.control.SnapshotFilter) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotList>) responseObserver);
          break;
        case METHODID_PULL_SNAPSHOT:
          serviceImpl.pullSnapshot((com.android.emulator.control.SnapshotPackage) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage>) responseObserver);
          break;
        case METHODID_LOAD_SNAPSHOT:
          serviceImpl.loadSnapshot((com.android.emulator.control.SnapshotPackage) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage>) responseObserver);
          break;
        case METHODID_SAVE_SNAPSHOT:
          serviceImpl.saveSnapshot((com.android.emulator.control.SnapshotPackage) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage>) responseObserver);
          break;
        case METHODID_DELETE_SNAPSHOT:
          serviceImpl.deleteSnapshot((com.android.emulator.control.SnapshotPackage) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage>) responseObserver);
          break;
        case METHODID_TRACK_PROCESS:
          serviceImpl.trackProcess((com.android.emulator.control.IceboxTarget) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.IceboxTarget>) responseObserver);
          break;
        case METHODID_UPDATE_SNAPSHOT:
          serviceImpl.updateSnapshot((com.android.emulator.control.SnapshotUpdateDescription) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotDetails>) responseObserver);
          break;
        case METHODID_GET_SCREENSHOT:
          serviceImpl.getScreenshot((com.android.emulator.control.SnapshotId) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotScreenshotFile>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUSH_SNAPSHOT:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.pushSnapshot(
              (io.grpc.stub.StreamObserver<com.android.emulator.control.SnapshotPackage>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getListSnapshotsMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotFilter,
              com.android.emulator.control.SnapshotList>(
                service, METHODID_LIST_SNAPSHOTS)))
        .addMethod(
          getPullSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotPackage,
              com.android.emulator.control.SnapshotPackage>(
                service, METHODID_PULL_SNAPSHOT)))
        .addMethod(
          getPushSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncClientStreamingCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotPackage,
              com.android.emulator.control.SnapshotPackage>(
                service, METHODID_PUSH_SNAPSHOT)))
        .addMethod(
          getLoadSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotPackage,
              com.android.emulator.control.SnapshotPackage>(
                service, METHODID_LOAD_SNAPSHOT)))
        .addMethod(
          getSaveSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotPackage,
              com.android.emulator.control.SnapshotPackage>(
                service, METHODID_SAVE_SNAPSHOT)))
        .addMethod(
          getDeleteSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotPackage,
              com.android.emulator.control.SnapshotPackage>(
                service, METHODID_DELETE_SNAPSHOT)))
        .addMethod(
          getTrackProcessMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.IceboxTarget,
              com.android.emulator.control.IceboxTarget>(
                service, METHODID_TRACK_PROCESS)))
        .addMethod(
          getUpdateSnapshotMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotUpdateDescription,
              com.android.emulator.control.SnapshotDetails>(
                service, METHODID_UPDATE_SNAPSHOT)))
        .addMethod(
          getGetScreenshotMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.android.emulator.control.SnapshotId,
              com.android.emulator.control.SnapshotScreenshotFile>(
                service, METHODID_GET_SCREENSHOT)))
        .build();
  }

  private static abstract class SnapshotServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    SnapshotServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.control.SnapshotServiceOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("SnapshotService");
    }
  }

  private static final class SnapshotServiceFileDescriptorSupplier
      extends SnapshotServiceBaseDescriptorSupplier {
    SnapshotServiceFileDescriptorSupplier() {}
  }

  private static final class SnapshotServiceMethodDescriptorSupplier
      extends SnapshotServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    SnapshotServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (SnapshotServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new SnapshotServiceFileDescriptorSupplier())
              .addMethod(getListSnapshotsMethod())
              .addMethod(getPullSnapshotMethod())
              .addMethod(getPushSnapshotMethod())
              .addMethod(getLoadSnapshotMethod())
              .addMethod(getSaveSnapshotMethod())
              .addMethod(getDeleteSnapshotMethod())
              .addMethod(getTrackProcessMethod())
              .addMethod(getUpdateSnapshotMethod())
              .addMethod(getGetScreenshotMethod())
              .build();
        }
      }
    }
    return result;
  }
}
